/*
 *  $Id: vistaoftal.h 3681 2011-04-12 10:53:31Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
#pragma once

#include <api/globals.h>
#include <api/controllers/ipacscontroller.h>
#include <api/ivista.h>
#include <fooextension/studies/fooextensionstudy.h>
#include <fooextension/wxvtk/gfooextensionview.h>


#include <list>
#include <vector>
#include <map>

namespace GNC {
	namespace GCS {
		class IEntorno;
	}
}

class wxWindow;

namespace FooExtension {

	class FooExtensionView  : public GNC::GCS::IVista {
	public:
		/* Constructor */
		FooExtensionView (const GnkPtr<FooExtension::FooExtensionStudy>& study);

		/* Destructor */
		~FooExtensionView ();

		//suports save?
		virtual bool SoportaGuardar();

		//supports exportation?
		virtual bool SoportaExportar();

		//----------------------------------------------------------------------------------------------------
		//region Loading interface

		// Starts loading. Synchronous with interface.
		virtual void OnCargaIniciada();

		// Step1: LoadStudy not synchronized with interface thread
		virtual void CargarEstudio(GNC::GCS::IComando* pCmdInvocador);

		//Ends loading. Synchronous with interface
		virtual void OnCargaFinalizada();

		// Step2: init pipeline synchronous with interface
		virtual void IniciarPipeline();

		// stops pipeline, it's called if there has been an error loading study
		virtual void DetenerPipeline();

		//endregion

		//call when this view is activated
		virtual void Activar();

		//return graphic form
		virtual wxWindow* GetWindow();

		virtual void OnFocus();

		GnkPtr<FooExtension::FooExtensionStudy>& GetFooStudy()
		{
			return FooStudy;
		}
	protected:

		void BuildTitle();

		GUI::GFooExtensionView*                 GView;
		GnkPtr<FooExtension::FooExtensionStudy>     FooStudy;
	};
};
