/*
 *  
 *  $Id: wseleccion.cpp 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/globals.h>
#include "wslider.h"
#include <main/managers/widgetsmanager.h>
#include <vtkgl.h>
#include <cmath>

//region "Implementacion de WSliderBuilder"
#include <api/icontexto.h>

GNC::GCS::Widgets::WSliderBuilder::WSliderBuilder(TWidgetsManager* pManager, IContratoSlider* pContract, long gid) : GNC::GCS::Widgets::IWidgetBuilder(pManager, gid)
{
	m_pContract = pContract;
	m_MouseDown = false;
	m_Estado = WBS_Ninguno;
	m_Dentro = true;
	m_InitialSlice = 0;
}

GNC::GCS::Widgets::WSliderBuilder::~WSliderBuilder()
{
}

void GNC::GCS::Widgets::WSliderBuilder::OnMouseEvents(GNC::GCS::Eventos::EventoRaton& evento)
{
	if (!m_pManager) {
		return;
	}
	if (m_MouseDown && evento.ButtonUp(GNC::GCS::Eventos::EventoRaton::EB_IZQUIERDO)) {
		m_MouseDown = false;
		if (m_Estado != WBS_Creando) {
			m_Estado = WBS_Ninguno;
			return;
		}
		m_Estado = WBS_Ninguno;

		m_pManager->Modificado();
		evento.Skip(false);
	}
	else if (evento.ButtonDown(GNC::GCS::Eventos::EventoRaton::EB_IZQUIERDO)) {
		if (m_Estado != WBS_Ninguno) {
			return;
		}
		m_MouseDown = true;
		
		m_Start = evento.sX;
		m_Stop = m_Start;		
		m_InitialSlice = m_pContract->GetSlice();		
		
		m_pManager->Modificado();
		
		m_Estado = WBS_Creando;
		evento.Skip(false);
	}
	else if (evento.Dragging() && m_MouseDown) {
		if (m_Estado != WBS_Creando) {
			return;
		}
		
		m_Stop = evento.sX;
		
		double delta = (m_Stop - m_Start) / 5.0;
		
		int newSlice = m_InitialSlice;
		if (delta != 0.0) {
			if (delta > 0.0)  {
				newSlice += std::floor(delta);
			}
			else {
				newSlice += std::ceil(delta);
			}			
			newSlice = std::max(0, std::min(newSlice, m_pContract->GetNumberOfSlices() - 1));
		}
		if (m_pContract->GetSlice() != newSlice) {
			m_pContract->SetSlice(newSlice);
		}
		evento.Skip(false);
	}
	else if( evento.Moving() ){
		GTRACE("Moviendose");
		m_NodoMoviendose = evento.iP;
		m_Estado = WBS_Ninguno;
	}

}

void GNC::GCS::Widgets::WSliderBuilder::OnKeyEvents(TEventoTeclado&)
{

}

void GNC::GCS::Widgets::WSliderBuilder::Render(GNC::GCS::Contexto3D* c)
{

	/*
	TVector box = TVector(100, 10) * c->RefRelacionImagenPantalla();
	
	box = TVector(100, 10) * c->RefRelacionImagenPantalla();
	TVector pos = TVector(std::max(m_Start.x - box.x, std::min(m_Start.x + box.x, m_Stop.x)), m_Start.y);
	
	if (m_Estado == WBS_Creando) {
		glLineWidth(2.0f);
		glColor4f(0.0f, 0.75f, 0.0f, 1.0f);
		
		glBegin(GL_LINES);
		
			glVertex2d(m_Start.x - box.x, m_Start.y);
			glVertex2d(m_Start.x + box.x, m_Start.y);
		
			glVertex2d(m_Start.x - box.x, m_Start.y - box.y);
			glVertex2d(m_Start.x - box.x, m_Start.y + box.y);
		
			glVertex2d(m_Start.x + box.x, m_Start.y - box.y);
			glVertex2d(m_Start.x + box.x, m_Start.y + box.y);
		
		glEnd();
		
		glColor4f(0.75f, 0.0f, 0.0f, 1.0f);
		
		glLineWidth(1.5);
		glBegin(GL_LINES);
			glVertex2d(pos.x, pos.y - box.y);
			glVertex2d(pos.x, pos.y + box.y);
		glEnd();
	}
	else {

	}
	*/
}

GNC::GCS::Widgets::TipoCursor GNC::GCS::Widgets::WSliderBuilder::GetCursor()
{
	return GNC::GCS::Widgets::CUR_FLECHA;
}

//endregion
