/*
 *  
 *  $Id: welevacion.h 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <vector>

#include <api/iwidgets.h>
#include <api/icontroladoreventos.h>

#include <vtkSmartPointer.h>

class vtkImageData;
namespace GNC {
	namespace GCS {
		namespace Widgets {

			namespace Elevacion {

				//------------------------------------------------------------------

				class RepresentacionElevacion {
				public:

					typedef struct Color {
						float r;
						float g;
						float b;
						float a;

						inline void asignar(float r, float g, float b, float a)
						{
							this->r = r;
							this->g = g;
							this->b = b;
							this->a = a;
						};

					} Color;

					//region "Constructor y destructor"

					RepresentacionElevacion( bool soportaAutoBorrado = false)
					{
						m_SoportaAutoBorrado = soportaAutoBorrado;
						m_RadioCircunferencia = 15.0f;
					}

					~RepresentacionElevacion()
					{

					}

					bool SoportaAutoBorrado() {
						return m_SoportaAutoBorrado;
					}

					//region "Propiedades radiometricas"

					Color colorCircunferencia;
					Color colorCircunferenciaIluminada;
					float m_RadioCircunferencia;

					bool m_SoportaAutoBorrado;

					//endregion
				};

				typedef std::vector<GNC::GCS::Widgets::Elevacion::RepresentacionElevacion*> ListaRepresentaciones;

				//---------------------------------------------------------------------
				class IObservadorElevacion {
				public:
						virtual void OnPuntoInsertado(float x, float y) = 0;

						virtual void OnTerminarInsertar() = 0;
				};
			}

			//---------------------------------------------------------------------

			class WElevacionBuilder : public GNC::GCS::Widgets::IWidgetBuilder  {
			public:
				WElevacionBuilder(GNC::GCS::IWidgetsManager* pManager, GNC::GCS::Widgets::Elevacion::ListaRepresentaciones* pRepresentaciones, long gid);

				~WElevacionBuilder();

				virtual void SetRepresentacionActiva(int idRepresentacion);

				virtual void SetObservador (GNC::GCS::Widgets::Elevacion::IObservadorElevacion* pobservador);

				virtual void OnMouseEvents(GNC::GCS::Eventos::EventoRaton&);

				virtual void OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&);

				virtual void Render(GNC::GCS::Contexto3D* c);

				virtual GNC::GCS::Widgets::TipoCursor GetCursor();

				//region "Helpers"

				bool         m_Dentro;
				bool         m_ListaCreada;
				unsigned int m_LIndex;
				float        m_RadioCacheado; // Radio el que esta creada la display list

				virtual void BuildDisplayList();
				virtual void DestroyDisplayList();


			protected:
				GNC::GCS::Nodo				 m_NodoMoviendose;
				typedef std::list<GNC::GCS::Nodo*> TipoListaNodos;
				typedef std::list<GNC::GCS::Nodo*>::iterator TipoIteradorListaNodos;
				TipoListaNodos   m_Nodos;
				GNC::GCS::Vector m_VerticesSeleccion[2];
				bool             m_MouseDown;
				int              m_RepresentacionActiva;
				Estado           m_Estado;
				GNC::GCS::Widgets::Elevacion::ListaRepresentaciones* m_pRepresentaciones;
				GNC::GCS::Widgets::Elevacion::RepresentacionElevacion* m_pRepActiva;
				GNC::GCS::Widgets::Elevacion::IObservadorElevacion* m_pObservador;

			};
		}
	}
}
