/*
 *  
 *  $Id: dialogoalmacenarcertificado.cpp 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "dialogoalmacenarcertificado.h"
#include <api/globals.h>

#include <wx/msgdlg.h>
#include <wx/filedlg.h>
#include <wx/filename.h>
#include <openssl/ssl.h>

#include <iostream>
#include <sstream>

namespace GNC {
	namespace GUI {
		DialogoAlmacenarCertificado::DialogoAlmacenarCertificado(wxWindow *pParent, void *ssl):DialogoAlmacenarCertificadoBase(pParent) 
		{
			m_ssl = ssl;
			X509 *peer;
			char *buffer;

			peer=SSL_get_peer_certificate((SSL*)m_ssl);


			BIO* bio = BIO_new(BIO_s_mem());
			X509_print(bio,peer);
			int longitud = BIO_get_mem_data(bio, &buffer);
			std::string certificado(buffer,longitud);
			BIO_free(bio);
			X509_free(peer);

			m_pTextoCertificado->SetValue(wxString::FromUTF8(certificado.c_str()));

		}

		DialogoAlmacenarCertificado::~DialogoAlmacenarCertificado()
		{
			m_ssl = NULL;
		}

		void DialogoAlmacenarCertificado::OnGuardarClick(wxCommandEvent &)
		{
			wxFileDialog seleccionarFichero (this, _("Export Certificate"), wxT(""), wxT(""), _("PEM file (*.pem) | *.pem"),wxFD_SAVE);
			int response = seleccionarFichero.ShowModal();
			if (response == wxID_OK) {
				if(wxFileExists(seleccionarFichero.GetPath())) {
					response = wxMessageBox(_("File exists\nWould you like to overwrite it?"),_("Overwrite"),wxYES_NO | wxCANCEL,this);
					if(response != wxYES) {
						return;
					}
				}

				X509 *peer;

				peer=SSL_get_peer_certificate((SSL*)m_ssl);
				BIO* bio_out = BIO_new_file(TOPATH(seleccionarFichero.GetPath()), "w");
 				if (bio_out) {
					PEM_write_bio_X509(bio_out, peer);
				}
				BIO_free(bio_out);
				X509_free(peer);
			}
		}
	};
};
