/*
 *  
 *  $Id: herramientaslider.cpp 4400 2011-11-11 12:52:23Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include "herramientaslider.h"
#include <resources/ginkgoresourcemanager.h>


#include <iostream>
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>


GNC::HerramientaSlider::HerramientaSlider() {
	m_Activa = false;

	m_Descripcion = _Std("Slider\tCtrl+S");
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoSlider();
}

GNC::HerramientaSlider::~HerramientaSlider() {
	;
}

//region "Realización de la interfaz IHerramienta"

void GNC::HerramientaSlider::CrearPaneles( wxPanel* /*panel*/ ) {
	m_pAbstractPanelHerramientaOpciones = NULL;
}

void GNC::HerramientaSlider::ConectarContratoFalso(bool activar) {
	if (TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (TContratableWidgets::IteradorListaContratos it = TContratableWidgets::m_pListaActiva->begin(); it != TContratableWidgets::m_pListaActiva->end(); it++) {
		TContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			pC->GetManager()->EnableAnotacionDinamica(activar);
			if (activar) {
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE( "HerramientaSlider: Conectando contrato falso de vista " << TContratableWidgets::m_pVistaActiva );
			} else {
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GTRACE( "HerramientaSlider: Desconectando contrato falso de vista " << TContratableWidgets::m_pVistaActiva );
			}
		}
	}
}

void GNC::HerramientaSlider::SetVistaActiva(GNC::GCS::IVista* pVista) {
	if (pVista == NULL) {
		;
	}
	TContratableWidgets::EstablecerVistaActiva(pVista);
	TContratableSlider::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaSlider::SetVistaActiva(" <<  pVista << ")");

}

void GNC::HerramientaSlider::ConectarContratos(bool activar) {

	TContratableWidgets::ListaContratos* lista1 = TContratableWidgets::ObtenerContratosDeActiva();
	TContratableSlider::ListaContratos* lista2  = TContratableSlider::ObtenerContratosDeActiva();
	if (lista1 == NULL || lista2 == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pSliderBuilder != NULL)
			{
				delete m_pSliderBuilder;
				m_pSliderBuilder = NULL;
			}
		}
		return;
	}
	
	TContratableWidgets::IteradorListaContratos it1 = lista1->begin();
	TContratableSlider::IteradorListaContratos it2 = lista2->begin();

	for (; it1 != lista1->end() && it2 != lista2->end(); it1++, it2++) {
		TContratoWidgets* pC = (*it1);
		TContratoSlider* pS = (*it2);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE( "HerramientaSlider: Conectando contratos de vista " << TContratableWidgets::m_pVistaActiva );
				m_pSliderBuilder = new TSliderBuilder(pC->GetManager(), pS, (unsigned long)this);
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(m_pSliderBuilder->GetCursor());
			}
			else {
				GTRACE( "HerramientaSlider: Desconectando contratos de vista " << TContratableWidgets::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				// DesSubscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
				delete m_pSliderBuilder;
				m_pSliderBuilder = NULL;
			}
		}
	}
}

//endregion


//region "Eventos refinados desde los paneles"

//endregion
