/*
 *  
 *  $Id: wxprevisualizaciondicom.cpp 3673 2011-04-11 13:49:47Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include "wxprevisualizaciondicom.h"

#include <vtkImageData.h>
#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>
#include <wxVTKRenderWindowInteractor.h>
#include <vtk/vtkginkgoimageviewer.h>


wxPrevisualizacionDicom::wxPrevisualizacionDicom(wxWindow* parent, wxWindowID ) : wxPanel(parent, wxID_ANY) {
	Sizer = new wxBoxSizer( wxHORIZONTAL );
	
	ViewInteractor = NULL;
	ViewInteractor = new wxVTKRenderWindowInteractor (this, wxID_ANY,
													  wxDefaultPosition,
													  wxDefaultSize,
													  wxWANTS_CHARS | wxNO_FULL_REPAINT_ON_RESIZE,
													  wxT(""));
	
	ViewImage2D = vtkGinkgoImageViewer::New();
	
	vtkRenderer* rend = vtkRenderer::New();
	
	ViewImage2D->SetRenderWindow ( this->ViewInteractor->GetRenderWindow() );
	ViewImage2D->SetRenderer (rend);
	
	ViewImage2D->SetBackgroundColor(0.0f,0.0f,0.0f);

	ViewImage2D->SetShowAnnotations(false);
	ViewImage2D->SetInteractionOn();

	ViewImage2D->SetOrientation(vtkGinkgoImageViewer::AXIAL_ID);
	
	rend->Delete();
	
	this->SetSizer( Sizer );
	
	Sizer->Add( ViewInteractor, 1, wxEXPAND );
	
	
	this->Layout();
}

wxPrevisualizacionDicom::~wxPrevisualizacionDicom() {
	reset();
}

void wxPrevisualizacionDicom::SetInput(vtkSmartPointer<vtkImageData>& data) 
{
	if (data == NULL) {
		reset();
	}
	ViewImage2D->SetInput(data, true);
	ViewImage2D->ResetZoom();
	ViewInteractor->Render();	
}

void wxPrevisualizacionDicom::reset() {
	if (ViewImage2D != NULL) {
		ViewImage2D->Detach();
		ViewImage2D->Delete();
	}
	if (ViewInteractor != NULL) {
		ViewInteractor->Delete();
	}
}
