/*
 *  
 *  $Id: panelpaciente.h 3669 2011-04-11 10:59:33Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include "panelhistorial2base.h"
#include "panelestudio.h"
#include <map>
#include <main/controllers/controladorhistorial.h>

namespace GNC {
	namespace GUI {
		class PanelPaciente: public PanelPacienteBase, public INodoHistorial {
		public:
			PanelPaciente(INodoHistorial* pPadre,wxWindow* pParentWindow, const GNC::GCS::ControladorHistorial::ModeloSerie& modelo, bool desplegarNodo = false);
			~PanelPaciente();
			const std::string& GetIdPaciente();
			PanelEstudio* GetEstudio(const GNC::GCS::ControladorHistorial::ModeloSerie& modeloSerie);
			virtual void OnCabeceraClick(wxMouseEvent &event);
			virtual void OnPanelPacienteClick(wxMouseEvent &event);
			virtual void OnMenuMouse(wxMouseEvent &event);
			virtual void OnEliminar(wxCommandEvent &event);
			void OnLimpiarHistorial(wxCommandEvent &event);
			void OnUploadPACS(wxCommandEvent &event);
			void OnImportar(wxCommandEvent& event);
			void OnAdquirir(wxCommandEvent& event);
			void OnOpenFile(wxCommandEvent& event);
			void OnOpenFolder(wxCommandEvent& event);
			void Detach(wxWindow* pHijo);
			void Eliminar();
			virtual void OnPaint(wxPaintEvent& event);
			virtual void OnSize(wxSizeEvent &event);
			virtual void OnMouseWheel(wxMouseEvent &event);
			virtual bool EstaDesplegado();

			virtual bool SetBackgroundColour(const wxColour& colour);
			virtual void SetBorderColour(const wxColour& colour);

			//redirected to series
			void AddModeloSerie(const GNC::GCS::ControladorHistorial::ModeloSerie& modelo);
			PanelSerie* GetSeries(const std::string& uidSerie, bool forceExpand = false);
		protected:
			void Desplegar(bool show = true);
			void CrearPanelSerie(const GNC::GCS::ControladorHistorial::ModeloSerie& modelo);
			static int m_color;
			std::string m_idPaciente;
			bool m_desplegado;
			typedef std::map<std::string, PanelSerie*> TMapaSeries;
			TMapaSeries m_mapaSeries;
			//almacena temporalmente la informacin de las series del paciente hasta que este se despliega
			typedef GNC::GCS::ControladorHistorial::ListaModelosSeries TListaModelosSeries;
			TListaModelosSeries* m_pListaModelos;

		};
	}
}
