/*
 *  
 *  $Id: wxwizarddicomdirexport.h 4391 2011-11-10 13:24:05Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwizard.h>
#include <wx/wizardginkgo/wxwizardginkgobase.h>
#include <api/ientorno.h>
#include <main/controllers/pacscontroller.h>
#include <string>
#include <vector>


namespace GNC {
	namespace GUI {
		class wxWizardDicomDirExport: public wxWizardGinkgoBase
		{
		public:
			typedef std::list<std::string> TListUIDs;
			//list of series instances uids
			wxWizardDicomDirExport(wxWindow* pParent, const TListUIDs& uids = TListUIDs());
			~wxWizardDicomDirExport();

			virtual void OnCancelarClick(wxCommandEvent& event);

			virtual void OnSiguienteClick(wxCommandEvent& event);

			virtual void OnAnteriorClick(wxCommandEvent &event);

			void CargarCurrent();


			//region "Metodos de obtencion de resultados del dialogo"
			virtual bool            IsOK();

			

			//endregion


		protected:
			typedef std::vector<IPasoWizard*> ListaPasos;
			ListaPasos m_ListaPasos;
			ListaPasos::iterator m_currentPaso;

			int m_currentPasoIndex;
			bool            m_OK;

		};
	}
}
