/*
 *  
 *  $Id: filtronulo.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "filtros.h"

#include <vtkPointData.h>
#include <itkExceptionObject.h>
#include <itkImageRegionIterator.h>
#include <api/icontextoestudio.h>
//#include <AVL.h>

GNC::FiltroNulo::FiltroNulo(Implementacion implementacion, bool filtro3D) : IFiltro(implementacion, filtro3D)
{
	
}
GNC::FiltroNulo::~FiltroNulo ()
{
	
}

void GNC::FiltroNulo::Configurar()
{
	
}

void GNC::FiltroNulo::Procesar(GNC::GCS::IVista* /*pVista*/)
{
	vtkImageData* pImagenOriginal = NULL;
	int sliceStart;
	int sliceEnd;
	int slice = 0;
	//unsigned long off;
	//TODOX
	//pVista->AsignarConexionesDeFiltrado(&pImagenOriginal, &slice);
	
	if (pImagenOriginal == NULL) {
		return;
	}
	
	m_pImagen = pImagenOriginal;
	
	int* dims = m_pImagen->GetDimensions();
	int numComponentes = m_pImagen->GetNumberOfScalarComponents();
	
	if (filtro3D) {
		if(implementacion == IF_ITK) {
			double* spacing = m_pImagen->GetSpacing();
			double* origin = m_pImagen->GetOrigin();
			
			
			
			double tval[3] = {0.0f, 0.0f, 0.0f};
			vtkDataArray* scalars = m_pImagen->GetPointData()->GetScalars();
			unsigned long off = 0;
			if (numComponentes == 1) {
				TImagenITKIntensidad3D::Pointer entrada = TImagenITKIntensidad3D::New();
				
				TImagenITKIntensidad3D::IndexType inputIndex;
				inputIndex[0] = 0;
				inputIndex[1] = 0;
				inputIndex[2] = 0;
				
				TImagenITKIntensidad3D::SizeType inputSize;
				inputSize[0] = dims[0];
				inputSize[1] = dims[1];
				inputSize[2] = dims[2];
				
				TImagenITKIntensidad3D::RegionType regionEntrada;
				regionEntrada.SetIndex(inputIndex);
				regionEntrada.SetSize(inputSize);
				
				entrada->SetRegions(regionEntrada);
				
				double inputSpacing[3];
				inputSpacing[0] = spacing[0];
				inputSpacing[1] = spacing[1];
				inputSpacing[2] = spacing[2];
				
				entrada->SetSpacing(inputSpacing);
				
				double inputOrigin[3];
				inputOrigin[0] = origin[0];
				inputOrigin[1] = origin[1];
				inputOrigin[2] = origin[2];
				
				entrada->SetOrigin(inputOrigin);
				
				entrada->Allocate();
				
				itk::ImageRegionIterator<TImagenITKIntensidad3D> itEntrada (entrada, regionEntrada);
				
				off = 0;
				for (itEntrada.GoToBegin(); !itEntrada.IsAtEnd(); ++itEntrada) {
					scalars->GetTuple(off++, tval);
					itEntrada.Set(tval[0]);
				}
				
				TImagenITKIntensidad3D::Pointer salida = ProcesarImagen(entrada);
				
				if (salida.IsNull()) {
					std::cerr << "Filtro Nulo. Accion ignorada." << std::endl;
					return;
				}
				
				int outputSize[3];
				
				TImagenITKIntensidad3D::RegionType regionSalida = salida->GetLargestPossibleRegion();
				outputSize[0] = regionSalida.GetSize()[0];
				outputSize[1] = regionSalida.GetSize()[1];
				outputSize[2] = regionSalida.GetSize()[2];
				
				if (outputSize[0] != dims[0] || outputSize[1] != dims[1] || outputSize[2] != dims[2]) {
					std::cerr << "Error. El filtro ha modicado las dimensiones de la imagen. Accion ignorada." << std::endl;
					return;
				}
				
				TImagenITKIntensidad3D::SpacingType outputSpacingitk = salida->GetSpacing();
				double outputSpacingvtk[3];
				
				outputSpacingvtk[0] = outputSpacingitk[0];
				outputSpacingvtk[1] = outputSpacingitk[1];
				outputSpacingvtk[2] = spacing[2];
				m_pImagen->SetSpacing(outputSpacingvtk);
				
				TImagenITKIntensidad3D::PointType outputOriginitk = salida->GetOrigin();
				double outputOriginvtk[3];
				outputOriginvtk[0] = outputOriginitk[0];
				outputOriginvtk[1] = outputOriginitk[1];
				outputOriginvtk[2] = outputOriginitk[2];
				m_pImagen->SetOrigin(outputOriginvtk);
				
				itk::ImageRegionIterator<TImagenITKIntensidad3D> itSalida (salida, regionSalida);
				off = 0;
				for (itSalida.GoToBegin(); !itSalida.IsAtEnd(); ++itSalida) {
					tval[0] = itSalida.Get();
					scalars->SetTuple(off++, tval);
				}
				
				
				
			}
			else if (numComponentes == 3) {
				// No implementado
				return;
			}
			else {
				std::cerr << "Error al aplicar el filtro 3D: Numero de componentes no soportado. Accion ignorada" << std::endl;
				return;
			}
			
		}
		else if (implementacion == IF_MEF) {
			std::cerr << "Error al procesar: MEF no soporta imagenes 3D." << std::endl;
			return;
		}
		else {
			return;
		}
	}
	
	else {
		if (implementacion == IF_ITK) {
			
			if (slice > dims[2]) {
				m_pImagen = NULL;
				std::cerr << "Error: No se pudo aplicar el filtro. Indice de slice fuera de rango" << std::endl;
			}
			
			if (slice < 0) {
				sliceStart = 0;
				sliceEnd = dims[2];
			}
			else {
				sliceStart = slice;
				sliceEnd = slice + 1;
			}
			
			for (slice = sliceStart; slice < sliceEnd; ++slice) {
				
				double* spacing = m_pImagen->GetSpacing();
				double* origin = m_pImagen->GetOrigin();
				
				double tval[3] = {0.0f, 0.0f, 0.0f};
				vtkDataArray* scalars = m_pImagen->GetPointData()->GetScalars();
				unsigned long off = 0;
				if (numComponentes == 1) {
					
					TImagenITKIntensidad2D::Pointer entrada = TImagenITKIntensidad2D::New();
					
					TImagenITKIntensidad2D::IndexType inputIndex;
					inputIndex[0] = 0;
					inputIndex[1] = 0;
					
					TImagenITKIntensidad2D::SizeType inputSize;
					inputSize[0] = dims[0];
					inputSize[1] = dims[1];
					
					TImagenITKIntensidad2D::RegionType regionEntrada;
					regionEntrada.SetIndex(inputIndex);
					regionEntrada.SetSize(inputSize);
					
					entrada->SetRegions(regionEntrada);
					
					double inputSpacing[2];
					inputSpacing[0] = spacing[0];
					inputSpacing[1] = spacing[1];
					
					entrada->SetSpacing(inputSpacing);
					
					double inputOrigin[2];
					inputOrigin[0] = origin[0];
					inputOrigin[1] = origin[1];
					
					entrada->SetOrigin(inputOrigin);
					
					entrada->Allocate();
					
					itk::ImageRegionIterator<TImagenITKIntensidad2D> itEntrada (entrada, regionEntrada);
					
					off = dims[0] * dims[1] * slice;
					for (itEntrada.GoToBegin(); !itEntrada.IsAtEnd(); ++itEntrada) {
						scalars->GetTuple(off++, tval);
						itEntrada.Set(tval[0]);
					}
					
					TImagenITKIntensidad2D::Pointer salida = ProcesarImagen(entrada);
					
					if (salida.IsNull()) {
						std::cerr << "Filtro Nulo. Accion ignorada." << std::endl;
						return;
					}
					
					int outputSize[3];
					
					TImagenITKIntensidad2D::RegionType regionSalida = salida->GetLargestPossibleRegion();
					outputSize[0] = regionSalida.GetSize()[0];
					outputSize[1] = regionSalida.GetSize()[1];
					
					if (outputSize[0] != dims[0] || outputSize[1] != dims[1]) {
						std::cerr << "Error. El filtro ha modicado las dimensiones de la imagen. Accion ignorada." << std::endl;
						return;
					}
					
					TImagenITKIntensidad2D::SpacingType outputSpacingitk = salida->GetSpacing();
					double outputSpacingvtk[3];
					
					outputSpacingvtk[0] = outputSpacingitk[0];
					outputSpacingvtk[1] = outputSpacingitk[1];
					outputSpacingvtk[2] = spacing[2];
					m_pImagen->SetSpacing(outputSpacingvtk);
					
					TImagenITKIntensidad2D::PointType outputOriginitk = salida->GetOrigin();
					double outputOriginvtk[3];
					outputOriginvtk[0] = outputOriginitk[0];
					outputOriginvtk[1] = outputOriginitk[1];
					outputOriginvtk[2] = origin[2];
					m_pImagen->SetOrigin(outputOriginvtk);
					
					itk::ImageRegionIterator<TImagenITKIntensidad2D> itSalida (salida, regionSalida);
					
					off = dims[0] * dims[1] * slice;
					for (itSalida.GoToBegin(); !itSalida.IsAtEnd(); ++itSalida) {
						tval[0] = itSalida.Get();
						scalars->SetTuple(off++, tval);
					}
					
				}
				else if (numComponentes == 3) {
					for (long y = 0; y < dims[1]; ++y) {
						for (long x = 0; x < dims[0]; ++x) {
							scalars->SetTuple(off++, tval);
						}
					}
					/*
					 unsigned long off = 0;
					 for (it.GoToBegin(); !it.IsAtEnd(); ++it) {
					 ImageType::PixelType& pixel = it.Value();
					 scalars->SetTuple(off++, tval);
					 pixel.SetValue(tuple[0]);
					 data[off++] = pixel.GetRed();
					 data[off++] = pixel.GetGreen();
					 data[off++] = pixel.GetBlue();
					 }
					 */
				}
				else {
					std::cerr << "Error al aplicar el filtro: Numero de componentes no soportado. Accion ignorada" << std::endl;
					return;
				}
			}
		}
		else if (implementacion == IF_MEF) {
			//if (slice > dims[2]) {
			//	m_pImagen = NULL;
			//	std::cerr << "Error: No se pudo aplicar el filtro. Indice de slice fuera de rango" << std::endl;
			//	return;
			//}
			//
			//if (slice < 0) {
			//	sliceStart = 0;
			//	sliceEnd = dims[2];
			//}
			//else {
			//	sliceStart = slice;
			//	sliceEnd = slice + 1;
			//}
			//
			//for (slice = sliceStart; slice < sliceEnd; ++slice) {
			//	
			//	double tval[3] = {0.0f, 0.0f, 0.0f};
			//	vtkDataArray* scalars = m_pImagen->GetPointData()->GetScalars();
			//	unsigned long off = 0;
			//	if (numComponentes == 1) {
			//		
			//		TImagenMEFIntensidad2D* entrada = new TImagenMEFIntensidad2D(dims[0], dims[1]);
			//		
			//		if (entrada->Altura < 1 || entrada->Anchura < 1) {
			//			std::cerr << "Dimensiones de la imagen incorrectas" << std::endl;
			//			return;
			//		}
			//		off = dims[0] * dims[1] * slice;
			//		for (int y = entrada->Altura -1; y >= 0; --y) {
			//			for (int x = 0; x < entrada->Anchura; ++x) {
			//				scalars->GetTuple(off++, tval);
			//				entrada->Pixel(x, y) = tval[0];
			//			}
			//		}
			//		
			//		TImagenMEFIntensidad2D* salida = ProcesarImagen(entrada);
			//		
			//		off = dims[0] * dims[1] * slice;
			//		for (int y = entrada->Altura -1; y >= 0; --y) {
			//			for (int x = 0; x < entrada->Anchura; ++x) {
			//				tval[0] = entrada->Pixel(x, y);
			//				scalars->SetTuple(off++, tval);
			//			}
			//		}
			//		
			//		delete salida;
			//		delete entrada;
			//		
			//	}
			//	else if (numComponentes == 3) {
			//		TImagenMEFRGB2D* entrada = new TImagenMEFRGB2D(dims[0], dims[1]);
			//		
			//		if (entrada->Altura < 1 || entrada->Anchura < 1) {
			//			std::cerr << "Dimensiones de la imagen incorrectas" << std::endl;
			//			return;
			//		}
			//		off = dims[0] * dims[1] * slice;
			//		for (int y = entrada->Altura -1; y >= 0; --y) {
			//			for (int x = 0; x < entrada->Anchura; ++x) {
			//				scalars->GetTuple(off++, tval);
			//				entrada->Pixel(x, y).r = tval[0];
			//				entrada->Pixel(x, y).g = tval[1];
			//				entrada->Pixel(x, y).b = tval[2];
			//			}
			//		}
			//		
			//		TImagenMEFRGB2D* salida = ProcesarImagen(entrada);
			//		
			//		off = dims[0] * dims[1] * slice;
			//		for (int y = entrada->Altura -1; y >= 0; --y) {
			//			for (int x = 0; x < entrada->Anchura; ++x) {
			//				tval[0] = entrada->Pixel(x, y).r;
			//				tval[1] = entrada->Pixel(x, y).g;
			//				tval[2] = entrada->Pixel(x, y).b;
			//				scalars->SetTuple(off++, tval);
			//			}
			//		}
			//		
			//		delete salida;
			//		delete entrada;
			//	}
			//	else {
			//		std::cerr << "Error al aplicar el filtro: Numero de componentes no soportado. Accion ignorada" << std::endl;
			//		return;
			//	}
			//}
		}
		else {
			return;
		}
	}
	
	//TODOX
	//pVista->SolicitarActualizarImagen();
	
}

GNC::FiltroNulo::TImagenITKRGB2D::Pointer GNC::FiltroNulo::ProcesarImagen(GNC::FiltroNulo::TImagenITKRGB2D::Pointer imagen)
{
	return imagen;
}

GNC::FiltroNulo::TImagenITKRGB3D::Pointer GNC::FiltroNulo::ProcesarImagen(GNC::FiltroNulo::TImagenITKRGB3D::Pointer imagen)
{
	return imagen;
}

//GNC::FiltroNulo::TImagenMEFRGB2D* GNC::FiltroNulo::ProcesarImagen(GNC::FiltroNulo::TImagenMEFRGB2D* imagen)
//{
//	return imagen;
//}

GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer GNC::FiltroNulo::ProcesarImagen(GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer imagen)
{
	
	return imagen;
}

GNC::FiltroNulo::TImagenITKIntensidad3D::Pointer GNC::FiltroNulo::ProcesarImagen(GNC::FiltroNulo::TImagenITKIntensidad3D::Pointer imagen)
{
	
	return imagen;
}

//GNC::FiltroNulo::TImagenMEFIntensidad2D* GNC::FiltroNulo::ProcesarImagen(GNC::FiltroNulo::TImagenMEFIntensidad2D* imagen)
//{
//	
//	return imagen;
//}
