/*
*  
*  $Id: iherramientaangulo.h 3696 2011-04-14 08:40:28Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/iherramienta.h>
#include "iherramientascore.h"
#include "icontratoscore.h"

namespace GNC {
	namespace GCS {

		class EXTAPI IHerramientaAngulo: public IHerramienta, public IContratable<IContratoWidgets> {
		public:
			static const IHerramienta::UID ID = HCore_Angulo;
			IHerramientaAngulo() : IHerramienta(HCore_Angulo,TFamiliaMedicion, "CoreAngulo") {};
			virtual ~IHerramientaAngulo() {};

			virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

			virtual void ConectarContratos(bool) = 0;

			virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
				return IContratable<IContratoWidgets>::ValidaContrato(pVista);
			}
		};
	}
}
