/*
*  
*  $Id: exporttodicomdircommand.cpp 4410 2011-11-18 08:34:07Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable: 4996)
#endif


#include <dcmtk/dcmdata/dcdicdir.h>
#include <dcmtk/dcmdata/dcdeftag.h>

#include <sstream>

#include <wx/filename.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <main/controllers/configurationcontroller.h>
#include <main/controllers/controladorhistorial.h>
#include <main/controllers/dcmtk/dicommanager.h>
#include <main/entorno.h>

#include <api/globals.h>
#include <api/dicom/idicommanager.h>

#include <main/entorno.h>
#include <main/controllers/controladoreventos.h>

#include <eventos/eventosginkgo.h>

#include "exporttodicomdircommand.h"
#include "comandomergediagnosticwithimage.h"




namespace GADAPI {

	ExportToDicomDirCommand::ExportToDicomDirCommand(ExportToDicomDirCommandParams* pParams): GNC::GCS::IComando(pParams,"Export Dicom Dir")
	{
		m_pExportacionParams = pParams;
	}

	inline std::string GetRightPath(const std::string& uid, const std::string& prefix, std::map<std::string, int>& mapOfUids, int& index)
	{
		std::string pathOfUid;
		if (mapOfUids.find(uid) == mapOfUids.end()) {
			mapOfUids[uid] = index;
			std::ostringstream ostr;
			ostr << prefix << index++;
			pathOfUid = ostr.str();
		} else {
			std::ostringstream ostr;
			ostr << prefix << mapOfUids[uid];
			pathOfUid = ostr.str();
		}
		return pathOfUid;
	}

	inline bool CreateDir(const wxString& path) 
	{
		if (!wxDirExists(path)) {
			if (!wxFileName::Mkdir(path)) {
				return false;
			}
		}
		return true;
	}

	inline bool CreatePathOfSeries(const GNC::GCS::IControladorHistorial::ModeloSerie& seriesModel, 
		std::map<std::string, int>& mapOfPathPatients, 
		std::map<std::string, int>& mapOfPathStudies, 
		std::map<std::string, int>& mapOfPathSeries,
		int& patientIndex,
		int& studyIndex,
		int& seriesIndex,
		const std::string& destinationPath,
		std::string& pathOfPatient,
		std::string& pathOfStudy,
		std::string& pathOfSeries, 
		wxString& fullPath)
	{
		pathOfPatient = GetRightPath(seriesModel.m_idPaciente, "PT", mapOfPathPatients, patientIndex);
		pathOfStudy = GetRightPath(seriesModel.m_uidEstudio, "ST", mapOfPathStudies, studyIndex);
		pathOfSeries = GetRightPath(seriesModel.m_uidSerie, "SE", mapOfPathSeries, seriesIndex);

		fullPath = FROMPATH(destinationPath) + wxFileName::GetPathSeparator() + wxT("DICOM");
		if (!CreateDir(fullPath)) {
			return false;
		}
		fullPath += wxFileName::GetPathSeparator() + wxString::FromUTF8(pathOfPatient.c_str());
		if (!CreateDir(fullPath)) {
			return false;
		}
		fullPath +=	wxFileName::GetPathSeparator() + wxString::FromUTF8(pathOfStudy.c_str());
		if (!CreateDir(fullPath)) {
			return false;
		}
		fullPath += wxFileName::GetPathSeparator() + wxString::FromUTF8(pathOfSeries.c_str());
		if (!CreateDir(fullPath)) {
			return false;
		}
		return true;
	}

	inline void InsertTagRecord(const DcmTagKey& key, const std::string& value, DcmDirectoryRecord* record) 
	{
		DcmTag tag(key);
		DcmElement* e = newDicomElement(tag);
		e->putString(value.c_str());	
		record->insert(e, true, false);
	}

	inline DcmDirectoryRecord* GetSeriesRecord(const GNC::GCS::IControladorHistorial::ModeloSerie& seriesModel, 
		std::map<std::string, DcmDirectoryRecord*>& dcmMapOfPatients, 
		std::map<std::string, DcmDirectoryRecord*>& dcmMapOfStudies, 
		std::map<std::string, DcmDirectoryRecord*>& dcmMapOfSeries,
		DcmDirectoryRecord * root)
	{
		DcmDirectoryRecord* PatientRecord;
		if (dcmMapOfPatients.find(seriesModel.m_idPaciente) == dcmMapOfPatients.end()) {
			PatientRecord = new DcmDirectoryRecord();
			dcmMapOfPatients[seriesModel.m_idPaciente] = PatientRecord;
			root->insertSub(PatientRecord);
			InsertTagRecord(DCM_DirectoryRecordType, "PATIENT", PatientRecord);
			InsertTagRecord(DCM_SpecificCharacterSet, "ISO_IR 192", PatientRecord);
			InsertTagRecord(DCM_PatientID, seriesModel.m_idPaciente, PatientRecord);
			InsertTagRecord(DCM_PatientName, seriesModel.m_nombrePaciente, PatientRecord);
			{
				std::ostringstream ostr;
				ostr << seriesModel.m_sexo;
				InsertTagRecord(DCM_PatientSex, ostr.str(), PatientRecord);
			}
			InsertTagRecord(DCM_PatientBirthDate, seriesModel.m_fechaNacimiento, PatientRecord);
		} else {
			PatientRecord = dcmMapOfPatients[seriesModel.m_idPaciente];
		}

		DcmDirectoryRecord* StudyRecord;
		if (dcmMapOfStudies.find(seriesModel.m_uidEstudio) == dcmMapOfStudies.end()) {
			StudyRecord = new DcmDirectoryRecord();
			dcmMapOfStudies[seriesModel.m_uidEstudio] = StudyRecord;
			PatientRecord->insertSub(StudyRecord);
			InsertTagRecord(DCM_DirectoryRecordType, "STUDY", StudyRecord);
			InsertTagRecord(DCM_SpecificCharacterSet, "ISO_IR 192", StudyRecord);
			InsertTagRecord(DCM_StudyInstanceUID, seriesModel.m_uidEstudio, StudyRecord);
			InsertTagRecord(DCM_StudyDescription, seriesModel.m_descripcionEstudio, StudyRecord);
			InsertTagRecord(DCM_StudyDate, seriesModel.m_fechaEstudio, StudyRecord);
			InsertTagRecord(DCM_StudyTime, seriesModel.m_horaEstudio, StudyRecord);
			InsertTagRecord(DCM_AccessionNumber, seriesModel.m_accessionNumber, StudyRecord);
			InsertTagRecord(DCM_StudyID, seriesModel.m_studyId, StudyRecord);
		} else {
			StudyRecord = dcmMapOfStudies[seriesModel.m_uidEstudio];
		}

		DcmDirectoryRecord* SeriesRecord;
		if (dcmMapOfSeries.find(seriesModel.m_uidEstudio) == dcmMapOfSeries.end()) {
			SeriesRecord = new DcmDirectoryRecord();
			dcmMapOfSeries[seriesModel.m_uidSerie] = SeriesRecord;
			StudyRecord->insertSub(SeriesRecord);
			InsertTagRecord(DCM_DirectoryRecordType, "SERIES", SeriesRecord);
			InsertTagRecord(DCM_SpecificCharacterSet, "ISO_IR 192", SeriesRecord);
			InsertTagRecord(DCM_SeriesInstanceUID, seriesModel.m_uidSerie, SeriesRecord);
			InsertTagRecord(DCM_SeriesDescription, seriesModel.m_descripcionSerie, SeriesRecord);
			InsertTagRecord(DCM_SeriesDate, seriesModel.m_fechaSerie, SeriesRecord);
			InsertTagRecord(DCM_SeriesTime, seriesModel.m_horaSerie, SeriesRecord);
			InsertTagRecord(DCM_Modality, seriesModel.m_modalidad, SeriesRecord);
			InsertTagRecord(DCM_SeriesNumber, seriesModel.m_seriesNumber, SeriesRecord);
		} else {
			SeriesRecord = dcmMapOfSeries[seriesModel.m_uidSerie];
		}

		return SeriesRecord;
	}

	void ExportToDicomDirCommand::Execute()
	{
		if (!NotificarProgreso(0.0, _Std("Exporting files...")) )
			return;

		std::map<std::string, int> mapOfPathPatients;
		std::map<std::string, int> mapOfPathStudies;
		std::map<std::string, int> mapOfPathSeries;
		std::map<std::string, int> mapOfPathImages;

		std::map<std::string, DcmDirectoryRecord*> dcmMapOfPatients;
		std::map<std::string, DcmDirectoryRecord*> dcmMapOfStudies;
		std::map<std::string, DcmDirectoryRecord*> dcmMapOfSeries;

		std::string pathOfPatient, pathOfStudy, pathOfSeries;

		int patientIndex=0, studyIndex=0, seriesIndex=0;

		int numberOfSeries = m_pExportacionParams->m_seriesList.size() + m_pExportacionParams->m_diagnosticList.size();
		int actualSerie = 1;

		std::string pathOfDicomDir;
		{
			std::ostringstream ostr;
			ostr << m_pExportacionParams->m_destinationPath;
			ostr << (char)wxFileName::GetPathSeparator();
			ostr << "DICOMDIR";
			pathOfDicomDir = ostr.str();
		}

		DcmDicomDir dicomDir(pathOfDicomDir.c_str(), "GINKGOCADXCD");
		DcmDirectoryRecord *   root = &(dicomDir.getRootRecord());
		
		//FIRST OF ALL EXPORT WITHOUT ANONYMIZE
		if (m_pExportacionParams->m_seriesList.size() > 0 && m_pExportacionParams->m_anonymized.tags.empty() && m_pExportacionParams->m_includeGinkgoTags) 
		{
			for (ExportToDicomDirCommandParams::TListOfUIDs::const_iterator itUids = m_pExportacionParams->m_seriesList.begin(); itUids != m_pExportacionParams->m_seriesList.end(); ++itUids)
			{
				wxString cadena = wxString::Format(_("Exporting series %d of %d"), actualSerie++, numberOfSeries);
				if (!NotificarProgreso((float)actualSerie/numberOfSeries, std::string(cadena.ToUTF8())))
					return;
				//find source paths and series model
				GNC::GCS::IControladorHistorial::ListaModelosDCM models;

				GNC::GCS::ControladorHistorial::Instance()->GetAllModelosDCMSeries((*itUids), models);

				if (models.empty()) {
					m_pExportacionParams->m_Error = _Std("Some of selected series has been deleted");
					m_pExportacionParams->m_hasError = true;
					return;
				}
				const GNC::GCS::IControladorHistorial::ModeloSerie& seriesModel = models.front();

				//get path of series
				wxString fullPathWx;
				if (!CreatePathOfSeries(seriesModel, mapOfPathPatients, mapOfPathStudies, mapOfPathSeries, patientIndex, studyIndex, seriesIndex, m_pExportacionParams->m_destinationPath, pathOfPatient, pathOfStudy, pathOfSeries, fullPathWx) ) {
					m_pExportacionParams->m_Error = _Std("There was an error creating directory");
					m_pExportacionParams->m_hasError = true;
					return;
				}
					
				//dicomdir structure
				DcmDirectoryRecord* SeriesRecord = GetSeriesRecord(seriesModel, dcmMapOfPatients, dcmMapOfStudies, dcmMapOfSeries, root);

				//path is created, now we are going to copy images...	
				mapOfPathImages[seriesModel.m_uidSerie] = 0;
				for (GNC::GCS::IControladorHistorial::ListaModelosDCM::const_iterator itDCMModels = models.begin(); itDCMModels != models.end(); ++itDCMModels)
				{
					std::string pathOfImage;
					{
						std::ostringstream ostr;
						ostr << "IM";
						ostr << mapOfPathImages[seriesModel.m_uidSerie]++;
						pathOfImage = ostr.str();
					}

					wxString pathOfImageWx = fullPathWx + wxFileName::GetPathSeparator() + wxString::FromUTF8(pathOfImage.c_str());
					std::string absolutepathFile = GNC::Entorno::Instance()->GetPathAbsolutoFichero((*itDCMModels).m_pathRelativo);
					if (!wxCopyFile(FROMPATH(absolutepathFile),  pathOfImageWx)) {
						m_pExportacionParams->m_Error = _Std("There was an error writing file");
						m_pExportacionParams->m_hasError = true;
						return;
					}
					DcmDirectoryRecord* ImageRecord = new DcmDirectoryRecord();
					SeriesRecord->insertSub(ImageRecord);
					std::string fileId;
					{
						std::ostringstream ostr;
						ostr << "DICOM" << "\\" << pathOfPatient << "\\" << pathOfStudy << "\\" << pathOfSeries << "\\" << pathOfImage;
						fileId = ostr.str();
					}
					InsertTagRecord(DCM_DirectoryRecordType, "IMAGE", ImageRecord);
					InsertTagRecord(DCM_ReferencedSOPInstanceUIDInFile, (*itDCMModels).m_uidImagen, ImageRecord);
					InsertTagRecord(DCM_ReferencedTransferSyntaxUIDInFile, (*itDCMModels).m_uidTransferSyntax, ImageRecord);
					InsertTagRecord(DCM_ReferencedSOPClassUIDInFile, (*itDCMModels).m_sopClassUID, ImageRecord);
					InsertTagRecord(DCM_SpecificCharacterSet, "ISO_IR 192", ImageRecord);
					InsertTagRecord(DCM_ImageComments, (*itDCMModels).m_descripcionImagen, ImageRecord);
					std::string instanceNumber;
					{
						std::ostringstream ostr;
						ostr << (*itDCMModels).m_instanceNumber;
						instanceNumber = ostr.str();
					}
					InsertTagRecord(DCM_InstanceNumber, instanceNumber, ImageRecord);
					InsertTagRecord(DCM_ReferencedFileID, fileId, ImageRecord);
				}
			}
		}///END EXPORT WITHOUT ANONYMIZE
		std::string m_TmpDir = GNC::Entorno::Instance()->CrearDirectorioTemporal();
		//export series anonymizing...
		if (m_pExportacionParams->m_seriesList.size() > 0 && (!m_pExportacionParams->m_anonymized.tags.empty() || !m_pExportacionParams->m_includeGinkgoTags)) 
		{
			for (ExportToDicomDirCommandParams::TListOfUIDs::const_iterator itUids = m_pExportacionParams->m_seriesList.begin(); itUids != m_pExportacionParams->m_seriesList.end(); ++itUids)
			{
				wxString cadena = wxString::Format(_("Exporting series %d of %d"), actualSerie++, numberOfSeries);
				if (!NotificarProgreso((float)actualSerie/numberOfSeries, std::string(cadena.ToUTF8())))
					return;
				//find source paths and series model
				GNC::GCS::IControladorHistorial::VectorPaths paths = GNC::GCS::ControladorHistorial::Instance()->GetPathsSerieOrdenados((*itUids));
				for (GNC::GCS::IControladorHistorial::VectorPaths::const_iterator itPaths = paths.begin(); itPaths != paths.end(); ++itPaths) {
					GIL::DICOM::DICOMManager manager;
					manager.CargarFichero((*itPaths));
					manager.ActualizarJerarquia(m_pExportacionParams->m_anonymized);
					if (!m_pExportacionParams->m_includeGinkgoTags) {
						manager.AnonimizarTagsPrivados();
					}
					wxString targetFile = FROMPATH(m_TmpDir) + wxFileName::GetPathSeparator() + wxString::Format(wxT("%d"), rand());
					while (wxFileExists(targetFile)) {
						targetFile = FROMPATH(m_TmpDir) + wxFileName::GetPathSeparator() + wxString::Format(wxT("%d"), rand());
					}
					std::string targetFileStd(TOPATH(targetFile));
					if (!manager.AlmacenarFichero(targetFileStd)) {
						m_pExportacionParams->m_Error = _Std("There was an error anonymizing files");
						m_pExportacionParams->m_hasError = true;
						return;
					}
				}				
			}
		}
		//EXPORT MERGING...
		if (m_pExportacionParams->m_diagnosticList.size() > 0) 
		{
			for (ExportToDicomDirCommandParams::TListOfUIDs::const_iterator itUids = m_pExportacionParams->m_diagnosticList.begin(); itUids != m_pExportacionParams->m_diagnosticList.end(); ++itUids)
			{
				wxString cadena = wxString::Format(_("Exporting series %d of %d"), actualSerie++, numberOfSeries);
				if (!NotificarProgreso((float)actualSerie/numberOfSeries, std::string(cadena.ToUTF8())))
					return;
				GADAPI::ComandoMergeDiagnosticWithImageParams* params = new GADAPI::ComandoMergeDiagnosticWithImageParams(m_TmpDir, (*itUids), m_pExportacionParams->m_anonymized, m_pExportacionParams->m_includeGinkgoTags);
				GADAPI::ComandoMergeDiagnosticWithImage cmd(params);
				cmd.Execute();
			}			
		}
		//Anonymize...
		//TODO!!
		//read tmp directory and insert into dcmdir...
		{
			wxString tmpDirWx = FROMPATH(m_TmpDir);
			wxDir dir;
			if (dir.Open(tmpDirWx)) {
				wxString fileName;
				bool cont = dir.GetFirst(&fileName);
				while (cont) {
					fileName=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +fileName;

					GIL::DICOM::DICOMManager manager;
					GIL::DICOM::TipoJerarquia base;
					const std::string fileNameStd(TOPATH(fileName));
					manager.CargarFichero(fileNameStd, base);

					GNC::GCS::IControladorHistorial::ModeloSerie seriesModel;

					//patient
					base.getTag("0010|0020", seriesModel.m_idPaciente);
					base.getTag("0010|0010", seriesModel.m_nombrePaciente);
					std::string sex;
					base.getTag("0010|0040", sex);
					if (!sex.empty()) {
						seriesModel.m_sexo = sex[0];
					}
					base.getTag("0010|0030", seriesModel.m_fechaNacimiento);

					//study
					base.getTag("0020|000d", seriesModel.m_uidEstudio);
					base.getTag("0008|1030", seriesModel.m_descripcionEstudio);
					base.getTag("0008|0020", seriesModel.m_fechaEstudio);
					base.getTag("0008|0030", seriesModel.m_horaEstudio);
					base.getTag("0008|0050", seriesModel.m_accessionNumber);
					base.getTag("0020|0010", seriesModel.m_studyId);

					//series
					base.getTag("0020|000e", seriesModel.m_uidSerie);
					base.getTag("0008|103e", seriesModel.m_descripcionSerie);
					base.getTag("0008|0021", seriesModel.m_fechaSerie);
					base.getTag("0008|0031", seriesModel.m_horaSerie);
					base.getTag("0008|0060", seriesModel.m_modalidad);
					base.getTag("0020|0011", seriesModel.m_seriesNumber);

					//create path
					wxString fullPathWx;
					if (!CreatePathOfSeries(seriesModel, mapOfPathPatients, mapOfPathStudies, mapOfPathSeries, patientIndex, studyIndex, seriesIndex, m_pExportacionParams->m_destinationPath, pathOfPatient, pathOfStudy, pathOfSeries, fullPathWx) ) {
						m_pExportacionParams->m_Error = _Std("There was an error creating directory");
						m_pExportacionParams->m_hasError = true;
						return;
					}
						
					//dicomdir structure
					DcmDirectoryRecord* SeriesRecord = GetSeriesRecord(seriesModel, dcmMapOfPatients, dcmMapOfStudies, dcmMapOfSeries, root);

					//path is created, now we are going to copy images...	
					if (mapOfPathImages.find(seriesModel.m_uidSerie) == mapOfPathImages.end()) {
						mapOfPathImages[seriesModel.m_uidSerie] = 0;
					}
					std::string pathOfImage;
					{
						std::ostringstream ostr;
						ostr << "IM";
						ostr << mapOfPathImages[seriesModel.m_uidSerie]++;
						pathOfImage = ostr.str();
					}

					wxString pathOfImageWx = fullPathWx + wxFileName::GetPathSeparator() + wxString::FromUTF8(pathOfImage.c_str());
					//moving tmp files...
					if (!wxRenameFile(fileName, pathOfImageWx)) {
						m_pExportacionParams->m_Error = _Std("There was an error writing file");
						m_pExportacionParams->m_hasError = true;
						return;
					}

					DcmDirectoryRecord* ImageRecord = new DcmDirectoryRecord();
					SeriesRecord->insertSub(ImageRecord);
					std::string fileId;
					{
						std::ostringstream ostr;
						ostr << "DICOM" << "\\" << pathOfPatient << "\\" << pathOfStudy << "\\" << pathOfSeries << "\\" << pathOfImage;
						fileId = ostr.str();
					}
					InsertTagRecord(DCM_ReferencedFileID, fileId, ImageRecord);
					InsertTagRecord(DCM_DirectoryRecordType, "IMAGE", ImageRecord);
					std::string tmp;
					if (base.getTag("0008|0018",tmp)) //sop instance uid
						InsertTagRecord(DCM_ReferencedSOPInstanceUIDInFile, tmp, ImageRecord);
					if (base.getTag("0002|0010",tmp))//transfer syntax
						InsertTagRecord(DCM_ReferencedTransferSyntaxUIDInFile, tmp, ImageRecord);
					if (base.getTag("0002|0002",tmp))//media storage sop class
						InsertTagRecord(DCM_ReferencedTransferSyntaxUIDInFile, tmp, ImageRecord);
					if (base.getTag("0020|0013",tmp))//instance number 
						InsertTagRecord(DCM_InstanceNumber, tmp, ImageRecord);
					if (base.getTag("0020|4000",tmp)) //image comments
						InsertTagRecord(DCM_ImageComments, tmp, ImageRecord);
					InsertTagRecord(DCM_SpecificCharacterSet, "ISO_IR 192", ImageRecord);

					cont = dir.GetNext(&fileName);
				}
			}

		}
		OFCondition cond = dicomDir.write();
		std::cout << cond.text() << std::endl;
	}



	void ExportToDicomDirCommand::Update()
	{
		if (m_pExportacionParams->m_hasError)
		{
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoMensajes(NULL,m_pExportacionParams->m_Error, GNC::GCS::Eventos::EventoMensajes::StatusMessage,true, GNC::GCS::Eventos::EventoMensajes::Error));
		} else {
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoMensajes(NULL, _Std("Export has been finished successfully"), GNC::GCS::Eventos::EventoMensajes::StatusMessage,true, GNC::GCS::Eventos::EventoMensajes::Informacion));
		}
	}

	//endregion

};

#ifdef _MSC_VER
#pragma warning(pop)
#endif

