/*
 *
 *  $Id: initwx.cpp 4406 2011-11-16 09:53:14Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */

#define SINGLE_INSTANCE
#if defined (_WIN32) && defined (_GINKGO_DEBUG)
#if defined _GINKGO_CHECK_LEAKS
#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>
#endif
#endif

#include <cctype>
#include <string>
#include <algorithm>
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <fcntl.h>

#include <wx/image.h>
#include <wx/splash.h>
#include <wx/msgout.h>
#include <wx/msgdlg.h>
#include <wx/dcmemory.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/filename.h>
#include <wx/stdpaths.h>
#include <wx/dir.h>
#include <wx/sysopt.h>
#include <wx/log.h>
#include <wx/datetime.h>
#include <wx/stdpaths.h>
#include <wx/filename.h>
#include <wx/wfstream.h>
#include <wx/wxsqlite3/wxsqlite3.h>
#include <wx/socket.h>
#include "singleinstance.h"
#include "initwx.h"

#if defined(__DEPRECATED)
#undef __DEPRECATED
#endif

#include <vtkPolyDataMapper.h>

#if defined(_GINKGO_DEBUG) && !defined(OMITIR_VENTANA_ERRORES_VTK)
#include <vtkObject.h>
#include <itkObject.h>
#endif

#if defined(_WIN32)
#include <windows.h>
#include <io.h>
#endif
#if defined(_WIN32) && defined(_GINKGO_DEBUG)
//#include <vld.h>
#endif
#if !defined(_WIN32)
#include <sys/signal.h>
#endif

#include <main/licencia.h>
#include <api/globals.h>
#include <api/imodulo.h>
#include <api/icontroladormodulo.h>
#include <api/dicom/idicomconformance.h>
#include <eventos/eventosginkgo.h>


#include "main/entorno.h"

#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorvistas.h>
#include <main/controllers/controladorcomandos.h>
#include <main/controllers/controladorherramientas.h>
#include <main/controllers/pacscontroller.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorcarga.h>
#include <main/controllers/controladorhl7.h>
#include <main/controllers/controladorenviohl7.h>
#include <main/controllers/controladorhistorial.h>
#include <main/controllers/controladorpermisos.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/controladorbbddhl7.h>
#include <main/controllers/controladoracciones.h>
#include <main/controllers/dcmtk/dicomservers.h>
#include <main/controllers/controladorinternacionalizacion.h>
#include <main/controllers/controladorautenticacion.h>
#include <main/tools/herramientascore.h>
#include <main/controllers/xmlrpccontroller.h>
#include <main/controllers/configurationcontroller.h>

#include <main/gui/mainwindow/ventanaprincipal.h>

#include <resources/ginkgoresourcemanager.h>

#define _GINKGO_ENABLE_SPLASH

using namespace GIL;

#if defined(_WIN32)

void RedirectIOToConsole()
{

	CONSOLE_SCREEN_BUFFER_INFO coninfo;
	FILE *fp;

	// allocate a console for this app
	AllocConsole();

	// set the screen buffer to be big enough to let us scroll text
	GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE),
		&coninfo);
	coninfo.dwSize.Y = 9999;
	SetConsoleScreenBufferSize(GetStdHandle(STD_OUTPUT_HANDLE),
		coninfo.dwSize);

	// redirect unbuffered STDOUT to the console
	long lStdHandle = (long) GetStdHandle(STD_OUTPUT_HANDLE);
	long hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
	fp = _fdopen(hConHandle, "w");
	*stdout = *fp;
	//setvbuf(stdout, NULL, _IONBF, 0);

	// redirect unbuffered STDIN to the console
	lStdHandle = (long) GetStdHandle(STD_INPUT_HANDLE);
	hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
	fp = _fdopen(hConHandle, "r");
	*stdin = *fp;
	//setvbuf(stdin, NULL, _IONBF, 0);

	// redirect unbuffered STDERR to the console
	lStdHandle = (long) GetStdHandle(STD_ERROR_HANDLE);
	hConHandle = _open_osfhandle(lStdHandle, _O_TEXT);
	fp = _fdopen(hConHandle, "w");
	*stderr = *fp;
	//setvbuf(stderr, NULL, _IONBF, 0);

	// make cout, wcout, cin, wcin, wcerr, cerr, wclog and clog
	// point to console as well
	//ios::sync_with_stdio();
}

#endif

//Punto de entrada
IMPLEMENT_APP_NO_MAIN(Ginkgo)
#if defined(_WIN32)
int WINAPI InitWX(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	return wxEntry(hInstance, hPrevInstance, lpCmdLine, nCmdShow);
}
#else
int InitWX(int argc, char** argv)
{
	return wxEntry(argc, argv);
}
#endif

void Ginkgo::ProcesarEvento(GNC::GCS::Eventos::IEvento* evt)
{
	GNC::GCS::Eventos::EventHideSplashWindow* pEvt = dynamic_cast<GNC::GCS::Eventos::EventHideSplashWindow*>(evt);
	if (pEvt != NULL) {
		if (m_pVentanaLogo != NULL) {
			m_pVentanaLogo->Hide();
		}
	}
}

/* Carga las extensiones de plugins Ginkgo (Bibliotecas externas .plugin) */
void Ginkgo::LoadPlugins()
{
	GNC::ControladorExtensiones::Instance();	
}

void Ginkgo::OnSplashClose(wxCloseEvent& WXUNUSED(event))
{
	m_pVentanaLogo = NULL;
}

// Evento de incialización de la aplicación

bool Ginkgo::OnInit()
{
	GNC::GCS::ControladorEventos::Instance()->Registrar(this, GNC::GCS::Eventos::EventHideSplashWindow());

	setlocale(LC_NUMERIC, "C");

#if defined(__WXOSX__)
	m_Inicializado = false;
#endif
	//std::cout << "OnInit()" << std::endl;
#if defined(_GINKGO_DEBUG) && defined(_WINDOWS) && defined (_GINKGO_CHECK_LEAKS)
	_CrtSetDbgFlag ( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
	_CrtSetReportMode( _CRT_ERROR, _CRTDBG_MODE_DEBUG );
#endif

#if defined(_WIN32) && defined(_GINKGO_DEBUG)
	RedirectIOToConsole();
#endif

	wxSocketBase::Initialize();

	wxLog *logger = new wxLogStderr();
	wxLog::SetActiveTarget(logger);
	wxSQLite3Database::InitializeSQLite();

	WriteHeaderLog();

	#if defined(SINGLE_INSTANCE)

	//check numero de instancias del programa
	const wxString inst_name = wxString::Format(wxT("Ginkgo-%s"), wxGetUserId().c_str());
	m_singleInstanceChecker.Create(inst_name);
	#if defined(_WINDOWS)
	const wxString& name = inst_name;
	#else
	const wxString name(wxT("40000"));
	#endif
	//esto es para que no casque
	m_pServer = NULL;
	//comprobación una instancia
	//If using a single instance, use IPC to
	// communicate with the other instance
	if (!m_singleInstanceChecker.IsAnotherRunning())
	{
		// Create a new server
		m_pServer = new stServer;
		if ( !m_pServer->Create( name ) )
		{
			//NO ha podido crearse el servidor......
			LOG_ERROR("Core", "Error creating IPC server");
		}
	} else {
		GNC::Entorno::Instance()->SetChildInstance(true);
		LOG_INFO("Core", "Ginkgo client instance initiallized");
		m_pServer = NULL;
		// OK, there IS another one running, so try to connect to it
		// and send it any filename before exiting.
		stClient* client = new stClient;
		// ignored under DDE, host name in TCP/IP based classes
		wxString hostName = wxT("localhost");
		// Create the connection
		wxConnectionBase* connection =
			client->MakeConnection(hostName,
			name, inst_name);
		if (connection)
		{
			wxFileName fileName;
			if (argc == 2) {
				fileName = wxFileName(argv[1]);
				if (fileName.IsRelative()) {
					#if defined(__WXGTK__)
					char* invocation_dir = getenv("INVOCATION_DIR");					
					if (invocation_dir != NULL) {
						wxString invocationDir = wxString::FromUTF8(invocation_dir);
						if (!invocationDir.IsEmpty()) {
							fileName = invocationDir + wxFileName::GetPathSeparator() + fileName.GetFullPath();
						}
					}					
					#else
					fileName.MakeAbsolute();
					#endif
				}			
				if (fileName.IsOk() && ((fileName.FileExists() && fileName.IsFileReadable()) || (wxDirExists(fileName.GetFullPath()) && fileName.IsDirReadable()))) {
					LOG_INFO("Core", "The client sends following file: " << fileName.GetFullPath().ToUTF8());
					// Ask the other instance to open a file or raise itself
					connection->Execute(fileName.GetFullPath());
					connection->Disconnect();
					delete connection;
				}
				else {
					wxString err = wxString::Format(wxT("Error: The file %s does not exists or is not readable"), argv[1]);
					LOG_ERROR("Core", TOPATH(err));
					wxMessageBox(err, wxT("Ginkgo CADx"), wxICON_INFORMATION|wxOK);
				}			
			} else {
				// Ask the other instance to open a file or raise itself
				connection->Execute(wxT(""));
				connection->Disconnect();
				delete connection;
			}
		}
		else
		{
			LOG_ERROR("Core", "The client could not communicate with server because the server had opened modal dialogs");
			wxMessageBox(wxT("Sorry, the existing instance may be too busy too respond.\nPlease close any open dialogs and retry."),
				wxT("Ginkgo CADx"), wxICON_INFORMATION|wxOK);
		}
		delete client;

		//nos salimos limpiamente sin dejar leaks
		GNC::GCS::ControladorLog::FreeInstance();
		GNC::Entorno::FreeInstance();
		GNC::GCS::ConfigurationController::FreeInstance();
		return false;
	}
	#endif

	//inicializamos la intrnacionalizacion del core
	{
		GNC::GCS::ControladorInternacionalizacion::Instance()->AddCatalog("ginkgocadxcore");
	}
	//permisos del core
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.restrictions", _Std("Ginkgo CADx restrictions"), "anonymous_history", _Std("Anonymous mode (history is cleaned)"), false, "", false);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.restrictions", _Std("Ginkgo CADx restrictions"), "max_tabs", _Std("Max number of tabs opened"), false, "2", false);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.restrictions", _Std("Ginkgo CADx restrictions"), "inactivity_time", _Std("Max seconds of Ginkgo CADx application inactivity"), false, "600", false);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.restrictions", _Std("Ginkgo CADx restrictions"), "export", _Std("Export images"), false, "", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.help", _Std("Online manual"), "url_manual", _Std("URL of online manual"), true, "http://doc.ginkgo-cadx.com/", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.help", _Std("Online support"), "url_support", _Std("URL of online support"), true, _Std("http://ginkgo-cadx.com/en/services/"), true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.help", _Std("Extensions Support"), "extensions_support_1", _Std("URL for new extensions"), true, _Std("http://ginkgo-cadx.com/"), true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.update", _Std("Program Updates"), "check_updates", _Std("Warn about newest Ginkgo CADx updates"), false, "http://updates.ginkgo-cadx.com/version.xml", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.update", _Std("Program Updates"), "update_period", _Std("Update period (days)"), false, "2", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.seguridad",_Std("Security"), "setup_security", _Std("Setup Security"), false, "", false);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.startup", _Std("Show on startup"), "startupdefaultvalue", _Std("Show on startup default value"), true, "", true);
	
	
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.menu",_Std("Tools"),"configuracion",_Std("Settings menu"), false, "", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.menu",_Std("Tools"),"filtrado",_Std("Filter menu"), true, "", false);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.menu",_Std("Tools"),"licencia",_Std("License menu"), true, "", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.pacs.limits", _Std("PACS Limits"),"pacs_upload",_Std("Upload images to a PACS server"), false, "", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.pacs.limits", _Std("PACS Limits"), "pacs_acquisition", _Std("Acquire images from PACS"),false, "", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.pacs.limits", _Std("PACS Limits"), "remote_pacs", _Std("Enable remote PACS configuration"), false, "", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.pacs.limits", _Std("PACS Limits"), "pacs_tls", _Std("Enable TLS configuration"), false, "", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.pacs.limits", _Std("PACS Limits"), "patient_scope", _Std("Restrict search over selected patient"), false, "", false);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.pacs.limits", _Std("PACS Limits"), "study_size", _Std("Restrict study retrieval by maximum size (KB)"), false, "16384", false);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.pacs.limits", _Std("PACS Limits"), "force_lossless", _Std("Force lossless when upload"), false, "", false);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.importacion", _Std("Import"), "quality", _Std("Set compression, 0 implies no compression (0..14)"), false, "1", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.importacion", _Std("Import"), "codec", _Std("Recompression codec (0=JPEG Baseline(default), 1=JPEG Progressive, 2=JPEG Lossless)"), false, "0", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.importacion", _Std("Import"), "mantener", _Std("Don't change image codec (if possible)"), false, "", true);

	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.hl7", _Std("HL7 Service"), "autostart", _Std("Automatically start HL7 Sender service"), false, "", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.integracion", _Std("XML dicomization"), "send_message", _Std("Send Hl7 message when importing"), false, "", true);
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.integracion", _Std("XML dicomization"), "upload_pacs", _Std("Send study to PACS when importing"), false, "", true);


	std::string modalidades[20] = {"CR","CT","DR","DX","IO","MG","MR","NM","OT","PT","RF","RG","SC","SR","US","XA","XC","ES","ECG","HD"};
	//permisos modalidades
	for(int i = 0; i < 20; ++i) {
		wxString texto = wxString::Format(_("Download %s images"),wxString::FromUTF8(modalidades[i].c_str()).c_str());
		GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.pacs.download",_Std("PACS"),modalidades[i],std::string(texto.ToUTF8()),false, "", true);
	}
		
	wxString texto = _("Download all modalities");
	GNC::GCS::ControladorPermisos::Instance()->AddDefinicionPermiso("core.pacs.download",_Std("PACS"),"all",std::string(texto.ToUTF8()),false, "", true);

	//

	/*
	vtkPolyDataMapper* m = vtkPolyDataMapper::New();
	m->GlobalImmediateModeRenderingOn();
	m->Delete();
	*/
#ifdef __WXMAC__
	wxApp::s_macAboutMenuItemId = 1062;
	wxApp::s_macPreferencesMenuItemId = 1063;
	wxApp::s_macHelpMenuTitleName = wxT("A&yuda");
	//wxSystemOptions::SetOption( wxMAC_TEXTCONTROL_USE_SPELL_CHECKER, 1 );
#endif


#if !defined(_GINKGO_DEBUG) || defined(OMITIR_VENTANA_ERRORES_VTK)
	vtkObject::GlobalWarningDisplayOff();
	itk::Object::GlobalWarningDisplayOff();
#endif

	wxThread::SetConcurrency(wxThread::GetCPUCount());

	m_pVentanaLogo = NULL;

	wxJPEGHandler* handler=new wxJPEGHandler();
	wxImage::AddHandler(handler);

	wxPNGHandler* handlerPng=new wxPNGHandler();
	wxImage::AddHandler(handlerPng);

	wxGIFHandler* handlerGif=new wxGIFHandler();
	wxImage::AddHandler(handlerGif);

	wxTIFFHandler* handleTiff = new wxTIFFHandler();
	wxImage::AddHandler(handleTiff);

#if defined(_GINKGO_ENABLE_SPLASH)

	{
		wxBitmap bitmap = GinkgoResourcesManager::Logos::GetLogoSplash();
		wxSplashScreen splash(bitmap, wxSPLASH_CENTRE_ON_SCREEN | wxSPLASH_NO_TIMEOUT,
			-1, NULL, -1, wxDefaultPosition, wxDefaultSize,
			wxSTAY_ON_TOP|wxNO_BORDER);
		wxIcon icono;
		icono.CopyFromBitmap(GinkgoResourcesManager::Logos::GetLogoGinkgo32x32());
		splash.SetIcon(icono);
		splash.Connect(wxEVT_CLOSE_WINDOW, wxCloseEventHandler(Ginkgo::OnSplashClose));
		// Copia del bitmap original de la ventana splash para pintar sobre ella
		if (m_pBitmapOriginal.Create(bitmap.GetWidth(), bitmap.GetHeight(), bitmap.GetDepth())) {
			m_pVentanaLogo = &splash;
			wxMemoryDC srcDC(bitmap);
			wxMemoryDC dstDC(m_pBitmapOriginal);
			dstDC.Blit(wxPoint(0, 0), srcDC.GetSize(), &srcDC, wxPoint(0, 0), wxCOPY, false, wxPoint(0, 0));
		}
#endif

		DoProgress(wxString(_("Initializing environment ...")));

		GNC::Entorno::Instance()->SetApp(this);

		{
			wxWindowDisabler dis;
			m_pVentanaPrincipal = new VentanaPrincipal(_("Ginkgo CADx"));
			m_pVentanaPrincipal->Hide();
			SetTopWindow(m_pVentanaPrincipal);
		}

		DoProgress(wxString(_("Tools loading base ...")));


		DoProgress(wxString(_("Loading modules ...")));
		DoProgress(wxString(_("Loading plugins ...")));
		LoadPlugins();

		DoProgress(wxString(_("Loading resources ...")));
		GIL::DICOM::Conformance::Load();

		DoProgress(wxString(_("Starting services...")));
		//TODO DESCOMENTAR CUANDO FUNCIONE EL MOVE GIL::DICOM::PACSController::Instance()->StartService();

		DoProgress(wxString(_("Starting tools...")));

		
		GNC::ControladorHerramientas* cH = GNC::ControladorHerramientas::Instance();
		try {
			cH->RegistrarHerramienta(new GNC::HerramientaPuntero());
			cH->RegistrarHerramienta(new GNC::HerramientaSlider());
			cH->RegistrarHerramienta(new GNC::HerramientaWindowLevel());
			cH->RegistrarHerramienta(new GNC::HerramientaRegla());
			cH->RegistrarHerramienta(new GNC::HerramientaAngulo());
			cH->RegistrarHerramienta(new GNC::HerramientaMarcado());
			cH->RegistrarHerramienta(new GNC::HerramientaNota());
			cH->RegistrarHerramienta(new GNC::HerramientaElevacion());
			cH->RegistrarHerramienta(new GNC::HerramientaLupa());
			cH->RegistrarHerramienta(new GNC::HerramientaRejillaMetrica());
			cH->RegistrarHerramienta(new GNC::HerramientaLayoutVentana());

			//menus de arriba
			cH->RegistrarHerramienta(new GNC::HerramientaAnotacionesEsquina());
			cH->RegistrarHerramienta(new GNC::HerramientaPanelTags());
			cH->RegistrarHerramienta(new GNC::HerramientaDesencajar());
			cH->RegistrarHerramienta(new GNC::HerramientaDeshacer());
			cH->RegistrarHerramienta(new GNC::HerramientaInterpolate());
			

			//especial
			cH->RegistrarHerramienta(new GNC::HerramientaReset());
			//cH->RegistrarHerramienta(new GNC::HerramientaLazo());
		}
		catch (GNC::GCS::ControladorHerramientasException& e) {
			std::cerr << e.getCause().c_str() << std::endl;
		}
		

		DoProgress(wxString(_("Configuring environment ...")));
		//FUNDAMENTAL LOS PERMISOS DESPUES DE LOADPLUGINS, PORQUE SI NO NO ESTAN CARGADAS LAS DEFINICIONES DE PERMISOS
		std::string permisos(PERMISOS_DIST);
		try{
			//carga de permisos definidos en licencia (privados)
			GNC::GCS::ControladorPermisos::Instance()->CargarXMLPermisos(permisos,true);

			GNC::GCS::ConfigurationController::TListGroups profiles;
			GNC::GCS::ConfigurationController::Instance()->readGroupGeneral("/GinkgoCore/Profiles", profiles);

			for (GNC::GCS::ConfigurationController::TListGroups::iterator it = profiles.begin(); it != profiles.end(); ++it) {
				bool value;
				(*it).readBoolValue("Apply",value, false);
				if (value) {
					std::string xml;
					if ((*it).readStringValue("XML", xml)) {
						GNC::GCS::ControladorPermisos::Instance()->CargarXMLPermisos(xml, false);
						break;
					}
				}
			}
		}
		catch(GNC::GCS::ControladorPermisosException& ex) {
			wxMessageBox(_("Failed to set permissions:\n") + wxString::FromUTF8(ex.GetCause().c_str()),_("error"),wxICON_INFORMATION);
		}
		//es necesario porque hay permisos que afectan a menus
		m_pVentanaPrincipal->RefrescarMenus();

		//se registran vistas y modos
		const GNC::ControladorExtensiones::ListaModulos& listaModulos = GNC::ControladorExtensiones::Instance()->Modulos();
		for(GNC::ControladorExtensiones::ListaModulos::const_iterator it = listaModulos.begin(); it != listaModulos.end(); ++it)
		{
			(*it).second->RegistrarVistas();
		}

		m_pVentanaPrincipal->CargarHistorial();			

		DoProgress(wxString(_("Interpreting parameters ...")));

	}

	//m_pVentanaPrincipal->Show();

	//parseo
	wxCommandEvent ce(wxEVT_COMMAND_MENU_SELECTED, ID_Inicio_Aplicacion);
	m_pVentanaPrincipal->AddPendingEvent(ce);


#if defined (__WXMAC__)
	m_Inicializado = true;
	if (m_OpenFileName.size() > 0) {
		GinkgoDispatcher::Instance()->InsertarPeticion(m_OpenFileName);
	}
#endif
#if defined(_GINKGO_ENABLE_SPLASH)
	m_pVentanaLogo = NULL;
#endif
	return TRUE;
}

#ifdef __WXMAC__
void Ginkgo::MacOpenFile(const wxString &fileName)
{
	if (m_Inicializado) {
		GinkgoDispatcher::Instance()->InsertarPeticion( std::string(TOPATH(fileName)) );
	}
	else {
		m_OpenFileName = std::string(TOPATH(fileName));
	}

}
#endif


int Ginkgo::OnExit()
{
	LOG_INFO("Core", "Cerrando Ginkgo ");

	//unregister events
	GNC::GCS::ControladorEventos::Instance()->DesRegistrar(this);
	GNC::GCS::IObservador::m_pControlador = NULL;
	//

	//desregistrar herramientas
	GNC::GCS::IControladorHerramientas* cH = GNC::ControladorHerramientas::Instance();
	GNC::GCS::IHerramientaPuntero*          hPuntero        = NULL;
	GNC::GCS::IHerramientaSlider*           hSlider         = NULL;
	GNC::GCS::IHerramientaWindowLevel*      hwl             = NULL;
	GNC::GCS::IHerramientaRegla*            hregla          = NULL;
	GNC::GCS::IHerramientaAngulo*           hAngulo         = NULL;
	GNC::GCS::IHerramientaMarcado*          hMarcado        = NULL;
	GNC::GCS::IHerramientaNota*             hNota           = NULL;
	GNC::GCS::IHerramientaElevacion*        hElevacion      = NULL;
	GNC::GCS::IHerramientaLupa*             hLupa           = NULL;
	GNC::GCS::IHerramientaRejillaMetrica*   hRejilla        = NULL;
	GNC::GCS::IHerramientaAnotacionesEsquina* hAnotacionesEsquina          = NULL;
	GNC::GCS::IHerramientaPanelTags*        hTags           = NULL;
	GNC::GCS::IHerramientaReset*            hReset          = NULL;
	GNC::GCS::IHerramientaLayoutVentana*    hLayoutVentana  = NULL;
	GNC::GCS::IHerramientaDesencajar*		hDesencajar = NULL;
	GNC::GCS::IHerramientaDeshacer*		hDeshacer = NULL;
	GNC::GCS::IHerramientaInterpolate* hInterpolate = NULL;

	try {
		hPuntero = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaPuntero>(GNC::GCS::IHerramientaPuntero::ID);
		if (hPuntero != NULL) {
			cH->DesRegistrarHerramienta(hPuntero);
			delete hPuntero;
		}
		hSlider = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaSlider>(GNC::GCS::IHerramientaSlider::ID);
		if (hSlider != NULL) {
			cH->DesRegistrarHerramienta(hSlider);
			delete hSlider;
		}
		hwl = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaWindowLevel>(GNC::GCS::IHerramientaWindowLevel::ID);
		if (hwl != NULL) {
			cH->DesRegistrarHerramienta(hwl);
			delete hwl;
		}
		hregla = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRegla>(GNC::GCS::IHerramientaRegla::ID);
		if (hregla != NULL) {
			cH->DesRegistrarHerramienta(hregla);
			delete hregla;
		}
		hAngulo = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAngulo>(GNC::GCS::IHerramientaAngulo::ID);
		if (hAngulo != NULL) {
			cH->DesRegistrarHerramienta(hAngulo);
			delete hAngulo;
		}
		hMarcado = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaMarcado>(GNC::GCS::IHerramientaMarcado::ID);
		if (hMarcado != NULL) {
			cH->DesRegistrarHerramienta(hMarcado);
			delete hMarcado;
		}
		hNota = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaNota>(GNC::GCS::IHerramientaNota::ID);
		if (hNota != NULL) {
			cH->DesRegistrarHerramienta(hNota);
			delete hNota;
			hNota = NULL;
		}
		hElevacion = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaElevacion>(GNC::GCS::IHerramientaElevacion::ID);
		if (hElevacion != NULL) {
			cH->DesRegistrarHerramienta(hElevacion);
			delete hElevacion;
			hElevacion = NULL;
		}
		hLupa = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaLupa>(GNC::GCS::IHerramientaLupa::ID);
		if (hLupa != NULL) {
			cH->DesRegistrarHerramienta(hLupa);
			delete hLupa;
			hLupa = NULL;
		}
		hRejilla = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRejillaMetrica>(GNC::GCS::IHerramientaRejillaMetrica::ID);
		if (hRejilla != NULL) {
			cH->DesRegistrarHerramienta(hRejilla);
			delete hRejilla;
			hRejilla = NULL;
		}
		hAnotacionesEsquina = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaAnotacionesEsquina>(GNC::GCS::IHerramientaAnotacionesEsquina::ID);
		if (hAnotacionesEsquina != NULL) {
			cH->DesRegistrarHerramienta(hAnotacionesEsquina);
			delete hAnotacionesEsquina;
			hAnotacionesEsquina = NULL;
		}
		hTags = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaPanelTags>(GNC::GCS::IHerramientaPanelTags::ID);
		if (hTags != NULL) {
			cH->DesRegistrarHerramienta(hTags);
			delete hTags;
		}

		hReset = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaReset>(GNC::GCS::IHerramientaReset::ID);
		if (hReset != NULL) {
			cH->DesRegistrarHerramienta(hReset);
			delete hReset;
		}

		hLayoutVentana = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaLayoutVentana>(GNC::GCS::IHerramientaLayoutVentana::ID);
		if (hLayoutVentana != NULL) {
			cH->DesRegistrarHerramienta(hLayoutVentana);
			delete hLayoutVentana;
		}

		hDesencajar = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaDesencajar>(GNC::GCS::IHerramientaDesencajar::ID);
		if (hDesencajar != NULL) {
			cH->DesRegistrarHerramienta(hDesencajar);
			delete hDesencajar;
		}

		hDeshacer = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaDeshacer>(GNC::GCS::IHerramientaDeshacer::ID);
		if (hDeshacer != NULL) {
			cH->DesRegistrarHerramienta(hDeshacer);
			delete hDeshacer;
		}

		hInterpolate = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaInterpolate>(GNC::GCS::IHerramientaInterpolate::ID);
		if (hInterpolate != NULL) {
			cH->DesRegistrarHerramienta(hInterpolate);
			delete hInterpolate;
		}
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al registrar herramientas de Derma: No se pudo subscribir la herramienta: " << ex.getCause() << std::endl;
	}


	GNC::GCS::ControladorVistas::FreeInstance();
	GIL::XMLRPC::XMLRPCController::FreeInstance();
	GIL::HL7::ControladorEnvioHl7::FreeInstance();
	GNC::GCS::ControladorAcciones::FreeInstance();
	GNC::GCS::ControladorComandos::FreeInstance();
	GIL::DICOM::PACSController::FreeInstance();
	GNC::ControladorExtensiones::FreeInstance();
	GNC::GCS::ControladorEventos::FreeInstance();
	GNC::GCS::ControladorCarga::FreeInstance();
	GNC::ControladorHerramientas::FreeInstance();
	GNC::GCS::ControladorHistorial::FreeInstance();
	GIL::HL7::ControladorBBDDHl7::FreeInstance();
	GNC::GCS::ControladorPermisos::FreeInstance();
	GNC::GCS::ControladorInternacionalizacion::FreeInstance();
	GSEC::Auth::ControladorAutenticacion::FreeInstance();
	DicomServerList::FreeInstance();
	wxSQLite3Database::ShutdownSQLite();
	GNC::GCS::ControladorLog::FreeInstance();

	GNC::Entorno::FreeInstance();

	wxSocketBase::Shutdown();

#if defined(_WINDOWS)
	if (m_pServer != NULL) {
		delete m_pServer;
	}
#endif
	GNC::GCS::ConfigurationController::FreeInstance();

	return wxApp::OnExit();
}

// Modificación del estado en el banner

void Ginkgo::DoProgress(wxString str)
{
	if (m_pVentanaLogo == NULL) {
		return;
	}
	wxSplashScreenWindow* pSplashWin = m_pVentanaLogo->GetSplashWindow();

	wxMemoryDC srcDC(m_pBitmapOriginal);
	wxClientDC wdc(pSplashWin);

	wxColour colorTexto;

	colorTexto.Set(70,70,70);

	// Restauración del logo
	wdc.Blit(wxPoint(0, 0), srcDC.GetSize(), &srcDC, wxPoint(0, 0), wxCOPY, false, wxPoint(0, 0));

	// Dibujado del texto
	wdc.SetTextForeground(colorTexto);
	wdc.DrawText(str, 190, srcDC.GetSize().y - 37);
}

void Ginkgo::WriteHeaderLog(){

	int versionNumber=GINKGO_VERSION;
	std::stringstream version;
	wxDateTime now = wxDateTime::Now();
	wxString date;

	version << versionNumber;
	version << ".";

	versionNumber = GINKGO_SUB_VERSION;
	version << versionNumber;
	version << ".";

	versionNumber = GINKGO_SUB_RELEASE;
	version << versionNumber;
	version << ".";

	versionNumber = GNC::Entorno::Instance()->ParseSVNBuild(GINKGO_BUILD);
	version << versionNumber;
	version << " ";

	version << GINKGO_CODENAME;

	date=now.Format(wxT("%d/%m/%Y %H:%M:%S"),wxDateTime::CET);

	LOG_INFO("Core", "Arrancando Ginkgo " + version.str() + "    " + std::string(date.ToUTF8()));
}
//endregion
