/*
 *  
 *  $Id: iexception.cpp 3911 2011-07-04 07:58:00Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */

#include <api/iexception.h>

GNC::GCS::IException::IException(const std::string& msg, const std::string& component, bool fatal) throw()
{
	this->cause = msg;
	this->component = component;
	this->fatal = fatal;
}

GNC::GCS::IException::~IException() throw()
{
}

const std::string& GNC::GCS::IException::GetComponent() const
{
	return component;
}

const std::string& GNC::GCS::IException::GetCause() const {
	return cause;
}

std::string GNC::GCS::IException::GetFullCause() const {
	return *this;
}

bool GNC::GCS::IException::IsFatal()  const {
	return fatal;
}

GNC::GCS::IException::operator std::string() const
{
	return _Std("Exception in component ") + GetComponent() + std::string(" : ")  + GetCause();
}
