/*
 *  
 *  $Id: icontroladoreventos.h 3698 2011-04-14 12:38:49Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <list>
#include "ievento.h"

//----------------------------------------------------------------------------------------------------
//region Forward Declarations
namespace GNC {
	namespace GCS {
		
		class IObservador;
	}
}
//endregion

namespace GNC {
	namespace GCS {

		//====================================================================================================
		//= Interfaz del controlador de eventos
		//====================================================================================================
		class EXTAPI IControladorEventos
		{
		public:
			typedef std::list<GNC::GCS::Eventos::IEvento*> TipoListaPunterosEventos;

			//se apunta a escuchar un evento
			virtual void Registrar ( IObservador* pObservador, const GNC::GCS::Eventos::IEvento& evento) = 0;
			//se desapunta de escuchar un evento
			virtual void DesRegistrar (IObservador* pObservador, const GNC::GCS::Eventos::IEvento& evento) = 0;
			//se desapunta de todos los eventos a los que escucha
			virtual void DesRegistrar (IObservador* pObservador) = 0;
			//avisa a los observadores registrados a este evento
			virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt) = 0;
		};

		//====================================================================================================
		//= Interfaz del observador de eventos
		//====================================================================================================
		class EXTAPI IObservador
		{
		public:
			IObservador()
			{
				m_pControlador = NULL;
			}

			~IObservador()
			{
				if(m_pControlador != NULL)
				{
					m_pControlador->DesRegistrar(this);
				}
			}

			virtual void OnRegistrar (IControladorEventos* pControlador)
			{
				m_pControlador = pControlador;
			}

			virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt) = 0;

			virtual void PreProcesarEvento(GNC::GCS::Eventos::IEvento *, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& )
			{

			}

			virtual bool FiltrarEvento(GNC::GCS::Eventos::IEvento *)
			{
				return false;
			}

		protected:
			IControladorEventos* m_pControlador;
		};

	}
}
