/*
 *  
 *  $Id: globals.h 3497 2011-03-14 10:01:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once

#include <iostream>
#if defined(_WINDOWS)
#include <windows.h>
#endif

#if defined (_GINKGO_DEBUG)
	 #define GDEBUG(expr) std::cout << "D: " << expr << "   @ " << __FILE__ << ":" << __LINE__ << std::endl;

#else // !defined (_GINKGO_DEBUG)
	 #define GDEBUG(expr) /* nada */
#endif

#if defined (_GINKGO_TRACE)
	 #define GTRACE(expr) std::cout << "T: " << expr << "   @ " << __FILE__ << ":" << __LINE__ << std::endl;

#else // !defined (_GINKGO_DEBUG)
	 #define GTRACE(expr) /* nada */
#endif

#if defined(__WXGTK__) || defined(__WXMAC__) || defined(__WXMSW__)

#if defined (_WIN32)
	#define TOPATH(stringwx) (stringwx.To8BitData()==NULL)?"":stringwx.To8BitData()
	#define FROMPATH(stringstd) wxString::From8BitData(stringstd.c_str())
#else
	#define TOPATH(stringwx) stringwx.ToUTF8()
	#define FROMPATH(stringstd) wxString::FromUTF8(stringstd.c_str())
#endif

#ifndef AUI_NAMESPACE
//#define AUI_NAMESPACE TEST::
#endif

#ifndef AUI_NAMESPACE
#define AUI_NAMESPACE
#define GINKGO_AUI_DECLARE(clase) class clase;
#define AUI_USE_NAMESPACE()
#else
#define GINKGO_AUI_DECLARE(clase) namespace AUI_NAMESPACE { class clase; }
#define AUI_USE_NAMESPACE() using namespace AUI_NAMESPACE;
#endif

#endif

namespace GNC {
	namespace GCS {

		class Timer
		{
		private:
			#if defined(_WINDOWS)
				LARGE_INTEGER mInicio;
				LARGE_INTEGER mFin;
				LARGE_INTEGER mFrecuencia;
			#else

			#endif
		public:
			Timer()
			{
			}

			void start()
			{
				#if defined(_WINDOWS)
					QueryPerformanceCounter( &mInicio );
				#else

				#endif
			}

			void restart() {
				#if defined(_WINDOWS)
					QueryPerformanceCounter( &mInicio );
				#else

				#endif
			}

			void stop() {
				#if defined(_WINDOWS)
					QueryPerformanceCounter(&mFin);
					QueryPerformanceFrequency(&mFrecuencia);
				#else

				#endif
			}

			friend std::ostream& operator<<(std::ostream& out, const Timer& t)
			{
				#if defined(_WINDOWS)
					const double tiempo = (double)(t.mFin.QuadPart - t.mInicio.QuadPart ) / (double) t.mFrecuencia.QuadPart;
					return out << tiempo << " seg. " << 1.0 / tiempo << " Op./seg.";
				#else
					return out << "No implementado";

				#endif
			}

			friend std::ostream& operator<<(std::ostream& out, const Timer* t)
			{
				if (t == NULL) {
					return out << "NULL";
				}
				else {
					return out << *t;
				}
			}
		};
	}
}
