/*
 *  $Id: lightvisualizatorview.h 3911 2011-07-04 07:58:00Z carlos $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
#pragma once

#include <api/globals.h>
#include <api/controllers/ipacscontroller.h>
#include <api/ivista.h>
#include <lightvisualizator/studies/lightvisualizatorstudy.h>
#include <lightvisualizator/wxvtk/glightvisualizatorview.h>


#include <list>
#include <vector>
#include <map>

namespace GNC {
	namespace GCS {
		class IEntorno;
	}
}

class wxWindow;

namespace LightVisualizator {

	class LightVisualizatorView  : public GNC::GCS::IVista {
	public:
		/* Constructor */
		LightVisualizatorView (const GnkPtr<LightVisualizator::LightVisualizatorStudy>& study);

		/* Destructor */
		~LightVisualizatorView ();

		//suports save?
		virtual bool SoportaGuardar();

		//supports exportation?
		virtual bool SoportaExportar();

		//----------------------------------------------------------------------------------------------------
		//region Loading interface

		// Starts loading. Synchronous with interface.
		virtual void OnCargaIniciada();

		// Step1: LoadStudy not synchronized with interface thread
		virtual void CargarEstudio(GNC::GCS::IComando* pCmdInvocador);

		//Ends loading. Synchronous with interface
		virtual void OnCargaFinalizada();

		// Step2: init pipeline synchronous with interface
		virtual void IniciarPipeline();

		// stops pipeline, it's called if there has been an error loading study
		virtual void DetenerPipeline();

		//endregion

		//call when this view is activated
		virtual void Activar();

		//return graphic form
		virtual wxWindow* GetWindow();

		virtual void OnFocus();

		GnkPtr<LightVisualizator::LightVisualizatorStudy>& GetLightStudy()
		{
			return LightStudy;
		}
	protected:
		GnkPtr<LightVisualizator::LightVisualizatorStudy>     LightStudy;

		void BuildTitle();

		LightVisualizator::GUI::GLightVisualizatorView*                 GView;
	};
};
