/*
 *  $Id: vistaoftal.cpp 3681 2011-04-12 10:53:31Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
//#define _GINKGO_TRACE

#include <wx/wx.h>
#include <wx/dir.h>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/busyinfo.h>
#include <wx/msgdlg.h>
#include <fooextension/wxvtk/gfooextensionview.h>

#include <api/globals.h>

#include "fooextensionview.h"

#include <export/iherramientapuntero.h>
#include <export/iherramientaregla.h>
#include <api/iherramienta.h>
#include <api/imodelointegracion.h>

#include <api/icontrato.h>
#include <api/icontroladorvistas.h>
#include <api/icontroladorherramientas.h>
#include <api/icontroladorcarga.h>
#include <api/ientorno.h>
#include <eventos/eventosginkgo.h>

#undef __DEPRECATED
#include <ios>
#include <sstream>
#include <ostream>

#include <api/controllers/ipacscontroller.h>
#include <api/icontroladormodulo.h>
#include <api/icontroladorpermisos.h>
#include <vtkImageData.h>


namespace FooExtension {

	FooExtensionView ::FooExtensionView (const GnkPtr<FooExtension::FooExtensionStudy>& study) : GNC::GCS::IVista((GnkPtr<GNC::GCS::IContextoEstudio>)study)
	{
		FooStudy = study;
		m_Cargada = false;

		FooStudy->Ventana = GView = new GUI::GFooExtensionView (this);

		//herramientas
		GNC::GCS::IEntorno* pEntorno = FooStudy->Entorno;

		//tools controller
		GNC::GCS::IControladorHerramientas* cH = pEntorno->GetControladorHerramientas();
		//tool arrow
		GNC::GCS::IHerramientaPuntero*            hArrow = NULL;
		//tool rule
		GNC::GCS::IHerramientaRegla*              hRule = NULL;

		try {
			// Subscribe tool arrow
			hArrow = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaPuntero>(GNC::GCS::IHerramientaPuntero::ID);
			if (hArrow != NULL) {
				GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>* contratablevtk=hArrow;
				contratablevtk->Subscribir(this,GView);
			}

			// Subscribe tool rule
			hRule = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRegla>(GNC::GCS::IHerramientaRegla::ID);
			if (hRule != NULL) {
				hRule->Subscribir(this, GView);
			}
		}
		catch (GNC::GCS::ControladorHerramientasException& ) {

		}
	}

	FooExtensionView ::~FooExtensionView ()
	{
		//ignore modifications
		FooStudy->SetIgnorarModificaciones(true);

		//unregister tools
		GNC::GCS::IControladorHerramientas* cH = FooStudy->Entorno->GetControladorHerramientas();
		GNC::GCS::IHerramientaPuntero*     hArrow = NULL;
		GNC::GCS::IHerramientaRegla*       hRule = NULL;

		try {
			hArrow = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaPuntero>(GNC::GCS::IHerramientaPuntero::ID);
			if (hArrow != NULL) {
				hArrow->DesSubscribirsLosDeLaVista(this);
			}
			hRule = cH->ObtenerHerramientaConcreta<GNC::GCS::IHerramientaRegla>(GNC::GCS::IHerramientaRegla::ID);
			if (hRule != NULL) {
				hRule->DesSubscribirsLosDeLaVista(this);
			}
		}
		catch (GNC::GCS::ControladorHerramientasException& ) {
		}
	}

	//----------------------------------------------------------------------------------------------------
//region Loading interface

	// Starts loading. Synchronous with interface.
	void FooExtensionView::OnCargaIniciada()
	{
		//nothing to do
	}

	// Step1: LoadStudy not synchronized with interface thread
	void FooExtensionView::CargarEstudio(GNC::GCS::IComando* pCmdInvocador)
	{
		//nothing to do
	}

	//Ends loading. Synchronous with interface
	void FooExtensionView::OnCargaFinalizada()
	{
		//refresh tools
		FooStudy->Entorno->GetControladorHerramientas()->RefrescarHerramientas();
	}

	// Step2: init pipeline synchronous with interface
	void FooExtensionView::IniciarPipeline()
	{
		//here you can connect ginkgo events, like image modification...

		//sets image number
		GView->InitPipeline();

		//build view title
		BuildTitle();
	}


	// stops pipeline, it's called if there has been an error loading study
	void FooExtensionView::DetenerPipeline()
	{
	}

//endregion

	bool FooExtensionView::SoportaGuardar()
	{
		return false;
	}

	bool FooExtensionView::SoportaExportar()
	{
		return false;
	}

	void FooExtensionView::Activar() {
		GNC::GCS::IVista::Activar();
		GView->SetFocus();
	}



	wxWindow * FooExtensionView::GetWindow()
	{
		return GView;
	}

	void FooExtensionView::OnFocus()
	{
		if (!m_Activada) {
			FooStudy->Entorno->GetControladorVistas()->SolicitarActivarVista(this);
		}
	}

	void FooExtensionView::BuildTitle()
	{
		std::ostringstream ostr;
		std::string valor;

		//patient id
		FooStudy->GetTagDiagnosticoActivo("0010|0010",valor);
		for (std::string::iterator it = valor.begin(); it != valor.end(); it++) {
			if ( *it == '^') {
				*it = ' ';
			}
		}
		ostr << valor.c_str() << ", ";
		//study description
		FooStudy->GetTagDiagnosticoActivo("0008|1030",valor);
		ostr << valor.c_str();
		if (!valor.empty()) {
			ostr << "/";
		}
		//series description
		FooStudy->GetTagDiagnosticoActivo("0008|103e",valor);
		ostr << valor.c_str();
		//sets m_title
		m_Titulo = ostr.str();
	}

}
