/*
 *  
 *  $Id: gnkvideostudy.h 3681 2011-04-12 10:53:31Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/icontextoestudio.h>

class wxWindow;
class wxSizer;
class wxXmlNode;
class wxXmlDocument;

namespace FooExtension {
	//study represents files handled by a view, resolve tasks like widgets load/store, dicom tags reading, diagnostic handling...
	//you have only to extent GNC::GCS::IContextoEstudio and implement Callbacks
	//you can extent functionality to load specific tags handled with this view
	class FooExtensionStudy : public GNC::GCS::IContextoEstudio
	{
	public:
		
		FooExtensionStudy();
		~FooExtensionStudy();

		//initialization method
		virtual void InicializarContextoEstudio(std::vector<std::string>& rutas, const std::string uidEstudioDiagnostico, GNC::GCS::IContextoEstudio::TModoFuncionamiento modoFuncionamiento);


		virtual bool CallbackPreCrearDiagnostico(const int indice, GIL::DICOM::TipoJerarquia* pJerarquiaSR, std::list<GnkPtr<GIL::DICOM::TipoPrivateTags> >& listaTagsPrivados) {return true;}
		virtual bool CallbackPreGuardarDiagnostico(const int /*indice*/, GIL::DICOM::IDICOMManager* /*pDicomManager*/) {return true;}
		virtual void CallbackCargarTagsImagen(const int /*indice*/, GIL::DICOM::IDICOMManager* /*pDicomManager*/) {}


	protected:

	};
}
