/*
 *  
 *  $Id: wgradiente.cpp 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/globals.h>
#include "wgradiente.h"
#include <api/ievento.h>
#include <api/iwidgetsmanager.h>
#include <eventos/eventosginkgo.h>

#include <cmath>
#include <cstring>

#include <vtkgl.h>
#include <vtkImageData.h>
#include <vtkPointData.h>
#include <vtkBMPWriter.h>

#include <itkRGBPixel.h>
#include <itkVector.h>
#include <itkCovariantVector.h>
#include <itkImage.h>

#include <itkExceptionObject.h>
#include <itkRescaleIntensityImageFilter.h>
#include <itkRGBToLuminanceImageFilter.h>
#include <itkGradientImageFilter.h>
#include <itkCastImageFilter.h>
#include <itkImageFileWriter.h>

#include <itkImageRegionIteratorWithIndex.h>
#include <itkImageLinearIteratorWithIndex.h>

namespace GNC {
	namespace GCS {
		namespace Widgets {
			class Data {

			public:

				typedef itk::RGBPixel<float>                  TPixelRGBInfiltracion;
				typedef itk::Image<TPixelRGBInfiltracion, 2>  TImagenEntradaInfiltracion;

				typedef itk::Image<unsigned char, 2>          TImagenValoracionInfiltracion;

				typedef itk::Image<float, 2>                                TImagenInterna;

				typedef itk::RGBToLuminanceImageFilter<TImagenEntradaInfiltracion, TImagenInterna>  TLuminanceFilter;
				typedef itk::RescaleIntensityImageFilter<TImagenInterna, TImagenInterna>            TNormalizeFilter;
				typedef itk::GradientImageFilter<TImagenInterna, float, float>                      TGradientFilter;

				typedef TGradientFilter::OutputImageType                                            TImagenVectorGradiente;


				TImagenVectorGradiente::Pointer     imgGrad;
				TImagenEntradaInfiltracion::Pointer imagenEntrada;


				unsigned int m_LIndex;
				int          dimensions[3];
				double       spacing[3];
				double       origin[3];


				Data(vtkImageData* img)
				{
					m_LIndex = 0;

					imagenEntrada = TImagenEntradaInfiltracion::New();

					dimensions[0] = 0;
					dimensions[1] = 0;
					dimensions[2] = 0;

					spacing[0] = 0.0f;
					spacing[1] = 0.0f;
					spacing[2] = 0.0f;

					origin[0]  = 0.0f;
					origin[1]  = 0.0f;
					origin[2]  = 0.0f;

					img->GetDimensions(dimensions);
					img->GetSpacing(spacing);
					img->GetOrigin(origin);

					TImagenEntradaInfiltracion::IndexType   entradaIndex;
					TImagenEntradaInfiltracion::SizeType    entradaSize;
					TImagenEntradaInfiltracion::RegionType  entradaRegion;
					TImagenEntradaInfiltracion::SpacingType entradaSpacing;
					TImagenEntradaInfiltracion::PointType   entradaOrigin;

					entradaIndex[0] = 0;
					entradaIndex[1] = 0;

					entradaSize[0] = dimensions[0];
					entradaSize[1] = dimensions[1];

					entradaRegion.SetIndex(entradaIndex);
					entradaRegion.SetSize(entradaSize);

					imagenEntrada->SetRegions(entradaRegion);

					entradaSpacing[0] = spacing[0];
					entradaSpacing[1] = spacing[1];

					imagenEntrada->SetSpacing(entradaSpacing);

					entradaOrigin[0] = origin[0];
					entradaOrigin[1] = origin[1];

					imagenEntrada->SetOrigin(entradaOrigin);

					imagenEntrada->Allocate();

					itk::ImageRegionIterator<TImagenEntradaInfiltracion> itEntrada (imagenEntrada, entradaRegion);

					unsigned int off = 0;
					double tuple[4];
					vtkDataArray* scalars = img->GetPointData()->GetScalars();

					TImagenEntradaInfiltracion::PixelType pixel;

					for (itEntrada.GoToBegin(); !itEntrada.IsAtEnd(); ++itEntrada) {
						scalars->GetTuple(off++, tuple);
						pixel[0] = tuple[0];
						pixel[1] = tuple[1];
						pixel[2] = tuple[2];
						itEntrada.Set(pixel);
					}


					TLuminanceFilter::Pointer luminanceFilter = TLuminanceFilter::New();
					//TNormalizeFilter::Pointer normalizeFilter = TNormalizeFilter::New();
					TGradientFilter::Pointer  gradientFilter  = TGradientFilter::New();

					luminanceFilter->SetInput( imagenEntrada );
					/*
					normalizeFilter->SetInput( luminanceFilter->GetOutput() );
					normalizeFilter->SetOutputMinimum(0.0f);
					normalizeFilter->SetOutputMaximum(1.0f);
					*/
					gradientFilter->SetInput( luminanceFilter->GetOutput() );

					gradientFilter->Update();

					imgGrad = gradientFilter->GetOutput();

					TImagenInterna::Pointer outputImage = TImagenInterna::New();
					outputImage->SetSpacing(imgGrad->GetSpacing());
					outputImage->SetOrigin(imgGrad->GetOrigin());
					outputImage->SetRegions(imgGrad->GetLargestPossibleRegion());
					outputImage->Allocate();

					//const unsigned int ancho = imgGrad->GetLargestPossibleRegion().GetSize()[0];
					const unsigned int alto = imgGrad->GetLargestPossibleRegion().GetSize()[1];

					typedef itk::ImageRegionIteratorWithIndex< TImagenVectorGradiente >  TIteradorVectorGradiente;
					typedef itk::ImageRegionIteratorWithIndex< TImagenInterna >          TIteradorImagen;

					TIteradorVectorGradiente itGrad(imgGrad, imgGrad->GetLargestPossibleRegion());
					TIteradorImagen          itImg(outputImage, outputImage->GetLargestPossibleRegion());

					typedef itk::ImageLinearIteratorWithIndex< TImagenVectorGradiente >  TIteradorLineasVectorGradiente;
					typedef itk::ImageLinearIteratorWithIndex< TImagenInterna >          TIteradorLineasImagen;

					TIteradorLineasVectorGradiente itLGrad(imgGrad, imgGrad->GetLargestPossibleRegion());
					TIteradorLineasImagen          itLImg(outputImage, outputImage->GetLargestPossibleRegion());

					glMatrixMode(GL_MODELVIEW);

					glPushMatrix();

					glLoadIdentity();

					m_LIndex = glGenLists(1);

					glNewList(m_LIndex, GL_COMPILE);

					glPointSize(5.0f);
					glLineWidth(2.0f);

					GNC::GCS::Vector spc(spacing[0], spacing[1]);

					itLGrad.SetDirection(0);

					for (itGrad.GoToBegin(); ! itGrad.IsAtEnd(); ++itGrad)
					{
						TImagenVectorGradiente::IndexType index = itGrad.GetIndex();
						TImagenVectorGradiente::PixelType& pixel = itGrad.Value();
						GNC::GCS::Vector p0 = GNC::GCS::Vector(index[0], index[1] - alto) * spc;
						GNC::GCS::Vector p1 = p0 + GNC::GCS::Vector(pixel[0], pixel[1]);
						glColor4f(0.0f, 1.0f, 1.0f, 0.75f);
						glBegin(GL_POINTS);
						glVertex2d(p0.x, p0.y);
						glEnd();

						glColor4f(0.0f, 1.0f, 0.0f, std::min((GNC::GCS::Vector::TReales)1.0f, p1.Norma2() / 5.0f));
						glBegin(GL_LINES);
						glVertex2d(p0.x, p0.y);
						glVertex2d(p1.x, p1.y);
						glEnd();
					}
					//

					glEndList();

					glPopMatrix();



					//bool movimiento = false;
					//TImagenInterna::IndexType idxImg;
					//TImagenVectorGradiente::IndexType idxGrad;

					/*

					TMapaGradiente mapaGrad(ancho, alto);



					itLGrad.SetDirection(0);
					unsigned int off = 0;
					for (itLGrad.GoToReverseBegin(); ! itLGrad.IsAtReverseEnd(); itLGrad.PreviousLine())
					{
						itLGrad.GoToBeginOfLine();
						for (; !itLGrad.IsAtEndOfLine(); ++itLGrad)
						{
							mapaGrad.data[off++] = TCeldaGradiente(itLGrad.Value()[0], itLGrad.Value()[1], itLGrad.Value().GetNorm());
						}
					}



					int nit = 0;



					TTablero tablero(ancho, alto);

					for (int off = 0; off < tablero.Size; ++off) {
						tablero.data[off].ocupadas.Add(new THormiga());
					}



					do {
						std::cout << "Iteracion " << nit << "( cota maxima : " << (float) nit / (float) mapaGrad.Size << " )" << std::endl;
						unsigned int offset = 0;

						movimiento = false;

						for (unsigned int y = 0; y < alto; ++y) {
							for (unsigned int x = 0; x < ancho; ++x, ++offset) {
								if (tablero.data[offset].ocupadas.NumElementos > 0) {

									float norma = mapaGrad.data[offset].norma;
									float gx = mapaGrad.data[offset].gx;
									float gy = mapaGrad.data[offset].gy;

									for (int hi = 0; hi < tablero.data[offset].ocupadas.NumElementos; ++hi) {

										THormiga* pHormiga = tablero.data[offset].ocupadas.data[hi];
										int dx = 0;
										int dy = 0;
										if (gx > 0.0000001) {
											dx = 1;
										}
										else if (gx < -0.0000001) {
											dx = -1;
										}

										if (gy > 0.0000001) {
											dy = 1;
										}
										else if (gy < -0.0000001) {
											dy = -1;
										}

										unsigned int px = x+dx;
										unsigned int py = y+dy;

										if (dx != 0 && dy != 0 && (int)px > 0 && px < ancho && (int)py > 0 && py < alto) { // Nos movemos
											pHormiga->peso += norma;
											tablero.Pixel(x+dx, y+dy).ocupadas.Add(pHormiga);
											tablero.data[offset].ocupadas.Eliminar(hi);
											--hi;
											movimiento = true;
											//std::cout << "Movimiento [ " << x << ", " << y << " ] => [ " << x+dx << ", " << y+dy << " ]" << std::endl;
										}
									}
								}
							}
						}
					} while (movimiento || nit == mapaGrad.Size);


					unsigned int y = 0;
					unsigned int x = 0;
					unsigned int offset = 0;
					itLImg.SetDirection(0);
					for (itLImg.GoToReverseBegin(); ! itLImg.IsAtReverseEnd(); itLImg.PreviousLine(), ++y)
					{
						itLImg.GoToBeginOfLine();
						for (x = 0; !itLImg.IsAtEndOfLine(); ++itLImg, ++x)
						{
							float max = 0.0f;
							for (int hi = 0; hi < tablero.data[offset].ocupadas.NumElementos; ++hi, ++offset) {
								THormiga* pHormiga = tablero.data[offset].ocupadas.data[hi];

								max = std::max(max, pHormiga->peso);
							}
							if (tablero.data[offset].ocupadas.NumElementos > 0) {
								//std::cout << "Maximo local en " << x << ", " << y << " => " << max << std::endl;
							}

						}
					}

					unsigned int mejorOffset = -1;
					float max = -1.0f;
					// Maximo local
					for (int off = 0; off < tablero.Size; ++off)
					{
						for (int hi = 0; hi < tablero.data[off].ocupadas.NumElementos; ++hi)
						{
							if (tablero.data[off].ocupadas.data[hi]->peso > max)
							{
								max = tablero.data[off].ocupadas.data[hi]->peso;
								mejorOffset = off;
							}
						}
					}

					std::cout << "mejor offset: " << mejorOffset << std::endl;

					*/

					typedef itk::RescaleIntensityImageFilter<TImagenInterna, TImagenValoracionInfiltracion> TNormalizeOutputFilter;
					TNormalizeOutputFilter::Pointer normalizeOutputFilter = TNormalizeOutputFilter::New();
					normalizeOutputFilter->SetInput( outputImage );
					normalizeOutputFilter->SetOutputMinimum(0);
					normalizeOutputFilter->SetOutputMaximum(255);
					normalizeOutputFilter->Update();
					#ifdef __WXGTK__
					{
						itk::ImageFileWriter<TImagenValoracionInfiltracion>::Pointer w = itk::ImageFileWriter<TImagenValoracionInfiltracion>::New();
						w->SetInput(normalizeOutputFilter->GetOutput());
						w->SetFileName("/tmp/wtest.bmp");
						w->Update();
					}
					#endif
					//return normalizeOutputFilter->GetOutput();
				}

				~Data()
				{
				}

			};
		}
	}
}

//region "Implementacion de WBuilder"

GNC::GCS::Widgets::WGradienteBuilder::WGradienteBuilder(GNC::GCS::IWidgetsManager* pManager, vtkImageData* imgData, long vid, long gid) : GNC::GCS::Widgets::IWidgetBuilder(pManager, gid), IObservadorWidget(vid, gid)
{
	m_pImgData = imgData;
	m_Estado = WBS_Ninguno;

	m_pManager->InsertarObservador(this);

	m_Data = new Data(imgData);
}

GNC::GCS::Widgets::WGradienteBuilder::~WGradienteBuilder()
{
	m_pManager->EliminarObservador(this);
	glDeleteLists(m_Data->m_LIndex, 1);
	m_Data->m_LIndex = 0;
}

void GNC::GCS::Widgets::WGradienteBuilder::OnWidgetDestruido(GNC::GCS::Widgets::IWidget* /*w*/) {

}

//region "Interfaz especifica"
void GNC::GCS::Widgets::WGradienteBuilder::OnMouseEvents(GNC::GCS::Eventos::EventoRaton& /*event*/)
{
	/*
	if (!m_pManager) {
		return;
	}

	if (event.evt.ButtonDown(wxMOUSE_BTN_LEFT)) {
		m_PosicionCursor.asignar(event.wX, event.wY);
		m_pManager->Modificado();
		event.evt.Skip(false);
	}
	*/
	GTRACE("GNC::GCS::Widgets::WGradienteBuilder::OnMouseEvents(wxMouseEvent&)");
}

void GNC::GCS::Widgets::WGradienteBuilder::OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&)
{
	GTRACE("GNC::GCS::Widgets::WGradienteBuilder::OnKeyEvents(wxKeyEvent&)");
}

void GNC::GCS::Widgets::WGradienteBuilder::Render(GNC::GCS::Contexto3D* /*c*/)
{
	glCallList(m_Data->m_LIndex);

	/*
	glMatrixMode(GL_MODELVIEW);

	glPointSize(5.0f);
	glLineWidth(2.0f);


	GNC::GCS::Vector spc(m_Data->spacing[0], m_Data->spacing[1]);

	typedef itk::ImageRegionIteratorWithIndex< Data::TImagenVectorGradiente >  TIteradorVectorGradiente;

	TIteradorVectorGradiente itGrad(m_Data->imgGrad, m_Data->imgGrad->GetLargestPossibleRegion());

	GNC::GCS::Vector posRedondeada = m_PosicionCursor.Redondeado();

	bool hover = false;

	for (itGrad.GoToBegin(); ! itGrad.IsAtEnd(); ++itGrad)
	{

		hover = false;

		Data::TImagenVectorGradiente::IndexType index = itGrad.GetIndex();
		Data::TImagenVectorGradiente::PixelType& pixel = itGrad.Value();

		GNC::GCS::Vector p0 = GNC::GCS::Vector(index[0], index[1] - m_Data->dimensions[1]) * spc;
		GNC::GCS::Vector p1 = p0 + GNC::GCS::Vector(pixel[0], pixel[1]);

		hover = (posRedondeada == p0);

		if (hover) {
			glColor4f(1.0f, 0.0f, 0.0f, 0.5f);
		}
		else {
			glColor4f(0.0f, 0.0f, 0.5f, 0.5f);
		}

		glBegin(GL_POINTS);
			glVertex2d(p0.x, p0.y);
		glEnd();

		if (hover) {
			glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
			glLineWidth(4.0f);
		}
		else {
			glColor4f(0.0f, 0.5f, 0.0f, 0.5f);
			glLineWidth(2.0f);
		}

		glBegin(GL_LINES);
			glVertex2d(p0.x, p0.y);
			glVertex2d(p1.x, p1.y);
		glEnd();
	}
	*/
}

//endregion

