/*
 *  
 *  $Id: wanotacionesquina.h 3687 2011-04-13 13:20:56Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwidgets.h>
#include <api/api.h>
#include <api/ianotador.h>
#include <api/icontroladoreventos.h>
#include <vector>
#include <list>
#include "openglhelper.h"

#define TAMFUENTE 12.0f
#define TAMFUENTE_MIN 10.0f
#define PROPVIEWPORT 0.40f // Proporcion maxima del viewport, tanto de ancho como de alto. (25%)

namespace GNC {
	namespace GCS {

		namespace Widgets {

			class EstadoInterno;
			class Anotaciones;

			//----------------------------------------------------------------------------------------------------
			//region Widget anotador
			class EXTAPI WAnotador : public GNC::GCS::Widgets::IWidget, public GNC::GCS::IObservador {
			public:

				WAnotador(GNC::GCS::IAnotador* annotator, IWidgetsManager* pManager, long vid, const char* nombre, long gid);

				~WAnotador();

				virtual void LiberarRecursos(GNC::GCS::IWidgetsRenderer* renderer);
			//endregion

			//----------------------------------------------------------------------------------------------------
			//region "Interfaz generica"
			public:
				virtual void OnMouseEvents(GNC::GCS::Eventos::EventoRaton&);

				virtual void OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&);

				virtual bool HitTest(float x, float y, float umbralCuadrado);

				virtual bool HitTest(GNC::GCS::Vector* vertices, int numVertices);

				virtual void Render(GNC::GCS::Contexto3D* c);

				virtual void OffscreenRender(Contexto3D* c);

				virtual void Modificar(bool modificar);

				virtual void Seleccionar(bool seleccionado);

				virtual void Iluminar(bool iluminado);

				virtual void Ocultar(bool oculto);

				virtual void RecalcularEstaticas(Anotaciones* pAnotaciones, GNC::GCS::Contexto3D* c);

			//endregion

				//----------------------------------------------------------------------------------------------------
				//region "Interfaz especifica"
			public:
				virtual void SetAnotador(GNC::GCS::IAnotador* anotador);
				virtual void SetTextColor(const GNC::GCS::GLHelper::TColor& color);
				GNC::GCS::IAnotador* m_pAnnotator;
				//endregion

			public:

				typedef enum TPosicionAnotacion {
					TP_TopLeft = 0,
					TP_TopRight,
					TP_BottomLeft,
					TP_BottomRight,
					TP_NumPosiciones
				} TPosicionAnotacion;

				//endregion

				void InvalidarTodas();

			//----------------------------------------------------------------------------------------------------
			//region "Interfaz de eventos ginkgo"
			public:

				virtual void PreProcesarEvento(GNC::GCS::Eventos::IEvento *evt, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& lista);

				virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);

			//endregion

			//----------------------------------------------------------------------------------------------------
			//region "Estado interno"
			protected:

				EstadoInterno* m_Estado;				
				GNC::GCS::GLHelper::TColor m_color;

			//endregion

			};
			//endregion
		}
	}
}
