/*
 *  
 *  $Id: widgetsmanager.h 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once


#include <wx/event.h>

#include <api/iwidgets.h>
#include <api/iwidgetsmanager.h>
#include <api/observers/iwidgetsobserver.h>
#include <api/ianotador.h>
#include <api/icontroladoreventos.h>

//----------------------------------------------------------------------------------------------------
//Forward Declarations

namespace GNC {
	namespace GCS {
		class IWidgetsRenderer;
	}
}
class TimerAnimation;
class wxMenu;

//End Forward Declarations

namespace GNC {
	class WidgetsManager : public wxEvtHandler, public GNC::GCS::IWidgetsManager, public GNC::GCS::IObservador {

	public:
		WidgetsManager(GNC::GCS::IVista* pVista);
		virtual ~WidgetsManager();

	//----------------------------------------------------------------------------------------------------
	//region "Interfaz especifica"

		virtual void RenderPrivate(GNC::GCS::Contexto3D* c);
		
		virtual void TickAnimation(double freq);

		virtual void EnableAnimation();

		virtual void DisableAnimation();

		virtual void Render();

		virtual void OffScreenRender(GNC::GCS::Contexto3D* c);

		virtual void Modificado();
		
		virtual void ModificadoPorWidget(GNC::GCS::Widgets::IWidget* w);

		virtual void OnMouseEvents(GNC::GCS::Eventos::EventoRaton& evento);

		virtual void OnKeyEvents(GNC::GCS::Eventos::EventoTeclado& evento);

		virtual void DefaultMouseEventProcess(GNC::GCS::Eventos::EventoRaton& evento);

		virtual void DefaultKeyEventProcess(GNC::GCS::Eventos::EventoTeclado& event);

		// Propaga a todos los widgets no ocultos un hit test de seleccion. Los widgets se seleccionan si validan un hittest con el bounding box especificado.
		virtual void PropagarHitTestSeleccion(GNC::GCS::Vector* vertices, int numVertices);

	//endregion

	//----------------------------------------------------------------------------------------------------
	//region "Interfaz de registro de Renderers"

	public:

		virtual void SetRendererActivo(GNC::GCS::IWidgetsRenderer* pRenderer);

		virtual void InsertarRenderer(GNC::GCS::IWidgetsRenderer* pRenderer);

		virtual void EliminarRenderer(GNC::GCS::IWidgetsRenderer* pRenderer);

		virtual void LiberarRecursos(GNC::GCS::IWidgetsRenderer* pRenderer);

	//endregion

	//----------------------------------------------------------------------------------------------------
	//region "Interfaz de registro de IWidget's"

		virtual void InsertarWidget(GNC::GCS::Widgets::IWidget* pWidget, bool propagarEvento=true);

		virtual void EliminarWidget(GNC::GCS::Widgets::IWidget* pWidget, bool propagarEvento=true);

		virtual void EliminarWidget(GNC::GCS::IWidgetsManager::IteradorListaWidgets& it, bool propagarEvento=true);

		virtual void EliminarTodosLosWidgets(bool propagarEventos=true);

		virtual void OcultarTodosLosWidgets(bool ocultar, long GID);

		virtual void EliminarTodosLosWidgets(long GID);

		virtual void OcultarWidgetsDeSubVista(bool ocultar, long vid);

		virtual GNC::GCS::ListaWidgets& GetListaWidgets();

		virtual void GetListaWidgetsSubVista(long vid, GNC::GCS::ListaWidgets& lista);

	//endregion

	//----------------------------------------------------------------------------------------------------
	//endregion "Interfaz de Observadores"

		virtual void NotificarCreacion(GNC::GCS::Widgets::IWidget* pWidget);

		virtual void NotificarDestruccion(GNC::GCS::Widgets::IWidget* pWidget);

		virtual void NotificarModificacion(GNC::GCS::Widgets::IWidget* pWidget);

	//endregion

	//----------------------------------------------------------------------------------------------------
	//region "Interfaz anotacion estatica"

		virtual void CrearWidgetAnotador(GNC::GCS::IAnotador* pAnotador);
		virtual void EnableAnotacionDinamica(bool enable);
		virtual void MostrarOcultarAnotador();
		virtual bool IsVisibleAnotador();

	//enderegion

	//----------------------------------------------------------------------------------------------------
	//region "Interfaz de acceso al sistema de eventos ginkgo"

		virtual void LanzarEventoCreacion(GNC::GCS::Widgets::IWidget* w);
		virtual void LanzarEventoModificacion(GNC::GCS::Widgets::IWidget* w);
		virtual void LanzarEventoDestruccion(GNC::GCS::Widgets::IWidget* w);
		virtual GNC::GCS::IControladorEventos* GetControladorEventos();

		virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);

	//endregion

	//----------------------------------------------------------------------------------------------------
	//region "Gestion propia de WX"

		virtual void OnClickEnEliminar(wxCommandEvent& );

		virtual void OnClickEnPropiedades(wxCommandEvent& );

		virtual bool GetMenuContextual(wxMenu* menuContextual) const;

	//endregion

	//----------------------------------------------------------------------------------------------------
	//region "Cursores
		virtual void SetCursor(GNC::GCS::Widgets::TipoCursor cursor);
	//endregion

		bool m_mouseDerechoDown;
		bool m_mouseIzquierdoDown;
		
	//----------------------------------------------------------------------------------------------------
	//region "Helpers"
	private:
		inline void ModificarRenderersDeWidget(GNC::GCS::Widgets::IWidget* w);
		TimerAnimation* m_pTimerAnimation;
	//endregion
	};
}
