/*
 *  
 *  $Id: acceptlicensedialog.cpp 3893 2011-06-21 13:01:56Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "acceptlicensedialog.h"
#include <main/controllers/configurationcontroller.h>
#include <main/entorno.h>
#include <api/globals.h>
#include <main/licencia.h>
#include <string>
#include <sstream>


GNC::GUI::AcceptLicenseDialog::AcceptLicenseDialog(wxWindow* pPadre):GNC::GUI::AcceptLicenseDialogBase(pPadre)
{
	std::stringstream is;
	is << _Std("Ginkgo CADx license agreement version  ") << GNC::Entorno::Instance()->GetGinkgoVersion() << std::endl;	
	is << std::endl;	
	is << GINKGO_MENSAJE_LICENCIA << std::endl;
	is << std::endl;
	is << GNC::Entorno::Instance()->GetGinkgoCopyRight() << " MetaEmotion Healthcare " ;
	is << "http://healthcare.metaemotion.com" << std::endl;
	is << "contacto@metaemotion.com";

	m_pTextoLicencia->SetValue(wxString::FromUTF8(is.str().c_str()));
	Layout();
	m_buttonAceptar->SetFocus();
}

GNC::GUI::AcceptLicenseDialog::~AcceptLicenseDialog()
{
}

void GNC::GUI::AcceptLicenseDialog::OnAceptarClick(wxCommandEvent &event)
{
	GNC::GCS::ConfigurationController::Instance()->writeBoolGeneral("/GinkgoCore/Estacion", "CheckForUpdates", m_pCheckForUpdates->GetValue());
	GNC::GCS::ConfigurationController::Instance()->Flush();
	event.Skip(true);
}
