/*
 *  
 *  $Id: selectimagesimportation.cpp 3934 2011-07-07 08:47:50Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <vector>
#include <sstream>

#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/file.h>
#include <wx/filedlg.h>
#include <wx/dnd.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>
#include <wx/pen.h>
#include <wx/sizer.h>
#include <wx/aui/auibar.h>
#include <wx/arrstr.h>

#include <wx/ginkgostyle/ginkgostyle.h>

#include <api/imodelointegracion.h>
#include <api/math/geometria.h>
#include <resources/ginkgoresourcemanager.h>

#include <yasper/yasper.h>
#include <main/entorno.h>

#include "selectimagesimportation.h"
#include <api/icontextoestudio.h>


namespace GNC {
	namespace GUI {
		class ButtonsBar:public wxAuiToolBar{
		public:
			ButtonsBar(wxWindow* pParent, const wxColour& color, const wxFont& fuente): wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize, wxAUI_TB_HORZ_TEXT)
			{
				SetToolBitmapSize(wxSize(16,16));

				wxAuiDefaultToolBarArt* pToolArt= new wxAuiDefaultToolBarArt();
			#if defined(USE_PATCHED_LIBS) && !defined(__WXOSX__)
				pToolArt->SetBaseColor(color);

				pToolArt->SetFont(fuente);
			#endif
				SetArtProvider(pToolArt);

				Realize();
			}

			~ButtonsBar()
			{
			}
		};

		//drag&drop
		class DropTargetSelectImages: public wxFileDropTarget
		{
		public:
			DropTargetSelectImages(SelectImagesImportation* pParent, const std::list<std::string>& fileSpecs):wxFileDropTarget()
			{
				m_pParent = pParent;
				m_fileSpecs = fileSpecs;
			}
			~DropTargetSelectImages()
			{
			}
			bool OnDropFiles(wxCoord /*x*/, wxCoord /*y*/, const wxArrayString& filenames)
			{
				wxArrayString images;
				std::list<std::string> listaPaths;
				for(wxArrayString::const_iterator it = filenames.begin(); it!= filenames.end(); it++)
				{
					if(wxDirExists((*it))) {
						//se leen los ficheros dicom del directorio
						wxDir dir;
						if (dir.Open((*it))) {
							for (std::list<std::string>::iterator itSpecs = m_fileSpecs.begin(); itSpecs != m_fileSpecs.end(); ++itSpecs) {
								wxString wxPathFich;
								bool cont = dir.GetFirst(&wxPathFich, wxString::FromUTF8((*itSpecs).c_str()));
								while (cont) {
									wxPathFich=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +wxPathFich;	
									images.push_back(wxPathFich);							
									cont = dir.GetNext(&wxPathFich);
								}
							}
#if !defined(_WINDOWS)
							for (std::list<std::string>::iterator itSpecs = m_fileSpecs.begin(); itSpecs != m_fileSpecs.end(); ++itSpecs) {
								wxString wxPathFich;
								bool cont = dir.GetFirst(&wxPathFich, wxString::FromUTF8((*itSpecs).c_str()).Upper());
								while (cont) {
									wxPathFich=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +wxPathFich;	
									images.push_back(wxPathFich);							
									cont = dir.GetNext(&wxPathFich);
								}
							}
#endif
						}
					} else if(wxFileExists((*it))){
						wxFileName filename((*it));
						wxString extensionFile = filename.GetExt().Lower();
						for (std::list<std::string>::iterator itSpecs = m_fileSpecs.begin(); itSpecs != m_fileSpecs.end(); ++itSpecs) {
							wxFileName ext(wxString::FromUTF8((*itSpecs).c_str()).Lower());
							if (extensionFile == ext.GetExt().Lower()) {
								images.push_back((*it));
								break;
							}
						}
					}
				}
				m_pParent->AddImages(images);
				return true;
			}

			SelectImagesImportation* m_pParent;
			std::list<std::string> m_fileSpecs;
		};
		//

		SelectImagesImportation::SelectImagesImportation(wxWindow* pParent,std::string& dirTemp, IWizard* pWizard, bool reescalar, GnkPtr<GIL::IModeloIntegracion>& pModeloIntegracion, const std::list<std::string>& fileSpecs, const wxString& defaultFilter) : SelectImagesImportationBase(pParent), IPasoWizard(pWizard)
		{			
			SetScrollbars(10, 10, 50, 50, 0, 0, false);
			AdjustScrollbars();
			m_firstAttach = true;
			
			std::list<std::string> m_fileSpecs = fileSpecs;
			if (defaultFilter.IsEmpty()) {
#if defined(_WIN32) || defined(__WXMAC__)
				m_pDefaultFilter =_("Images (*.jpg;*.jpeg;*.bmp;*.png;*.tif;*.tiff)|*.jpg;*.jpeg;*.bmp;*.png;*.tif;*.tiff|JPEG Images (*.jpg;*.jpeg)|*.jpg;*.jpeg|BMP Images (*.bmp)|*.bmp|PNG Images (*.png)|*.png|TIFF Images (*.tif;*.tiff)|*.tif;*.tiff|All files(*.*)|*.*");
#else
				m_pDefaultFilter =_("Images (*.jpg;*.jpeg;*.bmp;*.png;*.tif;*.tiff)|*.jpg;*.jpeg;*.bmp;*.png;*.tif;*.tiff;*.JPG;*.JPEG;*.BMP;*.PNG;*.TIF;*.TIFF|JPEG Images (*.jpg;*.jpeg)|*.jpg;*.jpeg;*.JPG;*.JPEG|BMP Images (*.bmp)|*.bmp;*BMP|PNG Images (*.png)|*.png;*PNG|TIFF Images (*.tif;*.tiff)|*.tif;*.tiff;*TIF;*TIFF|All files (*.*)|*.*");
#endif
				m_fileSpecs.push_back("*.jpg");
				m_fileSpecs.push_back("*.jpeg");
				m_fileSpecs.push_back("*.bmp");
				m_fileSpecs.push_back("*.png");
				m_fileSpecs.push_back("*.tif");
				m_fileSpecs.push_back("*.tiff");
			} else {
				m_pDefaultFilter = defaultFilter;
			}

			m_pModeloIntegracion = pModeloIntegracion;
			Hide();
			m_dirTemp = dirTemp;
			m_reescalar = reescalar;

			wxColour barColor = wxColour(200,200,200);
			wxFont fontBar = wxFont( 10, 70, 90, wxFONTWEIGHT_BOLD, false, wxEmptyString );

			m_pButtonsBar = new ButtonsBar(m_panelStep0, barColor, fontBar);
			int idButton = 0;
			m_pButtonsBar->AddTool(idButton, _("Select files..."), GinkgoResourcesManager::IconosMenus::GetIcoImportar(), _("Select files from filesystem"));
			m_pButtonsBar->Connect(idButton++, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler(SelectImagesImportation::OnSelectFiles), NULL, this);
			
			GNC::GCS::IEntorno::MapaUbicaciones& mapa = GNC::Entorno::Instance()->GetUbicaciones();
			
			for (GNC::GCS::IEntorno::MapaUbicaciones::iterator it = mapa.begin(); it != mapa.end(); it++) {
				GIL::Ubicacion& u = (*it).second;

				m_pButtonsBar->AddTool(idButton, wxString::FromUTF8(u.Titulo.c_str()), GinkgoResourcesManager::IconosMenus::GetIcoImportar(), wxString::FromUTF8(u.Descripcion.c_str()));
				m_pButtonsBar->Connect(idButton++, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler(SelectImagesImportation::OnUbicacionClick), NULL, this);
			}

			m_pButtonsBar->Realize();
			m_pSizerButtons->Add(m_pButtonsBar, 1, wxEXPAND| wxALL, 0);

			m_pImagenes->SetDropTarget(new DropTargetSelectImages(this, m_fileSpecs));
			
			m_pImagenes->Connect(wxEVT_COMMAND_THUMBNAIL_LEFT_DCLICK,wxCommandEventHandler(SelectImagesImportation::OnThumbLeftDClickSelected),NULL,this);
			m_pImagenes->Connect(wxEVT_KEY_DOWN, wxKeyEventHandler(SelectImagesImportation::OnImagenesKeyDown),NULL,this);

			m_panelStep0->Layout();
			Layout();
		}

		void SelectImagesImportation::SetDefaultImage(const wxImage& defaultImage)
		{
			m_pDefaultImage = defaultImage;
		}

		SelectImagesImportation::~SelectImagesImportation()
		{
			m_pImagenes->Disconnect(wxEVT_COMMAND_THUMBNAIL_LEFT_DCLICK,wxCommandEventHandler(SelectImagesImportation::OnThumbLeftDClickSelected),NULL,this);
			m_pImagenes->Disconnect(wxEVT_KEY_DOWN, wxKeyEventHandler(SelectImagesImportation::OnImagenesKeyDown),NULL,this);
		}

		void SelectImagesImportation::OnThumbLeftDClickSelected(wxCommandEvent& event)
		{
			while(m_pImagenes->GetSelection()!=-1){
				m_pImagenes->Delete(m_pImagenes->GetSelection());
			}
			event.Skip();
		}

		void SelectImagesImportation::OnImagenesKeyDown(wxKeyEvent &event)
		{
			if (event.GetKeyCode() == WXK_DELETE || event.GetKeyCode() == WXK_BACK) {
				while(m_pImagenes->GetSelection()!=-1){
					m_pImagenes->Delete(m_pImagenes->GetSelection());
				}
				event.Skip(false);
			}
			else
			{
				event.Skip(true);
			}
		}

		void SelectImagesImportation::OnRemoveAll(wxCommandEvent &event){
			m_pImagenes->Clear();
			event.Skip();
		}

		void SelectImagesImportation::OnSelectFiles(wxCommandEvent & )
		{
			AddImage();
		}

		void SelectImagesImportation::AddImage() {
			std::string pathDefecto;
			GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/Importacion", "PathDefecto", pathDefecto);
			wxString wxPathDefecto = wxString::FromUTF8(pathDefecto.c_str());
			if(wxFileExists(wxPathDefecto) || wxDirExists(wxPathDefecto)) {
				AddImage(wxPathDefecto);
			} else {
				AddImage(wxEmptyString);
			}
		}

		void SelectImagesImportation::AddImage(const wxString& path)
		{
			wxFileDialog seleccionarFichero (this, _("Select images"), path, wxT(""), m_pDefaultFilter, wxFD_OPEN|wxFD_FILE_MUST_EXIST|wxFD_MULTIPLE);
			int response = seleccionarFichero.ShowModal();
			if (response == wxID_OK) {
				Update();
				wxBusyInfo info(_("Creating Thumbnail..."));
				wxArrayString paths;
				seleccionarFichero.GetPaths(paths);
				
				{
					GNC::GCS::ConfigurationController::Instance()->writeStringUser("/GinkgoCore/Importacion", "PathDefecto", std::string(wxPathOnly(seleccionarFichero.GetPath()).ToUTF8()));
					GNC::GCS::ConfigurationController::Instance()->Flush();
				}

				for (wxArrayString::iterator it = paths.begin(); it != paths.end(); it++) {
					wxString& fileName = (*it);
					if(m_pImagenes->FindItemForFilename(fileName)==-1){
						wxThumbnailItem* pItem = NULL;
						if (m_pDefaultImage.IsOk()) {
							pItem = new wxMemoryImageThumbnailItem(fileName, m_pDefaultImage);
						} else {
							pItem = new wxImageThumbnailItem(fileName);
						}						
						m_pImagenes->Insert( pItem, m_pImagenes->GetCount());
					}
				}
			}
		}

		void SelectImagesImportation::AddImages(const wxArrayString& files)
		{
			wxBusyInfo info(_("Creating Thumbnails..."));
			for (wxArrayString::const_iterator it = files.begin(); it != files.end(); it++) {
				const wxString& fileName = (*it);
				if(m_pImagenes->FindItemForFilename(fileName)==-1){
					wxThumbnailItem* pItem = NULL;
					if (m_pDefaultImage.IsOk()) {
						pItem = new wxMemoryImageThumbnailItem(fileName, m_pDefaultImage);
					} else {
						pItem = new wxImageThumbnailItem(fileName);
					}						
					m_pImagenes->Insert( pItem, m_pImagenes->GetCount());
				}
			}
		}

		wxArrayString SelectImagesImportation::GetSelectedPaths(){
			wxArrayString resultado;
			for(int i=0;i<m_pImagenes->GetCount();++i){
				wxThumbnailItem* item=dynamic_cast<wxThumbnailItem*>(m_pImagenes->GetItem(i));
				if(item!=NULL){
					resultado.push_back(item->GetFilename());
				}
			}
			return resultado;
		}

		void SelectImagesImportation::OnUbicacionClick(wxCommandEvent& event)
		{
			int id = event.GetId();
			GNC::GCS::IEntorno::MapaUbicaciones& mapa = GNC::Entorno::Instance()->GetUbicaciones();
			GNC::GCS::IEntorno::MapaUbicaciones::iterator it = mapa.begin();
			for (int i = 1; i != id && it != mapa.end(); i++, ++it);
			GIL::Ubicacion& u = (*it).second;
			wxString pathUbicacionWx = wxString::FromUTF8(u.Ruta.c_str());
			AddImage(pathUbicacionWx);
		}

//region "Metodos heredados de Ipasowizard"

		void SelectImagesImportation::Attach(wxSizer *sizer){
			if (m_firstAttach) {
				wxCommandEvent openDialogEvent(wxEVT_COMMAND_TOOL_CLICKED, 0);
				m_pButtonsBar->AddPendingEvent(openDialogEvent);
				m_firstAttach = false;
			}
			Show(true);
			sizer->Add(this, 1, wxEXPAND);
			this->GetParent()->Layout();
		}

		void SelectImagesImportation::Detach(wxSizer *sizer){
			Hide();
			sizer->Detach(this);
			sizer->GetContainingWindow()->Layout();
		}

		std::string SelectImagesImportation::GetTitle(){
			return _Std("Image selection");
		}

		std::string SelectImagesImportation::GetSubTitle(){
			return _Std("You must select the images you want to import");
		}

		bool SelectImagesImportation::Siguiente(){
			return true;
		}

		bool SelectImagesImportation::Anterior(){
			return false;
		}

		bool SelectImagesImportation::Cancelar(){
			return true;
		}

		bool SelectImagesImportation::Validar(){
			wxArrayString paths=this->GetSelectedPaths();
			if(paths.GetCount()==0){
				wxMessageBox(_("You must select at least one image"), _("Info"),
					 wxOK | wxICON_INFORMATION, this);
				return false;
			}

			m_pListaFicheros->clear();

			wxString wxDirTemp = FROMPATH(m_dirTemp);

			int dims[2] = {-1,-1};
			//dimensiones del mas grande
			GNC::GCS::Vector vectorMaximo(-1.0,-1.0);
			GNC::GCS::Vector vectorOrigen(0.0,0.0);
			//
			bool redimensionar = false;
			if (m_reescalar) {
				//se leen las imagenes para ver que tengan la misma dimension
				for(wxArrayString::iterator it=paths.begin();it!=paths.end();++it){
					if(!wxFileName::FileExists((*it))){
						wxString str(_("The file"));
						wxMessageBox(str <<(*it) <<_(" doesn't exist"), _("Info"),
						 wxOK | wxICON_INFORMATION, this);
						m_pListaFicheros->clear();
						//el fichero no existe
						return false;
					}
					wxImage img((*it));
					if(img.Ok())
					{
						if(dims[0]==-1 && dims[1]==-1){
							dims[0]=img.GetWidth();
							dims[1]=img.GetHeight();
							vectorMaximo.x =(double) std::max<double>(img.GetWidth(),img.GetHeight());
							vectorMaximo.y =(double) std::min<double>(img.GetWidth(),img.GetHeight());
						} else {
							if(!( (dims[0] == img.GetWidth() && dims[1] == img.GetHeight()) || (dims[1] == img.GetWidth() && dims[0] == img.GetHeight()) )){
								redimensionar = true;
								GNC::GCS::Vector v1((double)std::max<double>(img.GetWidth(),img.GetHeight()),(double)std::min<double>(img.GetWidth(),img.GetHeight()));
								if(!v1.DentroDeBoundingBox(vectorOrigen,vectorMaximo)){
									vectorMaximo.x = std::max<double>(vectorMaximo.x,v1.x);
									vectorMaximo.y = std::max<double>(vectorMaximo.y,v1.y);
								}
							}
						}

						wxFileName fileName((*it));
						std::string path(TOPATH((*it)));
						m_pListaFicheros->push_back(path);
					} else {
						wxString str(_("The file"));
						wxMessageBox(str <<(*it) <<_(" couldn't be readed"), _("Info"),
						 wxOK | wxICON_INFORMATION, this);
						m_pListaFicheros->clear();
						return false;
					}
				}

				//por ultimo si hay que redimensionar se redimensionan proporcionalmente y se rellena con negros
				if (redimensionar && m_reescalar){
					int answer = wxMessageBox(_("All images must have the same dimensions.\nDo you want to continue resizing the images to the size of the largest?"),_("Different dimensions between images"), wxYES_NO , this);
					if (answer == wxNO) {
						m_pListaFicheros->clear();
						//el fichero no existe
						return false;
					}
					wxBusyInfo infoDlg(_("Scaling images, may take a while ..."), this);
					for(ListaFicheros::iterator it = m_pListaFicheros->begin(); it!= m_pListaFicheros->end(); it++){
						wxImage img(FROMPATH((*it)));
						if(!( (vectorMaximo.x == img.GetWidth() && vectorMaximo.y == img.GetHeight()) || (vectorMaximo.x == img.GetWidth() && vectorMaximo.y == img.GetHeight()) )){
							//primero se rescala proporcionalmente
							double scale;
							if(img.GetHeight() > img.GetWidth()){
								scale = (double)vectorMaximo.x / img.GetHeight();
							} else {
								scale = (double)vectorMaximo.x / img.GetWidth();
							}
							img = img.Rescale(img.GetWidth()*scale,img.GetHeight()*scale,wxIMAGE_QUALITY_HIGH);
							//se cambia el tamaño hasta el maximo
							if(img.GetHeight() > img.GetWidth()){
								wxPoint punto((vectorMaximo.y / 2) - ((float)img.GetWidth()/2),0);
								img = img.Resize(wxSize(vectorMaximo.y,vectorMaximo.x),punto,0,0,0);
							} else {
								wxPoint punto(0,(vectorMaximo.y / 2) - ((float)img.GetHeight()/2));
								img = img.Resize(wxSize(vectorMaximo.x,vectorMaximo.y),punto,0,0,0);
							}

							wxFileName fileName(FROMPATH((*it)));
							wxString nombreImagenTemporal = wxDirTemp + wxFileName::GetPathSeparator() + fileName.GetName() + wxString::Format(wxT("%d"),rand()) + wxT(".jpg");
							while(wxFile::Exists(nombreImagenTemporal))
							{
								//si existe se busca uno que no exista
								nombreImagenTemporal= wxDirTemp + wxFileName::GetPathSeparator() + fileName.GetName() + wxString::Format(wxT("%d"),rand()) + wxT(".jpg");
							}
							img.SetOption(wxIMAGE_OPTION_QUALITY,100);
							img.SaveFile(nombreImagenTemporal);
							(*it) = TOPATH(nombreImagenTemporal);

						}
					}
				}
			} else {
				//file must exist
				for(wxArrayString::iterator it=paths.begin();it!=paths.end();++it){
					if(!wxFileName::FileExists((*it))){
						wxString str(_("The file"));
						wxMessageBox(str <<(*it) <<_(" doesn't exist"), _("Info"),
						 wxOK | wxICON_INFORMATION, this);
						m_pListaFicheros->clear();
						//el fichero no existe
						return false;
					}
					
					wxFileName fileName((*it));
					std::string path(TOPATH((*it)));
					m_pListaFicheros->push_back(path);
				}
			}

			//
			return true;
		}
	//endregion
	}
}
