/*
 *  
 *  $Id: panelconfiguraciongeneral.h 3673 2011-04-11 13:49:47Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <string>
#include <vector>
#include <map>
#include <api/iconfiguracion.h>
#include "panelesconfiguracionginkgobase.h"

namespace GNC {
	namespace GUI {

		class PanelConfiguracionGeneral : public PanelConfiguracionGeneralBase, public IPasoConfiguracion
		{
			public:
				PanelConfiguracionGeneral(wxWindow* pParent,IDialogoConfiguracion* pDialogo);
				~PanelConfiguracionGeneral();

				void Recargar();

				//region "Metodos de IPasoConfiguracion"
				wxWindow* GetPanel();

				std::string GetTitle();

				std::string GetCabecera();

				bool Validar();

				bool Guardar();

				void Exportar(wxXmlNode* pNodo);

				void Importar(wxXmlNode* pNodo);

				//endregion


			protected:
				wxString m_pathDicomDir;
				void OnCheckForUpdates(wxCommandEvent &event);
				void OnTextoCambiado(wxCommandEvent &event);
				void OnIdiomaCambiado(wxCommandEvent &event);
				void OnSeleccionarDirectorio(wxCommandEvent &event);
				void OnSize(wxSizeEvent& event);
				bool m_idiomaCambiado;
				typedef std::map<std::string, int> TMapLanguages;
				TMapLanguages m_mapLanguages;
		};
	}
}
