/*
 *  
 *  $Id: filtros.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include "ifiltro.h"

#include <api/ivista.h>
#include <main/entorno.h>
#include <main/controllers/controladoreventos.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <vtkSmartPointer.h>
#include <vtkImageData.h>
#include <itkRGBPixel.h>
#include <itkImage.h>

//class MEF_ImagenRGBLight;
//class MEF_ImagenMapaFloat;

namespace GNC {
	class FiltroNulo : public IFiltro
	{
	public:

		typedef itk::RGBPixel<double>                            TPixelRGB;
		typedef itk::Image<TPixelRGB, 2>                         TImagenITKRGB2D;
		typedef itk::Image<TPixelRGB, 3>                         TImagenITKRGB3D;
		//typedef MEF_ImagenRGBLight                               TImagenMEFRGB2D;
		typedef itk::Image<double, 2>                            TImagenITKIntensidad2D;
		typedef itk::Image<double, 3>                            TImagenITKIntensidad3D;
		//typedef MEF_ImagenMapaFloat                              TImagenMEFIntensidad2D;

		FiltroNulo (Implementacion implementacion = IF_ITK, bool filtro3D = false);

		~FiltroNulo ();

		virtual void Configurar();

		virtual void Procesar(GNC::GCS::IVista* pVista);

	protected:

		virtual TImagenITKRGB2D::Pointer ProcesarImagen(TImagenITKRGB2D::Pointer imagen);

		virtual TImagenITKRGB3D::Pointer ProcesarImagen(TImagenITKRGB3D::Pointer imagen);

//		virtual TImagenMEFRGB2D* ProcesarImagen(TImagenMEFRGB2D* imagen);

		virtual TImagenITKIntensidad2D::Pointer ProcesarImagen(TImagenITKIntensidad2D::Pointer imagen);

		virtual TImagenITKIntensidad3D::Pointer ProcesarImagen(TImagenITKIntensidad3D::Pointer imagen);

		//virtual TImagenMEFIntensidad2D* ProcesarImagen(TImagenMEFIntensidad2D* imagen);

	protected:
		vtkSmartPointer<vtkImageData> m_pImagen;

	};

	//-----------------------------------------------------------------------

	class FiltroMRIBias : public FiltroNulo
	{
	public:

		FiltroMRIBias () : FiltroNulo(IF_ITK, true) {}

		~FiltroMRIBias () {}

	protected:

		virtual TImagenITKIntensidad3D::Pointer ProcesarImagen(TImagenITKIntensidad3D::Pointer imagen);
	};

	//-----------------------------------------------------------------------

	class FiltroMediana : public FiltroNulo
	{
	public:

		FiltroMediana () : FiltroNulo() {}

		~FiltroMediana () {}

	protected:

		virtual TImagenITKIntensidad2D::Pointer ProcesarImagen(TImagenITKIntensidad2D::Pointer imagen);
	};

	//-----------------------------------------------------------------------

	class FiltroGaussiano : public FiltroNulo
	{
	public:

		FiltroGaussiano () : FiltroNulo() {}

		~FiltroGaussiano () {}

	protected:

		virtual TImagenITKIntensidad2D::Pointer ProcesarImagen(TImagenITKIntensidad2D::Pointer imagen);
	};

	//-----------------------------------------------------------------------

	class FiltroCurvatureFlow : public FiltroNulo
	{
	public:

		FiltroCurvatureFlow () : FiltroNulo() {}

		~FiltroCurvatureFlow () {}

	protected:

		virtual TImagenITKIntensidad2D::Pointer ProcesarImagen(TImagenITKIntensidad2D::Pointer imagen);
	};

	//-----------------------------------------------------------------------

	class FiltroSobel : public FiltroNulo
	{
	public:

		FiltroSobel () : FiltroNulo() {}

		~FiltroSobel () {}

	protected:

		virtual TImagenITKIntensidad2D::Pointer ProcesarImagen(TImagenITKIntensidad2D::Pointer imagen);
	};

	//-----------------------------------------------------------------------

	class FiltroAutoNiveles : public FiltroNulo
	{
	public:

		FiltroAutoNiveles () : FiltroNulo() {}

		~FiltroAutoNiveles () {}

	protected:

		virtual TImagenITKIntensidad2D::Pointer ProcesarImagen(TImagenITKIntensidad2D::Pointer imagen);

		virtual TImagenITKRGB2D::Pointer ProcesarImagen(TImagenITKRGB2D::Pointer imagen);

		virtual TImagenITKRGB3D::Pointer ProcesarImagen(TImagenITKRGB3D::Pointer imagen);
	};

	//-----------------------------------------------------------------------

/*	class FiltroPegado : public IFiltro
	{

	public:

		FiltroPegado () : IFiltro(IF_MEF,true) {}

		~FiltroPegado () {}

		virtual void Procesar(GNC::GCS::IVista* pVista) ;

	protected:

	};*/
}
