/*
 *
 *  $Id: dicommanager.cpp 3830 2011-05-06 13:30:18Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
//para la comprobacion de si esta correcto el fichero
#include <wx/file.h>
#include <wx/strconv.h>

#include <api/globals.h>
#include "dicommanager.h"
#include <sstream>
#include <queue>
#include <stack>
#include <cstdio>
#include <api/icontextoestudio.h>

#ifdef verify
#define MACRO_QUE_ESTORBA verify
#undef verify
#endif
#include <dcmtk/config/osconfig.h>
#include <dcmtk/dcmdata/dctk.h>
#include "dcmtk/dcmimgle/dcmimage.h"
#include <dcmtk/dcmdata/dcrledrg.h>
#include <dcmtk/dcmjpeg/djdecode.h>  /* for dcmjpeg decoders */
#ifdef MACRO_QUE_ESTORBA
#define verify MACRO_QUE_ESTORBA
#endif



//en este grupo se almacenaran los atributos privados de ginkgo
#define GINKGO_GROUP 0x0011

namespace GIL
{
	namespace DICOM
	{

		// Constructor
		DICOMManager::DICOMManager() {
			m_pDCMDataSet = NULL;
			m_pConv = NULL;
		}

		// Destructor
		DICOMManager::~DICOMManager() {
			if (m_pDCMDataSet != NULL) {
				delete m_pDCMDataSet;
				m_pDCMDataSet = NULL;
			}
			if (m_pConv != NULL) {
				delete m_pConv;
				m_pConv = NULL;
			}
		}

//region "Interfaz"

		/*Almacena la jerarquia cargada en un fichero*/
		bool DICOMManager::AlmacenarFichero(const std::string& inputFile, IInspectCallBack* , bool )
		{
			if (m_pDCMDataSet == NULL) {
				return false;
			}
			FindCharset();
			DcmFileFormat dcmff(m_pDCMDataSet);
			OFCondition cond;
			cond = dcmff.saveFile(inputFile.c_str());
			if (cond.bad()) {
				std::cerr << "Error: " << cond.text() << std::endl;
				return false;
			}
			return true;
		}

		/*Actualiza la jerarquia cargada*/
		int DICOMManager::ActualizarJerarquia(TipoJerarquia& base)
		{
			if (m_pDCMDataSet == NULL) {
				return 0;
			}

			return InsertarJerarquia(base, NULL, NULL);
		}

		/*anonimiza los tags privados*/
		void DICOMManager::AnonimizarTagsPrivados()
		{
			OFCondition cond;
			DcmElement* element;
			unsigned int g=GINKGO_GROUP;
			unsigned int e=0x0010;

			for(;e<=0xFFFF;e++){
				DcmTagKey key(g,e);
				cond = m_pDCMDataSet->findAndGetElement(key,element,false);
				if(element!=NULL){
					m_pDCMDataSet->remove(key);
				}
			}
		}

		/*actualiza los tags privados*/
		int DICOMManager::ActualizarTagsPrivados(TipoPrivateTags& tags){
			if (m_pDCMDataSet == NULL) {
				return 0;
			}

			return InsertarTagsPrivados(tags);
		}

		int DICOMManager::CargarTagsPrivados(GIL::DICOM::TipoPrivateTags& tags) {
			if (m_pDCMDataSet == NULL) {
				return 0;
			}

			return PrivateCargarTagsPrivados(tags);
		}

		/*carga la MetaInfo*/
		int DICOMManager::CargarMetaInfo(const std::string& inputFile, GIL::DICOM::TipoMetaInfo& tags) {

			//comprobamos que es dicom(numero magico, si no el load file a veces casca estrepitosamente)
			if(!EsDicom(inputFile))
			{
				return 0;
			}

			OFCondition cond;
			DcmMetaInfo metaInfo;

			cond = metaInfo.loadFile(inputFile.c_str(), EXS_Unknown, EGL_noChange, DCM_TagInfoLength);
			//metaInfo.loadAllDataIntoMemory();
			//metaInfo.print(std::cout);

			int numInsertados = 0;

			unsigned long elemCount = metaInfo.card();

			for (unsigned long i = 0; i < elemCount; i++) {
				DcmElement *e = metaInfo.getElement(i);
				GTRACE("Procesando objeto MetaInfo: " << e->getTag().toString())
				std::ostringstream os;
				os << std::hex << std::setw(4) << std::setfill('0') << e->getGTag() << "|" << std::hex << std::setw(4) << std::setfill('0') << e->getETag();
				std::string tag = os.str();

				OFString v;
				std::string ov;

				cond = e->getOFStringArray(v, OFTrue);
				if (cond.good()) {
					ov = v.c_str();
				}

				tags.tags[tag] = ov;

				numInsertados++;
			}


			if (cond.bad()) {
				// TODO: Lanzar excepción
				return 0;
			}

			return numInsertados;
		}

		/* Obtiene la jerarquia de campos DICOM del fichero */
		bool DICOMManager::CargarFichero(const std::string& inputFile, GIL::DICOM::TipoJerarquia& jerarquia, bool cargarSoloTagsInfo, IInspectCallBack* /*pICallback*/)
		{
			//comprobamos que es dicom(numero magico, si no el load file a veces casca estrepitosamente)
			if(!EsDicom(inputFile))
			{
				return false;
			}
			//

			if (m_pDCMDataSet != NULL) {
				delete m_pDCMDataSet;
				m_pDCMDataSet = NULL;
			}
			if (m_pConv != NULL) {
				delete m_pConv;
				m_pConv = NULL;
			}

			DcmFileFormat dcmff;
			OFCondition cond;

			if (cargarSoloTagsInfo) {
				cond = dcmff.loadFile(inputFile.c_str(), EXS_Unknown, EGL_noChange, DCM_TagInfoLength);
			}
			else {
				cond = dcmff.loadFile(inputFile.c_str(), EXS_Unknown, EGL_noChange, DCM_MaxReadLength);
			}
			dcmff.loadAllDataIntoMemory();

			if (cond.bad()) {
				// TODO: Lanzar excepción
				return false;
			}

			m_pDCMDataSet = new DcmDataset(*(dcmff.getDataset()));

			FindCharset();

			if(cargarSoloTagsInfo) {
				CargarJerarquia(jerarquia,DCM_OptPrintLineLength);
			} else {
				CargarJerarquia(jerarquia, 0);
			}
			return true;
		}


		/******************/
		//esto espara cargar el fichero sin llevar todo a memoria, solo lo que nos interese con el gettag
		bool DICOMManager::CargarFichero(const std::string& inputFile, bool cargarSoloTagsInfo)
		{
			//comprobamos que es dicom(numero magico, si no el load file a veces casca estrepitosamente)
			if(!EsDicom(inputFile))
			{
				return false;
			}
			//

			if (m_pDCMDataSet != NULL) {
				delete m_pDCMDataSet;
				m_pDCMDataSet = NULL;
			}
			if (m_pConv != NULL) {
				delete m_pConv;
				m_pConv = NULL;
			}

			DcmFileFormat dcmff;
			OFCondition cond;

			if (cargarSoloTagsInfo) {
				cond = dcmff.loadFile(inputFile.c_str(),EXS_Unknown,EGL_noChange,DCM_TagInfoLength);
			}
			else {
				cond = dcmff.loadFile(inputFile.c_str());

			}

			if (cond.bad()) {
				// TODO: Lanzar excepción
				return false;
			}

			cond = dcmff.loadAllDataIntoMemory();

			if (cond.bad()) {
				// TODO: Lanzar excepción
				return false;
			}

			m_pDCMDataSet = new DcmDataset(*(dcmff.getDataset()));

			FindCharset();

			return true;
		}

		bool DICOMManager::GetTag(unsigned int grupo,unsigned int elemento, std::string & valor)
		{
			if(m_pDCMDataSet == NULL){
				//TODO lanzar excepcion de que no esta cargado
				return false;
			}

			FindCharset();

			DcmTagKey key(grupo,elemento);
			DcmElement* pElement;
			m_pDCMDataSet->findAndGetElement(key,pElement);
			if(pElement != NULL)
			{
			    if(pElement->containsUnknownVR()){
			     return false;
			    } else {
                 OFString v;
                 OFCondition cond = pElement->getOFStringArray(v, OFTrue);
                 if (cond.good()) {
					 valor = wxString(v.c_str(), *m_pConv).ToUTF8();
                     return true;
                 } else {
                     return false;
                 }
			    }
			} else {
				return false;
			}
		}

		bool DICOMManager::GetTag(unsigned int grupo,unsigned int elemento, TagPrivadoUndefined& tagBinario)
		{
			if(m_pDCMDataSet == NULL){
				//TODO lanzar excepcion de que no esta cargado
				return false;
			}

			if(grupo == 0x7fe0 && elemento == 0x0010) {
				//es necesario para pillar el pixeldata en explicit little endian
				OFCondition cond = m_pDCMDataSet->chooseRepresentation(EXS_DeflatedLittleEndianExplicit,NULL);
				if(cond.bad()) {
					return false;
				}
			}

			FindCharset();

			DcmTagKey key(grupo,elemento);
			DcmElement* pElement;
			m_pDCMDataSet->findAndGetElement(key,pElement);
			if(pElement != NULL)
			{
				OFCondition cond = pElement->loadAllDataIntoMemory();
				if(cond.good()) {
					Uint8 * ptr;
					cond = pElement->getUint8Array(ptr);
					if(cond.good()) {
						tagBinario.Copiar(ptr,pElement->getLength());
						return true;
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else {
				return false;
			}
		}

		bool DICOMManager::GetTag(unsigned int grupo,unsigned int elemento, float& valor)
		{
			std::string valorstr;
			if(GetTag(grupo,elemento,valorstr))
			{
				valor = 0.0f;
				std::sscanf(valorstr.c_str(),"%f",&valor);
				return true;
			} else {
			    //se intenta interpretar como US
			    if(m_pDCMDataSet == NULL){
                    //TODO lanzar excepcion de que no sta cargado
                    return false;
                }
                DcmTagKey key(grupo,elemento);
                DcmElement* pElement;
                m_pDCMDataSet->findAndGetElement(key,pElement);
                if(pElement != NULL)
                {
                    Uint8 * ptr;
                    OFCondition cond = pElement->getUint8Array(ptr);
                    if(cond.good()) {
                        switch (pElement->getLength()) {
                            case 4:
                                valor = *((Float32*)ptr);
                                return true;
                            break;
                            case 8:
                                valor = *((Float64*)ptr);
                                return true;
                            break;
                            default:
                                return false;
                        }
                    } else {
                        return false;
                    }
                }
				return false;
            }
		}

		bool DICOMManager::GetTag(unsigned int grupo,unsigned int elemento, int& valor)
		{
			std::string valorstr;
			if(GetTag(grupo,elemento,valorstr))
			{
				valor = atoi(valorstr.c_str());
				return true;
			} else {
			    //se intenta interpretar como US
			    if(m_pDCMDataSet == NULL){
                    //TODO lanzar excepcion de que no sta cargado
                    return false;
                }
                DcmTagKey key(grupo,elemento);
                DcmElement* pElement;
                m_pDCMDataSet->findAndGetElement(key,pElement);
                if(pElement != NULL)
                {
                    Uint8 * ptr;
                    OFCondition cond = pElement->getUint8Array(ptr);
                    if(cond.good()) {
                        switch (pElement->getLength()) {
                            case 2:
                                valor = *((Uint16*)ptr);
                                return true;
                            break;
                            case 4:
                                valor = *((Uint32*)ptr);
                                return true;
                            break;
                            default:
                                return false;
                        }
                    } else {
                        return false;
                    }
                }
				return false;
			}
		}

		bool DICOMManager::GetTag(unsigned int grupo,unsigned int elemento, GIL::DICOM::TipoJerarquia& secuencia)
		{
			if(m_pDCMDataSet == NULL){
				//TODO lanzar excepcion de que no sta cargado
				return false;
			}

			DcmTagKey key(grupo,elemento);
			DcmElement* pSequence;
			m_pDCMDataSet->findAndGetElement(key,pSequence);
			if(pSequence != NULL)
			{
				CargarJerarquia(secuencia,DCM_OptPrintLineLength,pSequence);
				return true;
			} else {
				return false;
			}
		}

		bool DICOMManager::FindTag(unsigned int grupo,unsigned int elemento, TagPrivadoUndefined& tagBinario)
		{
			if(m_pDCMDataSet == NULL){
				//TODO lanzar excepcion de que no sta cargado
				return false;
			}

			if( (grupo == 0x7fe0 && elemento == 0x0010) || (grupo == 0x5400 && elemento == 0x1010) ) {
				//es necesario para pillar el pixeldata en explicit little endian
				OFCondition cond = m_pDCMDataSet->chooseRepresentation(EXS_DeflatedLittleEndianExplicit,NULL);
				if(cond.bad()) {
					return false;
				}
			}

			DcmTagKey key(grupo,elemento);
			DcmElement* pElement;
			m_pDCMDataSet->findAndGetElement(key, pElement, OFTrue);
			if(pElement != NULL)
			{
				OFCondition cond = pElement->loadAllDataIntoMemory();
				if(cond.good()) {
					Uint8 * ptr;
					cond = pElement->getUint8Array(ptr);
					if(cond.good()) {
						tagBinario.Copiar(ptr,pElement->getLength());
						return true;
					} else {
						Uint16 * ptr2;
						cond = pElement->getUint16Array(ptr2);
						if(cond.good()) {
							tagBinario.Copiar(ptr2, pElement->getLength());
							return true;
						} else {
							return false;
						}
					}
				} else {
					return false;
				}
			} else {
				return false;
			}
		}

		/* returns the oid name or empty string if not found */
		std::string DICOMManager::GetOIDName(const std::string &oid)
		{
			const char* name = dcmFindNameOfUID(oid.c_str());
			if (name != NULL) {
				return std::string(name);
			}
			else {
				return std::string("");
			}


		}

		/* devuelve la descripcion de este tag*/
		std::string DICOMManager::GetDescription(const std::string &clave)
		{
			unsigned int g = 0xffff;
			unsigned int e = 0xffff;
			int n;

			n = sscanf(clave.c_str(), "%x|%x", &g, &e);
			if (n  == 2) // if at least no tag could be parsed
			{
				DcmTagKey key(g,e);
				const DcmDataDictionary& globalDataDict = dcmDataDict.rdlock();
				const DcmDictEntry *dicent = globalDataDict.findEntry(key,NULL);
				dcmDataDict.unlock();
				if (dicent != NULL) {
					return std::string(dicent->getTagName());
				}
			}
			return std::string("");

		};

		std::string DICOMManager::GetNewUID()
		{
			char newUID[100];
			dcmGenerateUniqueIdentifier(newUID, SITE_INSTANCE_UID_ROOT);
			return std::string(newUID);
		}

		bool DICOMManager::EsDicom(const std::string& inputFile) {
			//comprobamos que es dicom(numero magico, si no el load file a veces casca estrepitosamente)
			wxFile fichero(FROMPATH(inputFile),wxFile::read);
			bool esDicom = false;
			if(fichero.IsOpened()){
				char buffer[128];
				if(fichero.Read(buffer,128) == 128){
					char numeroMagico[4];
					if(fichero.Read(numeroMagico,4) == 4){
						std::string str(numeroMagico,4);
						if(str == "DICM") {
							esDicom = true;
						}
					}
				}
			}
			return esDicom;
		}

//endregion

		DcmElement* DICOMManager::CrearElementoConValor(const char* s)
		{
			unsigned int g = 0xffff;
			unsigned int e = 0xffff;
			int n = 0;
			char* val = new char[strlen(s)+1];
			OFString dicName, valStr;
			OFString msg;

			val[0] = '\0';

			// try to parse group and element number
			n = sscanf(s, "%x|%x=%s", &g, &e, val);
			OFString toParse = s;
			unsigned long eqPos = toParse.find('=');
			if (n < 2) // if at least no tag could be parsed
			{
				// if value is given, extract it (and extrect dictname)
				if (eqPos != OFString_npos) {
					dicName = toParse.substr(0, eqPos).c_str();
					valStr = toParse.substr(eqPos + 1, toParse.length());
				} else // no value given, just dictionary name
					dicName = s; // only dictionary name given (without value)
				// try to lookup in dictionary
				DcmTagKey key(0xffff, 0xffff);
				const DcmDataDictionary& globalDataDict = dcmDataDict.rdlock();
				const DcmDictEntry *dicent = globalDataDict.findEntry(dicName.c_str());
				dcmDataDict.unlock();
				if (dicent != NULL) {
					// found dictionary name, copy group and element number
					key = dicent->getKey();
					g = key.getGroup();
					e = key.getElement();
				} else {
					// not found in dictionary
					std::cerr <<  "bad key format or dictionary name not found in dictionary: " << dicName << std::endl;
					delete[] val;
					return NULL;
				}
			}// tag could be parsed, copy value if it exists
			else {
				if (eqPos != OFString_npos) {
					valStr = toParse.substr(eqPos + 1, toParse.length());
				}
			}
			DcmTag tag(g, e);
			if (tag.error() != EC_Normal) {
				std::cerr << "Tag desconocido: (" <<
				std::hex << std::setw(4) << std::setfill('0') << g << "|" <<
				std::hex << std::setw(4) << std::setfill('0') << e << ")" << std::endl;
				delete[] val;
				return NULL;
			}
			DcmElement *elem = newDicomElement(tag);
			if (elem == NULL) {
				std::cerr << "No se pudo crear el elemento para el tag: (" <<
				std::hex << std::setw(4) << std::setfill('0') << g << "|" <<
				std::hex << std::setw(4) << std::setfill('0') << e << ")" << std::endl;
				delete[] val;
				return NULL;
			}
			if (valStr.length() > 0) {
				if (elem->putString(valStr.c_str()).bad()) {
					std::cerr << "No se pudo asignar el valor al elemento: (" <<
					std::hex << std::setw(4) << std::setfill('0') << g << "|" <<
					std::hex << std::setw(4) << std::setfill('0') << e << ")=" << valStr.c_str() << std::endl;
					delete elem;
					delete[] val;
					return NULL;
				}
			}
			delete[] val;
			return elem;

		}

		int DICOMManager::InsertarJerarquia(TipoJerarquia& base, DcmItem* itemPadre, DcmSequenceOfItems* seqPadre)
		{

			int numTotalInsertados = 0;
			int numTagsInsertados  = 0;
			int numItemsInsertados = 0;
			int numSeqsInsertadas  = 0;

			if (m_pDCMDataSet == NULL) {
				// TODO: Lanzar excepcion
				return 0;
			}

			// Insertamos todos los tags correspondientes a este nivel en la raiz (de haberla, si no: en el dataset).
			for (ListaTags::iterator it = base.tags.begin(); it != base.tags.end(); it++) {
				DcmElement* e = this->CrearElementoConValor((*it).first.c_str());

				if (e != NULL) {
					e->putString( wxString( (*it).second.c_str(), wxConvUTF8).mb_str(*m_pConv) );
					OFCondition cond;
					if (itemPadre == NULL) {
						cond = m_pDCMDataSet->insert(e, true, false);
						char* str = NULL;
						e->getString(str);
						if(str!=NULL){
							GTRACE("raiz << " << e->getTag().toString() <<  "=" << str)
						}
						else{
							GTRACE("raiz << " << e->getTag().toString() <<  "=")
						}
					}
					else {
						cond = itemPadre->insert(e, true, false);
						char* str = NULL;
						e->getString(str);
						if(str!=NULL){
							GTRACE(itemPadre->getTag().toString().c_str() << " << " << e->getTag().toString() << " = " << str)
						}
						else{
							GTRACE(itemPadre->getTag().toString().c_str() << " << " << e->getTag().toString() << " = ")
						}


					}
					if (cond.bad()) {
						std::cerr << "No se pudo insertar el elemento: (" << e->getTag().toString().c_str() << "): " << cond.text() << std::endl;
					}
					else {
						numTotalInsertados++;
						numTagsInsertados++;
					}
				}
			}

			// Insertamos todos los items correspondientes a este nivel en la raiz (de haberla, si no: en el dataset).

			for (TipoJerarquia::ListaJerarquias::iterator it = base.items.begin(); it != base.items.end(); it++) {
				DcmItem *item = new DcmItem();

				int nItems = InsertarJerarquia((*it), item, NULL);

				if (nItems > 0) {

					OFCondition cond;

					if (seqPadre == NULL) {
						//cond = i2d->getOverrideKeys()->insert(item, OFTrue);
						std::cerr << "No se pudo insertar el item directamente a la raiz. Deben insertarse en secuencias o en otros items.  " << nItems << " elementos perdidos: " << cond.text() << std::endl;
						std::cerr << "tag << " << (*it) <<std::endl;
						delete item;
					}
					else {
						cond = seqPadre->insert(item, true, false);
						GTRACE(seqPadre->getTag().toString().c_str() << " << " << item->getTag().toString())
					}

					if (cond.bad()) {
						std::cerr << "No se pudo insertar el item a la raiz.  " << nItems << " elementos perdidos: " << cond.text() << std::endl;
						delete item;
					}
					else {
						numTotalInsertados += nItems + 1;
						numItemsInsertados++;
					}
				}
				else {
					delete item;
				}
			}

			// Insertamos todas las secuencias correspondientes a este nivel en la raiz (de haberla, si no: en el dataset).
			for (TipoJerarquia::ListaJerarquias::iterator it = base.secuencias.begin(); it != base.secuencias.end(); it++) {

				std::string claveSecuencia = (*it).tagName;
				TipoJerarquia& nbase = (*it);

				unsigned int sg = 0xffff;
				unsigned int se = 0xffff;
				int sn = 0;

				sn = sscanf(claveSecuencia.c_str(), "%x|%x", &sg, &se);
				if (sn < 2) {
					std::cerr << "Formato invalido (" << claveSecuencia.c_str() << "). Solo se soporta (FFFF|FFFF) como formato de tag para secuencias" << std::endl;
					continue;
				}
				DcmTag stag(sg, se);
				if (stag.error() != EC_Normal) {
					std::cerr << "Tag desconocido: " << claveSecuencia << std::endl;
					continue;
				}
				DcmSequenceOfItems* seq = new DcmSequenceOfItems(stag);
				if (seq == NULL) {
					std::cerr << "No se pudo crear la secuencia para el tag: " << claveSecuencia << std::endl;
					continue;
				}

				int nItems = InsertarJerarquia(nbase, NULL, seq);

				if (nItems > 0) {

					OFCondition cond;

					if (seqPadre != NULL) {
						DcmItem* item = new DcmItem();
						cond = item->insert(seq);
						seqPadre->insert(item);
						GTRACE(seqPadre->getTag().toString().c_str() << " << " << seq->getTag().toString());
					}
					else if (itemPadre != NULL) {
						cond = itemPadre->insert(seq, OFTrue);
						GTRACE(itemPadre->getTag().toString().c_str() << " << " << seq->getTag().toString());

					}
					else {
						cond = m_pDCMDataSet->insert(seq, OFTrue);
						GTRACE("raiz << " << seq->getTag().toString());
					}

					if (cond.bad()) {
						std::cerr << "No se pudo insertar el item a la raiz.  " << nItems << " elementos perdidos: " << cond.text() << std::endl;
						delete seq;
					}
					else {
						numTotalInsertados += nItems + 1;
						numSeqsInsertadas++;
					}
				}
				else {
					delete seq;
				}
			}
			return numTotalInsertados;
		}

		//----------------------CARGAR JERARQUIA-------------------------------------------------------
		int DICOMManager::CargarJerarquia(TipoJerarquia& base, unsigned int maximaLongitud, DcmElement * pElementoInicial) {
			int numInsertados = 0;

			std::queue<DcmElement*>                pilaElementos;
			std::queue<GIL::DICOM::TipoJerarquia*> pilaPadres;

			OFCondition cond;

			FindCharset();

			unsigned long elemCount = m_pDCMDataSet->card();

			//si es nulo, queremos cargar toda la jerarquia
			if(pElementoInicial == NULL) {
				for (unsigned long i = 0; i < elemCount; i++) {
					DcmElement *e = m_pDCMDataSet->getElement(i);
					if (e->getGTag() == 0x7fe0 && e->getETag() == 0x0010) {
						// Excluir pixel data
					}
					else {
						pilaElementos.push(e);
						pilaPadres.push(&base);
					}
				}
			} else {
				pilaElementos.push(pElementoInicial);
				pilaPadres.push(&base);
			}

			while(!pilaElementos.empty()) {
				DcmElement* e = pilaElementos.front(); pilaElementos.pop();
				GIL::DICOM::TipoJerarquia* cbase = pilaPadres.front(); pilaPadres.pop();

				if (e->ident() == EVR_item) {
					//GTRACE("Procesando item: " << e->getTag().toString())
					GIL::DICOM::TipoJerarquia newbase;

					cbase->items.push_front(newbase);

					numInsertados++;

					DcmObject* e2 = NULL;
					while ( (e2 = e->nextInContainer(e2)) != NULL) {
						pilaElementos.push((DcmElement*)e2);
						pilaPadres.push(& (cbase->items.front()));
					}

				}
				else if (e->ident() == EVR_SQ) {
					//GTRACE("Procesando secuencia: " << e->getTag().toString())
					std::ostringstream os;
					os << std::hex << std::setw(4) << std::setfill('0') << e->getGTag() << "|" << std::hex << std::setw(4) << std::setfill('0') << e->getETag();
					std::string tag = os.str();

					GIL::DICOM::TipoJerarquia newbase;
					newbase.tagName = tag;

					cbase->secuencias.push_front(newbase);

					numInsertados++;

					DcmObject* e2 = NULL;
					while ( (e2 = e->nextInContainer(e2)) != NULL) {
						pilaElementos.push((DcmElement*)e2);
						pilaPadres.push(& (cbase->secuencias.front()));
					}
				}
				else {
					GTRACE("Procesando objeto: " << e->getTag().toString())
					std::ostringstream os;
					os << std::hex << std::setw(4) << std::setfill('0') << e->getGTag() << "|" << std::hex << std::setw(4) << std::setfill('0') << e->getETag();
					std::string tag = os.str();

					//solo carga los tags no privados
					if(e->getGTag() != GINKGO_GROUP && ( maximaLongitud == 0 || e->getLength() < maximaLongitud ) ){
						if (e->getGTag() == GINKGO_GROUP) {
							std::cout << "long=" << e->getLength() << std::endl;
						}
						OFString v;
						std::string ov;

						cond = e->getOFStringArray(v, OFTrue);
						if (cond.good()) {
							ov = wxString(v.c_str(), *m_pConv).ToUTF8();
						} 
						if (ov.size() == 0 && v.size() != ov.size()) {
							ov = wxString::FromAscii(v.c_str()).ToUTF8();
						}

						cbase->tags[tag] = ov;

						numInsertados++;
					} else {
						
					}
				}
			}
			return numInsertados;
		}

		//----------------------INSERTAR TAGS PRIVADOS-------------------------------------------------------
		int DICOMManager::InsertarTagsPrivados(TipoPrivateTags& tags){
			//se busca el uid en el rango (GINKGO_GROUP,0010-00FF)
			unsigned int g=GINKGO_GROUP;
			unsigned int e=0;
			OFCondition cond;
			DcmElement* element;

			e=GetElementIdentifier(tags);

			if(e>0x00FF || e==0){
				//no deberia llegar aqui
				std::cerr<<"error al almacenar los tags privados, todos los slots ocupados" <<std::endl;
				return 0;
			}

			//ya tenemos el e del modulo hay que hacer un desplazamiento de 8 bits a la izquierda para obtener el rango
			//si el elemento es 00xx el rango sera xx00-xxFF
			e = e << 8;

			unsigned int eTemp;
			TipoPrivateTags::ListaTags& ListaTags = tags.GetListaTags();
			for (TipoPrivateTags::ListaTags::iterator it = ListaTags.begin(); it != ListaTags.end(); ++it)
			{
				eTemp = e | (*it).first;
				element = (*it).second->ToElement(g,eTemp);
				if (element != NULL)
				{
					cond = m_pDCMDataSet->insert(element, true, false);
					if (cond.bad()) {
						std::cerr << "error al almacenar los tags privados, error al escribir en el dataset: (" << g << ","<<eTemp<<")" <<std::endl;
						return 0;
					}
				} else {
					std::cerr << "error al almacenar los tags privados, error al crear el elemento: (" << g << ","<<eTemp<<")" <<std::endl;
					return 0;
				}
			}

			return 1;
		}

		//----------------------CARGAR TAGS PRIVADOS-------------------------------------------------------
		int DICOMManager::PrivateCargarTagsPrivados(GIL::DICOM::TipoPrivateTags& tags){
			//se busca el uid en el rango (GINKGO_GROUP,0010-00FF)
			unsigned int g=GINKGO_GROUP;
			unsigned int e=0;
			OFCondition cond;
			DcmElement* element;

			e=GetElementIdentifier(tags);

			if(e>0x00FF || e==0){
				//no deberia llegar aqui
				std::cerr<<"error al almacenar los tags privados, todos los slots ocupados" <<std::endl;
				return 0;
			}

			//ya tenemos el e del modulo hay que hacer un desplazamiento de 8 bits a la izquierda para obtener el rango
			//si el elemento es 00xx el rango sera xx00-xxFF
			e = e << 8;

			unsigned int numElementos=0;
			DcmVR vr(EVR_UN);
			DcmTagKey key(g,e);
			unsigned int eTemp;

			//se pillan todos los atributos del slot
			for(unsigned char eTag=0x0;eTag<0xFF;++eTag){
				eTemp = e | eTag;

				key.setElement(eTemp);
				DcmTag tag(key,vr);

				if (tag.error() != EC_Normal) {
					std::cerr << "error al almacenar los tags privados, tag desconocido: (" << g << ","<<eTemp<<")" <<std::endl;
					return 0;
				}

				cond = m_pDCMDataSet->findAndGetElement(key,element,false);

				if (element!=NULL && cond.good()){
					if (element->getVR() == EVR_LT) {
						char* copiaString;
						if (!element->isEmpty() && element->getString(copiaString).good()) {
							tags.SetTag(eTag, copiaString);
						}
						numElementos++;
					} else if (element->getVR() == EVR_UN) {
						//se lee el elemento
						int size = element->getLength();
						if (size>0) {
							TagPrivadoUndefined* pTag = tags.NewTagUndefined(eTag, size);

							Uint8 * ptr;
							cond = element->getUint8Array(ptr);

							memcpy(pTag->GetValor(),ptr,size*sizeof(Uint8));

							if (cond.bad()) {
								std::cerr << "error al cargar los tags privados, error al cargar el tag: (" << g << ","<<eTemp<<")" <<std::endl;
								return 0;
							}
							numElementos++;
						}
					}
				}
			}

			return numElementos;
		}

		//devuelve el element identifier donde el modulo puede escribir sus tags privados
		unsigned int DICOMManager::GetElementIdentifier(GIL::DICOM::TipoPrivateTags& tags){
			OFCondition cond;
			DcmElement* element;
			unsigned int g=GINKGO_GROUP;
			unsigned int e=0x0010;

			for(;e<=0x00FF;e++){
				DcmTagKey key(g,e);
				cond = m_pDCMDataSet->findAndGetElement(key,element,false);
				if(element==NULL){
					//esta libre el slot
					//se introduce el uid
					DcmTagKey key(g,e);
					DcmTag tag(key);
					//tipo short string!!!!
					DcmVR vr(EVR_SH);
					tag.setVR(vr);
					if (tag.error() != EC_Normal) {
						std::cerr << "error al almacenar los tags privados, tag desconocido: (" << g << ","<<e<<")" <<std::endl;
						return 0;
					}

					element = newDicomElement(tag);

					if(element==NULL){
						std::cerr << "error al almacenar los tags privados, error al crear el elemento uid: (" << g << ","<<e<<")" <<std::endl;
						return 0;
					}

					cond=element->putString(tags.UIDModulo.c_str());

					if (cond.bad()) {
						std::cerr << "error al almacenar los tags privados, error al escribir el uid: (" << g << ","<<e<<")" <<std::endl;
						return 0;
					}

					cond = m_pDCMDataSet->insert(element, true, false);
					break;
				}

				if(element!=NULL){
					char* cadena;
					std::string ov;

					cond = element->getString(cadena);
					if (cond.good() && cadena!=NULL) {
						ov = std::string(cadena);
					} else {
						continue;
					}

					if(ov==tags.UIDModulo){
						//estamos en el g y e del modulo deseado
						break;
					}
				}
			}

			return e;
		}

		//endregion

		void DICOMManager::FindCharset()
		{
			if (m_pConv != NULL) {
				delete m_pConv;
				m_pConv = NULL;
			}

			OFString OFCharSet;

			std::string Charset;

			if (m_pDCMDataSet->findAndGetOFString(DCM_SpecificCharacterSet, OFCharSet).good()) {
				Charset.assign(OFCharSet.c_str());
			}
			else {
				m_pDCMDataSet->putAndInsertOFStringArray(DCM_SpecificCharacterSet, "ISO_IR 192");
			}

			if (Charset == "ISO_IR 192" || Charset == "ISO_IR 6" || Charset == "ISO_IR 138") {
				m_pConv = new wxCSConv(wxFONTENCODING_UTF8);
			}
			else if (Charset == "ISO_IR 100") {
				m_pConv = new wxCSConv(wxFONTENCODING_ISO8859_1);
			}
			else if (Charset == "ISO_IR 101") {
				m_pConv = new wxCSConv(wxFONTENCODING_ISO8859_2);
			}
			else if (Charset == "ISO_IR 109") {
				m_pConv = new wxCSConv(wxFONTENCODING_ISO8859_3);
			}
			else if (Charset == "ISO_IR 110") {
				m_pConv = new wxCSConv(wxFONTENCODING_ISO8859_4);
			}
			else if (Charset == "ISO_IR 148") {
				m_pConv = new wxCSConv(wxFONTENCODING_ISO8859_9);
			}
			else if (Charset == "ISO_IR 144") {
				m_pConv = new wxCSConv(wxFONTENCODING_ISO8859_5);
			}
			else if (Charset == "ISO_IR 127") {
				m_pConv = new wxCSConv(wxFONTENCODING_ISO8859_6);
			}
			else if (Charset == "ISO_IR 126") {
				m_pConv = new wxCSConv(wxFONTENCODING_ISO8859_7);
			}
			else if (Charset == "ISO_IR 138") {
				m_pConv = new wxCSConv(wxFONTENCODING_ISO8859_8);
			}
			else {
				m_pConv = new wxCSConv(wxFONTENCODING_UTF8);
			}

		}

	}
}
