/*
 *  
 *  $Id: controladorhl7.h 3832 2011-05-09 12:23:07Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/ientorno.h>
#include <api/icontroladorhl7.h>
#include <api/imodelohl7.h>

namespace GIL {
	namespace HL7 {
		void TestHL7(void);

		class HiloEnviaMensajesHl7;

		class ControladorHL7 : public GIL::HL7::IControladorHL7 {
		public:

			ControladorHL7(TipoInterpretacion interpretacion = TI_SACYL, TipoProtocolo protocolo = TP_MLLP);
			~ControladorHL7();

			//region "Interfaz generica"

			/* Interpreta (segun modelo de guias clinicas especificado) e inserta el modelo de integracion en el mensaje HL7. */
			virtual void ConstruirMensajeDeEvidencias(GIL::HL7::Message& msg, const GIL::IModeloIntegracion* const modelo) const;

			/* Envia el mensaje por el protocolo especificado */
			virtual void EnviarMensaje(const GIL::HL7::Message& msg, bool procesarACK=true) const;

			/* Parsea la cadena XML y construye los modelos de integracion encontrados. Los parametros no encontrados se asignan por defecto segun lo especificado en la configuracion global */
			virtual void ParsearModeloIntegracion(GNC::GCS::IEntorno::ListaModelosIntegracion& modelos, const std::string& xmlString) const;

			/* devuelve el uid de modulo a partir del pid indicado*/
			virtual std::string GetUID(const std::string& idPlantilla) const;

			virtual std::string GetNombreModulo(const std::string& idPlantilla) const;

			virtual std::string GetUIDModulo(const std::string& idPlantilla) const;

			//endregion

			//region "Helpers"

			//endregion

			void InsertarMensajeBBDD(const GIL::HL7::Message& msg, const std::string& url,const bool procesarACK,const int protocolo,const std::string& msgControlId) const;

		protected:
		};
	}
}
