/*
 *  
 *  $Id: pathwildcards.cpp 3521 2011-03-16 14:54:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#include "pathwildcards.h"
#include <api/imodelointegracion.h>
#include <string.h>
#include <sstream>
#include <iostream>

typedef enum Ambito {
	Paciente,
	Medico,
	Ninguno
} Ambito;


void GetId(GnkPtr<GIL::IModeloIntegracion>& pModeloIntegracion, Ambito ambito, const std::string& id, std::string& valor);
void GetId(const GIL::TListaIdentificadores& lista, const std::string& id, std::string& valor);

std::string GNC::GCS::PathWildcards::Parse(const std::string& path, GnkPtr<GIL::IModeloIntegracion>& pModeloIntegracion)
{
	std::string realPath = path;

	std::string valor;

	bool changed = true;
	
	std::string::size_type it0 = std::string::npos;
	std::string::size_type it1 = std::string::npos;

	while (changed) {
		it0 = it1 = std::string::npos;
		valor = "";

		if ( ( it0 = realPath.find("#PID.NNESP") ) != std::string::npos) {
			it1 = 10;
			GetId(pModeloIntegracion, Paciente, "NNESP", valor);
		}
		else if ( ( it0 = realPath.find("#PID.HC") ) != std::string::npos) {
			it1 = 7;
			GetId(pModeloIntegracion, Paciente, "HC", valor);
		}
		else if ( ( it0 = realPath.find("#PID.SS") ) != std::string::npos) {
			it1 = 7;
			GetId(pModeloIntegracion, Paciente, "SS", valor);
		}
		else if ( ( it0 = realPath.find("#PID.PI") ) != std::string::npos) {
			it1 = 7;
			GetId(pModeloIntegracion, Paciente, "PI", valor);
		}
		else if ( ( it0 = realPath.find("#MID.NNESP") ) != std::string::npos) {
			it1 = 10;
			GetId(pModeloIntegracion, Medico, "NNESP", valor);
		}
		else if ( ( it0 = realPath.find("#MID.MD") ) != std::string::npos) {
			it1 = 7;
			GetId(pModeloIntegracion, Medico, "MD", valor);
		}
		
		if (it0 != std::string::npos) {
			realPath = realPath.replace(it0, it1, valor );
		}
		else {
			changed = false;
		}
	}

	return realPath;
}


void GetId(GnkPtr<GIL::IModeloIntegracion>& pModeloIntegracion, Ambito ambito, const std::string& id, std::string& valor)
{
	if (pModeloIntegracion) {
		switch (ambito) {
			case Paciente:
				GetId(pModeloIntegracion->Paciente.listaIdentificadores, id, valor);
				break;
			case Medico:
				GetId(pModeloIntegracion->Medico.listaIdentificadores, id, valor);
				break;
			case Ninguno:
			default:
				break;
		}

	}
}

void GetId(const GIL::TListaIdentificadores& lista, const std::string& id, std::string& valor)
{
	bool notfound = true;
	for (GIL::TListaIdentificadores::const_iterator it = lista.begin(); notfound && it != lista.end(); it++) {
		const GIL::IModeloIdentificador& i = (*it);
		if (i.tipoId == id) {
			valor = i.valor;
			notfound = false;
		}
	}
}
