/*
 *  
 *  $Id: visualizatorstudy.h 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/icontextoestudio.h>
#include "overlay.h"

class wxWindow;
class wxSizer;
class wxXmlNode;
class wxXmlDocument;

namespace GNKVisualizator {
	class VisualizatorStudy : public GNC::GCS::IContextoEstudio
	{
	public:
		
		VisualizatorStudy();
		~VisualizatorStudy();

		virtual void InicializarContextoEstudio(std::vector<std::string>& rutas, const std::string uidEstudioDiagnostico, GNC::GCS::IContextoEstudio::TModoFuncionamiento modoFuncionamiento);

		//overlays...
		bool TieneOverlaysImagenActiva();
		bool TieneOverlaysImagen(const int indiceImagen);
		GnkPtr<GNKVisualizator::TListaOverlays> GetOverlaysImagenActiva();
		GnkPtr<GNKVisualizator::TListaOverlays> GetOverlaysImagen(const int indice);

		virtual bool CallbackPreCrearDiagnostico(const int indice, GIL::DICOM::TipoJerarquia* pJerarquiaSR, std::list<GnkPtr<GIL::DICOM::TipoPrivateTags> >& listaTagsPrivados);
		virtual bool CallbackPreGuardarDiagnostico(const int /*indice*/, GIL::DICOM::IDICOMManager* /*pDicomManager*/) {return true;}
		virtual void CallbackCargarTagsImagen(const int /*indice*/, GIL::DICOM::IDICOMManager* /*pDicomManager*/) {}


	protected:

		std::vector<GnkPtr<TListaOverlays> >                ListaOverlays;
	};
}
