/*
 *  $Id: gnkvideo.cpp 3681 2011-04-12 10:53:31Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
#include "fooextension.h"
#include "fooextension/controllers/fooextensioncontroller.h"
#include <api/ientorno.h>

#include <iostream>
#include <sstream>
#include <wx/config.h>
#include <wx/msgdlg.h>
#include "fooextension/license.h"


//it's required to call this macro
IMPLEMENT_PrivateExtension(GnkFooExtension)

//parameters are related with provider, version... sid is the extension id, it's used to know if a file has been imported by this extension
//this information will be used in viewer open preference
GnkFooExtension::GnkFooExtension(): PrivateExtension(EXT_SID, EXT_PROVIDER, EXT_DESCRIPTION, EXT_VERSION, EXT_SUBVERSION, EXT_RELEASE, EXT_BUILD, EXT_CODENAME, EXT_UPDATEURL)
{
}

GnkFooExtension::~GnkFooExtension()
{
}

//returns extension controller module
PrivateExtension::TListControllers GnkFooExtension::InitializeLibrary(GNC::GCS::IEntorno* pEntorno)
{
	TListControllers list;
	list.push_back(new FooExtension::FooExtensionController(pEntorno));
	return list;
}

//here you can implement your own security policy
bool GnkFooExtension::IsActivated()
{
	return true;
}

//this extension is free to use
void GnkFooExtension::ShowActivationDialog(wxWindow* pParent)
{	
	wxMessageBox(_("FooExtension is Open Source"), _("Info"));
}
