/*
 *  
 *  $Id: herramientacalibrado.cpp 4478 2011-12-13 11:55:00Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <api/ientorno.h>

#include <api/globals.h>
#include <main/gui/callibration/wxwizardcalibradoginkgo.h>
#include "herramientacalibrado.h"
#include "../entorno.h"
#include <api/icontroladoreventos.h>
#include <eventos/eventosginkgo.h>
#include <api/icontextoestudio.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <vtkImageActor.h>



//----------------------------------------------------------------------

GNC::HerramientaCalibrado::HerramientaCalibrado()
{
	m_Descripcion = std::string("Calibracion automatica de la imagen");
	m_IsMenu = true;
}

GNC::HerramientaCalibrado::~HerramientaCalibrado()
{
}

//region "Realizacion de la interfaz IHerramienta"

void GNC::HerramientaCalibrado::CrearPaneles( wxPanel* /*padre*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}

void GNC::HerramientaCalibrado::SolicitarActivacion(const GNC::GCS::TriggerButton&)
{
	GTRACE("GNC::HerramientaCalibracion::SolicitarActivacion()");
	if(TContratableWidgets::m_pListaActiva->size()>1){
		std::cerr<<"GNC::HerramientaPegado Error, hay dos contratos activos"<<std::endl;
		return;
	}
	TContratoWidgets* pC;

	for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
		pC = (*it1);
	}
	GNC::GCS::IVista* pVistaActiva = TContratableWidgets::m_pVistaActiva;


	vtkImageData* pImagenOriginal = NULL;
	int slice = 0;
	//TODOX
	//pVistaActiva->AsignarConexionesDeFiltrado(&pImagenOriginal,&slice);

	GNC::GUI::wxWidzardCalibradoGinkgo dlg(GNC::Entorno::Instance()->GetVentanaRaiz(), pVistaActiva, pImagenOriginal, slice);
	dlg.ShowModal();
	if(dlg.IsOK()){
		//mandar evento de calibrado
		GNC::GCS::Eventos::EventoModificacionImagen* pEvt = new GNC::GCS::Eventos::EventoModificacionImagen(pVistaActiva,GNC::GCS::Eventos::EventoModificacionImagen::ImagenRecalibrada, -1);

		double oldSpacing[3];                    // Espaciado antiguo
		double newSpacing[3];                    // Nuevo espaciado

		pImagenOriginal->GetSpacing(oldSpacing);
		pImagenOriginal->GetSpacing(newSpacing);
		newSpacing[0] = dlg.GetHorizontalSpacing();
		newSpacing[1] = dlg.GetVerticalSpacing();


		pEvt->SetOldSpacing(oldSpacing);
		pEvt->SetNewSpacing(newSpacing);
		pEvt->SetOldOrigin(pImagenOriginal->GetOrigin());
		pEvt->SetNewOrigin(pImagenOriginal->GetOrigin());

		GNC::Entorno::Instance()->GetControladorEventos()->ProcesarEvento(pEvt);
	}
	
}

void GNC::HerramientaCalibrado::ConectarContratoFalso(bool ) {
	if (TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}
	
}

void GNC::HerramientaCalibrado::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaPegado::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::HerramientaCalibrado::ConectarContratos(bool )
{
	if (TContratableWidgets::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}
	
}

//endregion



