/*
*  
*  $Id: itoolzoom.h 4480 2011-12-13 13:10:41Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/iherramienta.h>
#include "icontratoscore.h"
#include "iherramientascore.h"


namespace GNC {
	namespace GCS {

		class EXTAPI IToolZoom: public IHerramienta, public IContratable<IContratoWidgets> {
		public:
			typedef IContratoWidgets               TContratoWidgets;
			typedef IContratable<TContratoWidgets> TContractableWidgets;

			static const IHerramienta::UID ID = HCore_Zoom;
			IToolZoom() : IHerramienta(HCore_Zoom,TFamiliaVisualizacion, "CoreZoom") {};
			virtual ~IToolZoom() {};

			virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

			virtual void ConectarContratos(bool) = 0;

			virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
				return TContractableWidgets::ValidaContrato(pVista);
			}
			
		};
	}
}
