/*
*  
*  $Id: itoolpan.h 4486 2011-12-14 08:32:24Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/iherramienta.h>
#include "icontratoscore.h"
#include "iherramientascore.h"


namespace GNC {
	namespace GCS {

		class EXTAPI IToolPan: public IHerramienta, public IContratable<IContratoWidgets> {
		public:
			typedef IContratoWidgets               TContractWidgets;
			typedef IContratable<IContratoWidgets> TContractableWidgets;

			static const IHerramienta::UID ID = HCore_Pan;
			IToolPan() : IHerramienta(HCore_Pan, TFamiliaVisualizacion, "CorePan") {};
			virtual ~IToolPan() {};

			virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

			virtual void ConectarContratos(bool) = 0;

			virtual bool ValidaContratos(GNC::GCS::IVista* pVista) {
				return TContractableWidgets::ValidaContrato(pVista);
			}
			
		};
	}
}
