/*
*  
*  $Id: comandoincluirhistorial.cpp 4682 2012-02-09 14:25:47Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
//#define _GINKGO_TRACE
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/msgdlg.h>

#include <api/globals.h>
#include <api/ivista.h>
#include <api/icontroladorvistas.h>
#include <api/imodelointegracion.h>
#include <api/icontroladorcarga.h>
#include <api/icontextoestudio.h>
#include <main/entorno.h>
#include "comandoincluirhistorial.h"
#include <main/controllers/controladorcomandos.h>
#include <main/controllers/controladorhistorial.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/pacscontroller.h>
#include <main/gui/history/ipanelhistorial.h>

#include "dialogopathssobreescribirbase.h"

#define IDC_INCLUIR       101
#define IDC_AVISAR		  102

class SubComandoAvisarModelosParams : public GNC::GCS::IComandoParams
{
public:
	typedef std::list<std::string> TipoListaFicheros;

	SubComandoAvisarModelosParams(const GNC::GCS::ControladorHistorial::ListaModelosDCM& listaModelos, bool abrirDespues, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion)
	{
		m_modelosDCM = listaModelos;
		m_abrirDespuesDeCargar= abrirDespues;
		m_pModeloIntegracion = pModeloIntegracion;
	}

	~SubComandoAvisarModelosParams()
	{
		m_modelosDCM.clear();
	}

	GNC::GCS::ControladorHistorial::ListaModelosDCM m_modelosDCM;
	GnkPtr<GIL::IModeloIntegracion> m_pModeloIntegracion;
	bool m_abrirDespuesDeCargar;
};

class SubComandoAvisarModelos : public GNC::GCS::IComando {
public:
	SubComandoAvisarModelos(SubComandoAvisarModelosParams* pParams) : IComando(pParams)
	{
		SetId(IDC_AVISAR);
		m_pAvisarParams = pParams;
	}

	virtual void Execute()
	{
	}

	virtual void Update()
	{
		if (m_pAvisarParams->m_modelosDCM.size() > 0) {
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoAddModeloHistorial(&m_pAvisarParams->m_modelosDCM,m_pAvisarParams->m_abrirDespuesDeCargar, m_pAvisarParams->m_pModeloIntegracion));
		}
	}

	virtual void LiberarRecursos()
	{
	}

protected:
	SubComandoAvisarModelosParams* m_pAvisarParams;
};

namespace GADAPI {

	//lee un directorio en profundidad y lo incluye en el dicomdir
	namespace ComandoIncluirHistorial {
		ComandoIncluirHistorialParams::ComandoIncluirHistorialParams(const std::string& path, bool recursivo, bool forzarSobreescribir)
		{
			m_path = path;
			m_recursivo = recursivo;
			m_abrirDespuesDeCargar = false;
			m_forzarSobreescribir = forzarSobreescribir;
			m_addAction = GNC::GCS::ControladorHistorial::TAA_COPY;
			m_informar = true;
		}

		ComandoIncluirHistorialParams::ComandoIncluirHistorialParams(const std::list<std::string>& listaPaths, bool abrirDespuesDeCargar, bool forzarSobreescribir, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion)
		{
			if (listaPaths.size() == 1) {
				m_path = listaPaths.front();
			} else {
				m_listaPaths = listaPaths;
			}
			m_abrirDespuesDeCargar = abrirDespuesDeCargar;
			m_pModeloIntegracion = pModeloIntegracion;
			m_forzarSobreescribir = forzarSobreescribir;
			m_addAction = GNC::GCS::ControladorHistorial::TAA_COPY;
			m_informar = true;
			m_recursivo = true;
		}

		ComandoIncluirHistorialParams::~ComandoIncluirHistorialParams()
		{
		}


		ComandoIncluirHistorial::ComandoIncluirHistorial(ComandoIncluirHistorialParams* pParams) : IComando(pParams)
		{
			GTRACE(">> ComandoCarga::ComandoCarga(): " << this);
			m_pIncluirParams = pParams;
			SetId(IDC_INCLUIR);
			GTRACE("<< ComandoCarga::ComandoCarga(): " << this);
		}

		void ComandoIncluirHistorial::Execute()
		{
			NotificarProgreso(0.0f,_Std("Exploring directory ..."));
			if(m_pIncluirParams->m_path != "") {
				GNC::GCS::ControladorHistorial::ListaPaths listaFicheros;
				wxString wxPath = FROMPATH(m_pIncluirParams->m_path);
				if(wxFileExists(wxPath)) {
					wxFileName filename(wxPath);
					if(filename.GetExt().Lower() == wxT("dcm") || GIL::DICOM::PACSController::Instance()->EsDICOM(std::string(wxPath.ToUTF8()), false, true) ) {
						listaFicheros.push_back(m_pIncluirParams->m_path);
					}

					GNC::GCS::ControladorHistorial::Instance()->AddFiles(listaFicheros,m_pIncluirParams->m_modelosDCM,m_pIncluirParams->m_listaPathsSobreescriben, m_pIncluirParams->m_ErrorList,m_pIncluirParams->m_forzarSobreescribir,this,m_pIncluirParams->m_addAction);
					for(GNC::GCS::ControladorHistorial::ListaModelosDCM::iterator it = m_pIncluirParams->m_modelosDCM.begin(); it != m_pIncluirParams->m_modelosDCM.end(); ++it)
					{
						m_pIncluirParams->m_listaEstudios.insert((*it).m_uidEstudio);
						m_pIncluirParams->m_listaSeries.insert((*it).m_uidSerie);
						m_pIncluirParams->m_listaImagenes.insert((*it).m_uidImagen);
					}
				} else if (wxDirExists(wxPath) && m_pIncluirParams->m_recursivo) {
					//caso especial en el que se va avisando poco a poco...
					TListaListas listaListas;
					LeerDirectorioRecursivo(wxPath,listaListas);
					for (TListaListas::iterator it = listaListas.begin(); it != listaListas.end(); it++) {
						//se incluyen "por paquetes los ficheros"
						GNC::GCS::ControladorHistorial::Instance()->AddFiles((*it),m_pIncluirParams->m_modelosDCM,m_pIncluirParams->m_listaPathsSobreescriben, m_pIncluirParams->m_ErrorList,m_pIncluirParams->m_forzarSobreescribir,this,m_pIncluirParams->m_addAction);
						SubComandoAvisarModelosParams * pParams = new SubComandoAvisarModelosParams(m_pIncluirParams->m_modelosDCM,m_pIncluirParams->m_abrirDespuesDeCargar,m_pIncluirParams->m_pModeloIntegracion);
						SubComandoAvisarModelos * pCmd = new SubComandoAvisarModelos(pParams);
						GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Including files in the history .."),pCmd,NULL);
						for(GNC::GCS::ControladorHistorial::ListaModelosDCM::iterator it = m_pIncluirParams->m_modelosDCM.begin(); it != m_pIncluirParams->m_modelosDCM.end(); ++it)
						{
							m_pIncluirParams->m_listaEstudios.insert((*it).m_uidEstudio);
							m_pIncluirParams->m_listaSeries.insert((*it).m_uidSerie);
							m_pIncluirParams->m_listaImagenes.insert((*it).m_uidImagen);
						}
						m_pIncluirParams->m_modelosDCM.clear();
					}
				} else if(wxDirExists(wxPath)){
					//leer el directorio normal
					wxDir dir;
					if (dir.Open(wxPath)) {
						wxString wxPathFich;
						bool cont = dir.GetFirst(&wxPathFich,wxEmptyString, wxDIR_FILES | wxDIR_DIRS);
						while (cont) {
							wxPathFich = dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) + wxPathFich;
							wxFileName filename(wxPathFich);
							if(filename.GetExt().Lower() == wxT("dcm") || GIL::DICOM::PACSController::Instance()->EsDICOM(std::string(wxPathFich.ToUTF8()), false, true) ) {
								std::string pathStd(TOPATH(wxPathFich));
								listaFicheros.push_back(pathStd);
							}
							cont = dir.GetNext(&wxPathFich);
						}
					}
					GNC::GCS::ControladorHistorial::Instance()->AddFiles(listaFicheros,m_pIncluirParams->m_modelosDCM,m_pIncluirParams->m_listaPathsSobreescriben, m_pIncluirParams->m_ErrorList,m_pIncluirParams->m_forzarSobreescribir,this,m_pIncluirParams->m_addAction);
					SubComandoAvisarModelosParams * pParams = new SubComandoAvisarModelosParams(m_pIncluirParams->m_modelosDCM,m_pIncluirParams->m_abrirDespuesDeCargar,m_pIncluirParams->m_pModeloIntegracion);
					SubComandoAvisarModelos * pCmd = new SubComandoAvisarModelos(pParams);
					GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Including files in the history .."),pCmd,NULL);
					for(GNC::GCS::ControladorHistorial::ListaModelosDCM::iterator it = m_pIncluirParams->m_modelosDCM.begin(); it != m_pIncluirParams->m_modelosDCM.end(); ++it)
					{
						m_pIncluirParams->m_listaEstudios.insert((*it).m_uidEstudio);
						m_pIncluirParams->m_listaSeries.insert((*it).m_uidSerie);
						m_pIncluirParams->m_listaImagenes.insert((*it).m_uidImagen);
					}
					m_pIncluirParams->m_modelosDCM.clear();
				}
			} else {
				GNC::GCS::ControladorHistorial::Instance()->AddFiles(m_pIncluirParams->m_listaPaths,m_pIncluirParams->m_modelosDCM,m_pIncluirParams->m_listaPathsSobreescriben, m_pIncluirParams->m_ErrorList,m_pIncluirParams->m_forzarSobreescribir,this,m_pIncluirParams->m_addAction);
				for(GNC::GCS::ControladorHistorial::ListaModelosDCM::iterator it = m_pIncluirParams->m_modelosDCM.begin(); it != m_pIncluirParams->m_modelosDCM.end(); ++it)
				{
					m_pIncluirParams->m_listaEstudios.insert((*it).m_uidEstudio);
					m_pIncluirParams->m_listaSeries.insert((*it).m_uidSerie);
					m_pIncluirParams->m_listaImagenes.insert((*it).m_uidImagen);
				}
			}
		}

		void  ComandoIncluirHistorial::LeerDirectorioRecursivo(wxString& dirPath, TListaListas& listaListasPaths, int profundidadMaxima, const int profundidadActual)
		{
			{
				std::ostringstream ostr;
				ostr << _Std("Exploring directory ") << dirPath.ToUTF8();
				NotificarProgreso(0.0f, ostr.str());
				if (EstaAbortado())
				{
					return;
				}
			}
			TListaPaths listaCurrentPaths;
			wxArrayString listaDirectoriosCurrent;
			bool dicomEncontrado = false;
			if(wxDirExists(dirPath)) {
				//vaciar
				wxDir dir;
				if (dir.Open(dirPath)) {
					wxString fileName;
					//no se listan los ocultos
					bool cont = dir.GetFirst(&fileName,wxEmptyString,wxDIR_FILES | wxDIR_DIRS);
					while (cont) {
						fileName=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) + fileName;
						if(wxDir::Exists(fileName) ){
							listaDirectoriosCurrent.push_back(fileName);
						}else if (wxFileExists(fileName)) {
							wxFileName filename(fileName);
							if(filename.GetExt().Lower() == wxT("dcm") || GIL::DICOM::PACSController::Instance()->EsDICOM(std::string(fileName.ToUTF8()), false, true) ) {
								std::string pathStd(TOPATH(fileName));
								listaCurrentPaths.push_back(pathStd);
								dicomEncontrado = true;
							}
						}
						cont = dir.GetNext(&fileName);
					}
				}
			} else if (wxFileExists(dirPath)) {
				wxFileName filename(dirPath);
				if(filename.GetExt().Lower() == wxT("dcm") || GIL::DICOM::PACSController::Instance()->EsDICOM(std::string(dirPath.ToUTF8()), false, true)) {
					std::string pathStd(TOPATH(dirPath));
					listaCurrentPaths.push_back(pathStd);
					dicomEncontrado = true;
				}
			}

			int siguienteProfundidad = profundidadActual;
			if(dicomEncontrado) {
				//se resetea la profundidad actual
				siguienteProfundidad = 0;
			} else {
				siguienteProfundidad ++;
			}
			if(siguienteProfundidad <= profundidadMaxima) {
				for(wxArrayString::iterator it =listaDirectoriosCurrent.begin(); it != listaDirectoriosCurrent.end(); ++it) {
					LeerDirectorioRecursivo((*it),listaListasPaths,profundidadMaxima,siguienteProfundidad);
				}
			}

			listaListasPaths.push_back(listaCurrentPaths);
		}

		void ComandoIncluirHistorial::Update()
		{
			wxString message = wxT("");
			message += _("Image acquisition finished.");
			message += wxT(" ");
			message += wxString::Format(_("There have been included %d studies, %d series and %d images."),m_pIncluirParams->m_listaEstudios.size(), m_pIncluirParams->m_listaSeries.size(), m_pIncluirParams->m_listaImagenes.size());		
			message += wxT("\n");
			if (m_pIncluirParams->m_ErrorList.size() > 0)
				message += wxString::Format(_("\nThere are %d errors (see log for more detailed description)"), m_pIncluirParams->m_ErrorList.size());
			if (m_pIncluirParams->m_listaPathsSobreescriben.size() > 0) 
				message += wxString::Format(_("\nThere are %d files that overwrite existing files"), m_pIncluirParams->m_listaPathsSobreescriben.size());

			//log
			{
				std::ostringstream errorOstr;
				if (m_pIncluirParams->m_ErrorList.size() > 0) {

					bool first = true;
					for (GNC::GCS::ControladorHistorial::TAddErrorList::iterator it = m_pIncluirParams->m_ErrorList.begin();it != m_pIncluirParams->m_ErrorList.end(); ++it)
					{
						if ((*it).error == GNC::GCS::ControladorHistorial::TAddError::TE_FileNotExist) {
							if (first) {
								errorOstr<< "\t" << _Std("This files doesn't exist:") << std::endl;
								first = false;
							}
							errorOstr << "\t\t" << (*it).path << std::endl;
						}
					}
					first = true;
					for (GNC::GCS::ControladorHistorial::TAddErrorList::iterator it = m_pIncluirParams->m_ErrorList.begin();it != m_pIncluirParams->m_ErrorList.end(); ++it)
					{
						if ((*it).error == GNC::GCS::ControladorHistorial::TAddError::TE_WrongFormat) {
							if (first) {
								errorOstr<< "\t" << _Std("This files doesn't have DICOM format:") << std::endl;
								first = false;
							}
							errorOstr << "\t\t" << (*it).path << std::endl;
						}
					}
					
					first = true;
					for (GNC::GCS::ControladorHistorial::TAddErrorList::iterator it = m_pIncluirParams->m_ErrorList.begin();it != m_pIncluirParams->m_ErrorList.end(); ++it)
					{
						if ((*it).error == GNC::GCS::ControladorHistorial::TAddError::TE_DICOMDir) {
							if (first) {
								errorOstr << "\t" <<_Std("This files are Dicom Dirs:") << std::endl;
								first = false;
							}
							errorOstr << "\t\t" << (*it).path << std::endl;
						}
					}
				}
				if (m_pIncluirParams->m_listaPathsSobreescriben.size() > 0) {
					errorOstr << "\t" << _Std("This files has to be overwritten") << std::endl;
					for (std::list<std::string>::iterator it = m_pIncluirParams->m_listaPathsSobreescriben.begin(); it != m_pIncluirParams->m_listaPathsSobreescriben.end(); ++it)
					{
						errorOstr << "\t\t" << (*it) << std::endl;
					}
				}
				std::string errorString = errorOstr.str();
				if (errorString.size()>0) {
					LOG_ERROR("ComandoIncluirHistorial", errorOstr.str());
				}
			}

			//se abre o porque nos lo dicen o porque solo hay una serie y tenemos que informar, en ese caso en vez de informar lo abrimos
			bool abrir = m_pIncluirParams->m_abrirDespuesDeCargar ||  ( m_pIncluirParams->m_listaSeries.size() == 1 && m_pIncluirParams->m_informar);
			//si hay paths que se han sobreeescrito se pregunta si quiere sobreescribir
			if(m_pIncluirParams->m_listaPathsSobreescriben.size() > 0) {
				GNC::GUI::OverwriteDialogBase overwriteDialog(GNC::Entorno::Instance()->GetVentanaRaiz());

				overwriteDialog.m_pTextMessage->SetLabel(message);

				overwriteDialog.m_pTextMessage->GetParent()->Layout();
				overwriteDialog.m_pTextMessage->Layout();

				int answer = overwriteDialog.ShowModal();
				if(answer == wxID_OK) {
					//overwrite
					ComandoIncluirHistorialParams* pParams = new ComandoIncluirHistorialParams(m_pIncluirParams->m_listaPathsSobreescriben,m_pIncluirParams->m_abrirDespuesDeCargar, true, m_pIncluirParams->m_pModeloIntegracion);
					pParams->m_addAction = m_pIncluirParams->m_addAction;
					ComandoIncluirHistorial* pCmd = new ComandoIncluirHistorial(pParams);
					GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Including files in the history .."),pCmd,NULL);
				}
			} else {
				//si no hay paths sobreeescritos y hay que informar se pregunta si quiere abrir
				if (!abrir && m_pIncluirParams->m_informar) {
					wxMessageBox(message,_("Finished .."), wxOK );
				} 
			}
			if(m_pIncluirParams->m_modelosDCM.size() == 0) {
			/*	wxMessageBox(wxT("No se han encontrado estudios nuevos"), wxT("Info"),
					wxOK | wxICON_INFORMATION, GNC::Entorno::Instance()->GetVentanaRaiz());*/
			} else {
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GUI::Eventos::EventoAddModeloHistorial(&m_pIncluirParams->m_modelosDCM, abrir, m_pIncluirParams->m_pModeloIntegracion));
			}
		}
	}
}

