/*
 *  
 *  $Id: ientorno.h 4682 2012-02-09 14:25:47Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once

#include <string>
#include <map>
#include <list>
#include <vector>

#include "ivista.h"

#include "icontroladorherramientas.h"
#include "icontroladorvistas.h"
#include "icontroladorcomandos.h"
#include "icontroladoreventos.h"
#include "icontroladorcarga.h"
#include "icontroladorpermisos.h"
#include "icontroladorlog.h"
#include "icontroladorextensiones.h"
#include "icontroladorhistorial.h"
#include "icontroladoracciones.h"
#include "iconfigurationcontroller.h"
#include "icontroladorinternacionalizacion.h"
#include <api/controllers/ipacscontroller.h>
#include "iventanaprogreso.h"
#include "iwidgetsmanager.h"
#include "../yasper/yasper.h"

// Forward Declarations
class wxPanel;
class wxWindow;
class wxPropertyGrid;
class wxApp;
class VentanaPrincipal;
namespace GIL {
	namespace DICOM {
		class IPACSController;
	}
}
// Forward Declarations

namespace GNC {
	namespace GCS {

		class EXTAPI IEntorno {

		public:			
			typedef std::map< std::string, GIL::Ubicacion > MapaUbicaciones;

		protected:
			IEntorno() { };
			virtual ~IEntorno() { };

			MapaUbicaciones         m_Ubicaciones;

		public:

			virtual const std::string& GetGinkgoVersion() = 0;
			virtual void GetGinkgoVersionAsTuple(int* version, int* subversion, int* relase, int* build, std::string* codename) = 0;
			virtual const std::string& GetGinkgoCopyRight() = 0;
			virtual int ParseSVNBuild(const char* str) = 0;
			virtual const std::string& GetPluginsPath() = 0;
			virtual const std::string& GetGinkgoUserDir() = 0;
			virtual const std::string& GetGinkgoTempDir() = 0;
			virtual std::string CreateGinkgoTempDir() = 0;
			virtual const std::string& GetGinkgoResourcesDir() = 0;
			virtual std::string CrearDirectorioTemporal() = 0;
			virtual std::string GetDicomLocalAET() = 0;
			virtual std::string ParseAET(const std::string& aet) = 0;

			virtual void YieldApp() = 0;
			virtual wxApp* GetApp() = 0;
			virtual VentanaPrincipal* GetVentanaPrincipal() = 0;
			virtual wxWindow* GetVentanaRaiz() = 0;

			virtual wxPanel* GetPanelHerramientasSuperior() = 0;

			virtual GNC::GCS::IControladorVistas* GetControladorVistas() = 0;
			virtual GNC::GCS::IControladorComandos* GetControladorComandos() = 0;
			virtual GNC::GCS::IControladorHerramientas* GetControladorHerramientas() = 0;
			virtual GIL::DICOM::IPACSController* GetPACSController() = 0;
			virtual GNC::GCS::IControladorEventos* GetControladorEventos() = 0;
			virtual GNC::GCS::IControladorCarga* GetControladorCarga() = 0;
			virtual GNC::GCS::IControladorPermisos* GetControladorPermisos() = 0;
			virtual GNC::GCS::IControladorLog* GetControladorLog() = 0;
			virtual GNC::GCS::IControladorExtensiones* GetControladorExtensiones() = 0;
			virtual GNC::GCS::IControladorHistorial* GetControladorHistorial() = 0;
			virtual GNC::GCS::IControladorAcciones*  GetControladorAcciones() = 0;
			virtual GNC::GCS::IControladorInternacionalizacion*  GetControladorInternacionalizacion() = 0;
			virtual GNC::GCS::IConfigurationController* GetConfigurationController() = 0;

			virtual GNC::GCS::IWidgetsManager* NewWidgetsManager(GNC::GCS::IVista* pVista) = 0;
			virtual void FreeWidgetsManager(GNC::GCS::IWidgetsManager* pManager) = 0;

			virtual MapaUbicaciones& GetUbicaciones() = 0;
		};
	}
}
