/*
 *
 *  $Id: icontextoestudio.h 4582 2012-01-24 09:39:52Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <api/api.h>
#include <string>
#include <vector>
#if defined(__DEPRECATED)
#undef __DEPRECATED
#endif
#include <vtkSmartPointer.h>
#include <yasper/yasper.h>
#include <api/ilock.h>
#include <api/dicom/idicom.h>

class vtkGinkgoImageViewer;
class vtkAlgorithmOutput;
class vtkImageData;

class wxWindow;

namespace GNC {
	namespace GCS {
		class IEntorno;
		class IVista;
		class IStreamingLoader;
		class IContextoEstudioReferido;
		class IControladorModulo;
	}
}

namespace GIL {
	namespace DICOM {
		struct TipoJerarquia;
		struct TipoPrivateTags;
		class IDICOMManager;
	}
}

namespace GNC {
	namespace GCS {
		//region Interfaz de gestion de entrada (ficheros, diagnosticos, etc..)
		class EXTAPI IContextoEstudio: public ILockable{
		public:
			typedef enum TModoFuncionamiento {
				TMF_UNDiagnostico,
				TMF_NDiagnosticos
			} TModoFuncionamiento;
			typedef struct TFicheroEstudio {
				std::string RutaImagen;
				std::string RutaDiagnostico;
				bool			Modificado;
				bool			WidgetsCargados;
				GnkPtr<GIL::DICOM::TipoMetaInfo> MetaInfo;
				GnkPtr<GIL::DICOM::TipoJerarquia> TagsImagen;
				GnkPtr<GIL::DICOM::TipoJerarquia> TagsDiagnostico;
				GnkPtr<GIL::DICOM::TipoPrivateTags> TagsPrivados;

				TFicheroEstudio()
				{
					RutaImagen = "";
					RutaImagen = "";
					Modificado = false;
					WidgetsCargados = false;
				}

			} TFicheroEstudio;


			typedef std::vector<GnkPtr<TFicheroEstudio> >     TVectorFicherosEstudio;

			GNC::GCS::IEntorno*                               Entorno;
			GNC::GCS::IVista*                                 Vista;
			GNC::GCS::IControladorModulo*                     Modulo;
			vtkSmartPointer<vtkGinkgoImageViewer>             Viewer;
			wxWindow*                                         VentanaPadre; // La ventana WX de la que es padre la vista (Notebook/Grid..)
			wxWindow*                                         Ventana;      // La ventana WX propia de la vista

			GnkPtr<GNC::GCS::IStreamingLoader>                Loader;

			vtkSmartPointer<vtkAlgorithmOutput>               renderConnection; // Conexion hacia renderer

			int                                               IndiceFicheroActivo;
			std::list<std::string>                            ListaUIDsSerie;
		protected:
			TVectorFicherosEstudio										Ficheros;
			bool                                              IgnorarModificaciones;
			TModoFuncionamiento                               ModoFuncionamiento;


			std::string                                       UIDEstudioDiagnostico;
		public:

			IContextoEstudio();

			IContextoEstudio(const IContextoEstudio& o);
			IContextoEstudio(const IContextoEstudio* o);

			virtual ~IContextoEstudio();

			static GnkPtr<GNC::GCS::IContextoEstudioReferido> NewRef(const GnkPtr<GNC::GCS::IContextoEstudio>& parent);

			IContextoEstudio& operator = (const IContextoEstudio& o);

			bool GetIgnorarModificaciones();
			void SetIgnorarModificaciones(bool ignorar = true);

			/** Obtiene el puerto de conexion de salida del StreamingLoader. Se usa para inyectar pipelines que necesiten las vistas graficas
				Pipeline: Loader.ruta_fichero => [...] => Loader.loaderOutputConnection => [PIPELINE_ESPECIFICO] => Viewer.renderInputConnection => [...]
			**/
			vtkSmartPointer<vtkAlgorithmOutput> GetLoaderOutputConnection();

			/** Obtiene el puerto de conexion de entrada hacia el renderer. Por defecto es la salida del StreamingLoader
				Pipeline: Loader.ruta_fichero => [...] => Loader.loaderOutputConnection => [PIPELINE_ESPECIFICO] => Viewer.renderInputConnection => [...]
			**/
			void SetRendererInputConnection(const vtkSmartPointer<vtkAlgorithmOutput>& input);

			void SetViewer(const vtkSmartPointer<vtkGinkgoImageViewer>& viewer);

			virtual void SetIndiceActivo(int indice);

			virtual void InicializarContextoEstudio(std::vector<std::string>& rutas, const std::string uidEstudioDiagnostico, TModoFuncionamiento modoFuncionamiento);
			std::vector<std::string> GetRutasImagenes();

			std::vector<std::string> GetRutasDiagnosticos();

			std::list<std::string> GetListaFicherosYDiagnosticos();

			const std::string& GetRutaDeImagenActiva();
			const std::string& GetRutaDeImagen(const int indice);
			const std::string& GetRutaDeDiagnosticoActivo();

			const std::string& GetUIDEstudioDiagnostico();

			//tags
			GnkPtr<GIL::DICOM::TipoMetaInfo>    GetMetaInfoDeImagenActiva();
			GnkPtr<GIL::DICOM::TipoJerarquia>   GetTagsImagenDeImagenActiva();
			GnkPtr<GIL::DICOM::TipoJerarquia>   GetTagsDiagnosticoDeImagenActiva();
			GnkPtr<GIL::DICOM::TipoPrivateTags> GetTagsPrivadosDeImagenActiva();

			GnkPtr<GIL::DICOM::TipoMetaInfo>    GetMetaInfo(const int indice);
			GnkPtr<GIL::DICOM::TipoJerarquia>   GetTagsImagen(const int indice);
			GnkPtr<GIL::DICOM::TipoJerarquia>   GetTagsDiagnostico(int indice);
			GnkPtr<GIL::DICOM::TipoPrivateTags> GetTagsPrivados(int indice);

			int GetNumeroCortes();
			virtual void RecalibrarImagenActiva(double spacing[3], double origin[3]);
			virtual void RecalibrarImagen(const int indice, double spacing[3], double origin[3]);

			bool GetSpacingActiva(double* spacing);
			bool GetSpacingActiva(double& x, double& y, double& z);
			// Returns true if image has spacing
			bool GetSpacing(const int indice, double& x, double& y, double& z);
			virtual void SetSpacing(const int indice, const double x, const double y, const double z);

			void GetOriginActiva(double* origin);
			void GetOriginActiva(double& x, double& y, double& z);
			void GetOrigin(const int indice, double& x, double& y, double& z);

			void GetDimensionsImagenActiva(int* dimensions);
			void GetDimensionsImagenActiva(int& x, int& y, int& z);
			void GetDimensionsImagen(const int indice, int& x, int& y, int& z);

			int GetTSizeActiva();
			const std::string GetNombreMedico();
			const std::string GetNombreCentro();

			bool GetTagImagenActiva(const std::string& tag, std::string& valor);
			bool GetTagDiagnosticoActivo(const std::string& tag, std::string& valor);

			int GetIndicePath(const std::string& path);

			TModoFuncionamiento GetModoFuncionamiento();

			//modificado...
			bool EstaModificadoActivo();
			bool EstaModificado();
			void SetModificadoFicheroActivo();
			void SetModificado(const int indice);

			//Guardar
			bool Guardar();
			void GuardarWidgets(int indice);
			bool IsKeyImageActive();
			bool IsKeyImage(int indice = 0);
			void CargarWidgetsActivo(bool force = false);
			void CargarWidgets(int indice = 0, bool force = false);
			virtual bool CallbackPreGuardarDiagnostico(const int /*indice*/, GIL::DICOM::IDICOMManager* /*pDicomManager*/) = 0;
			virtual bool CallbackPreCrearDiagnostico(const int /*indice*/, GIL::DICOM::TipoJerarquia* /*pJerarquiaSR*/, std::list<GnkPtr<GIL::DICOM::TipoPrivateTags> >&/*listaTagsPrivados*/) = 0;

			void CreateLoader();


		protected:
			void SetTagsDiagnostico( GIL::DICOM::TipoJerarquia& baseSR, GnkPtr<GIL::DICOM::TipoJerarquia> pTagDiagnostico );
			bool GuardarUnDiagnostico();
			bool GuardarNDiagnosticos();
			void CargarMetaInfo(const int indice);
			void CargarTagsImagen(const int indice);
			virtual void CallbackCargarTagsImagen(const int /*indice*/, GIL::DICOM::IDICOMManager* /*pDicomManager*/) = 0;
			void CrearMapaValoracionUnsignedChar(vtkSmartPointer<vtkImageData>& pMapa, GnkPtr<GIL::DICOM::TipoPrivateTags> pTagsPrivados, const unsigned char tag, const int indice, unsigned char valorInicial = 0);
			void CrearMapaValoracionChar(vtkSmartPointer<vtkImageData>& pMapa, GnkPtr<GIL::DICOM::TipoPrivateTags> pTagsPrivados, const unsigned char tag, const int indice, char valorInicial = 0);

			friend class IContextoEstudioReferido;
		};

		class EXTAPI IContextoEstudioReferido : public IContextoEstudio
		{
		public:
			IContextoEstudioReferido();

			virtual ~IContextoEstudioReferido();

			void UnRefViewer();

			virtual bool CallbackPreGuardarDiagnostico(const int indice, GIL::DICOM::IDICOMManager* pDicomManager) {return EstudioPadre->CallbackPreGuardarDiagnostico(indice, pDicomManager);}
			virtual bool CallbackPreCrearDiagnostico(const int indice, GIL::DICOM::TipoJerarquia* pJerarquiaSR, std::list<GnkPtr<GIL::DICOM::TipoPrivateTags> >&listaTagsPrivados) {return EstudioPadre->CallbackPreCrearDiagnostico(indice, pJerarquiaSR,listaTagsPrivados);}
			virtual void CallbackCargarTagsImagen(const int indice, GIL::DICOM::IDICOMManager* pDicomManager) {EstudioPadre->CallbackCargarTagsImagen(indice, pDicomManager);}


			GnkPtr<IContextoEstudio> EstudioPadre;

		};
	}
}
