/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_SEARCH_H__
#define __UI_SEARCH_H__

#include <gtk/gtk.h>

#include "ui_child.h"

/*
  GiftuiChild
      +----GiftuiSearch
*/

#define GIFTUI_TYPE_SEARCH (giftui_search_get_type ())
#define GIFTUI_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIFTUI_TYPE_SEARCH, GiftuiSearch))
#define GIFTUI_SEARCH_CLASS(class) (G_TYPE_CHECK_CLASS_CAST ((class), GIFTUI_TYPE_SEARCH, GiftuiSearchClass))
#define GIFTUI_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIFTUI_TYPE_SEARCH))
#define GIFTUI_IS_SEARCH_CLASS(class) (G_TYPE_CHECK_CLASS_TYPE ((class), GIFTUI_TYPE_SEARCH))
#define GIFTUI_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GIFTUI_TYPE_SEARCH, GiftuiSearchClass))

typedef struct _GiftuiSearch GiftuiSearch;
typedef struct _GiftuiSearchClass GiftuiSearchClass;

typedef struct _GiftuiSearchTip_t GiftuiSearchTip_t;

struct _GiftuiSearchTip_t
{
	GtkWidget *window;
	GtkWidget *icon;
	GtkWidget *label;
};

struct _GiftuiSearch
{
	GiftuiChild parent_instance;
	
	/* < private_data > */
	guint running;
	
	gboolean motion_in; /* the mouse is inside our widget */
	guint motion_idle; /* timeout before showing the tip */
	GtkTreePath *motion_path; /* Line pointed */
	GdkRectangle motion_cell; /* cell pointed by the mouse */
	GiftuiSearchTip_t *meta_tip; /* the tip */
	
	GtkWidget *combo_include, *combo_exclude; /* Where we have got text. */
	GtkWidget *type, *network; /* Type of file */
	
	GtkWidget *list; /* Where we put results */
	GtkWidget *popup; /* Popup menu */
};

struct _GiftuiSearchClass
{
	GiftuiChildClass parent_class;
};

GType giftui_search_get_type (void);
GtkWidget *giftui_search_new (void);

#endif
