/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __CONFIGURE_H__
#define __CONFIGURE_H__

#include <glib.h>
#include <gconf/gconf-client.h>

/* CONFIG */

#define GIFTUI_GCONF "/apps/giftui"


#define PREFS_DAEMON GIFTUI_GCONF "/daemon"

#define PREFS_DAEMON_BINARY PREFS_DAEMON "/binary"
#define PREFS_DAEMON_LAUNCH PREFS_DAEMON "/launch"
#define PREFS_DAEMON_KILL PREFS_DAEMON "/kill"
#define PREFS_DAEMON_HOST PREFS_DAEMON "/host"
#define PREFS_DAEMON_PORT PREFS_DAEMON "/port"


#define PREFS_MAIN GIFTUI_GCONF "/ui"

#define PREFS_MAIN_WINDOW_WIDTH PREFS_MAIN "/window_width"
#define PREFS_MAIN_WINDOW_HEIGHT PREFS_MAIN "/window_height"
#define PREFS_MAIN_TABS PREFS_MAIN "/tabs"


#define PREFS_TRANSFERS PREFS_MAIN "/transfers"

#define PREFS_TRANSFERS_PANED_HEIGHT PREFS_TRANSFERS "/paned_height"
#define PREFS_TRANSFERS_ACTIVE_COLOR PREFS_TRANSFERS "/active_color"
#define PREFS_TRANSFERS_COMPLETED_COLOR PREFS_TRANSFERS "/completed_color"
#define PREFS_TRANSFERS_CANCELED_COLOR PREFS_TRANSFERS "/canceled_color"
#define PREFS_TRANSFERS_PAUSED_COLOR PREFS_TRANSFERS "/paused_color"
#define PREFS_TRANSFERS_CLEAR_COMPLETED PREFS_TRANSFERS "/clear_completed"
#define PREFS_TRANSFERS_CLEAR_CANCELED PREFS_TRANSFERS "/clear_canceled"


#define PREFS_SEARCH PREFS_MAIN "/search"

#define PREFS_SEARCH_NETWORKS "/networks"

/**/

#define GIFTUI_HANDLER_CB(arg) ((GiftuiHandlerCB_t) (arg))

typedef void (* GiftuiHandlerCB_t) (gpointer *);

/* ALL */

gint giftui_config_init (void);
void giftui_config_end (void);

/* CONFIG */

gboolean giftui_config_load_from_args (gint argc, gchar *argv[]);

void giftui_config_set_bool (const gchar *key, gboolean val);
void giftui_config_set_int (const gchar *key, gint val);
void giftui_config_set_str (const gchar *key, const gchar *str);
void giftui_config_set_list (const gchar *key, GConfValueType type, GList *list);

gboolean giftui_config_get_bool (const gchar *key);
gint giftui_config_get_int (const gchar *key);
gchar *giftui_config_get_str (const gchar *key);
GList *giftui_config_get_list (const gchar *key, GConfValueType type);

/* DATA */

void giftui_data_set (const gchar *keypath, gpointer value);
void giftui_data_set_full (const gchar *keypath, gpointer value, GDestroyNotify destroy_func);

gpointer giftui_data_get (const gchar *keypath);

/* SIGNAL */

void giftui_signal_register (const gchar *name, GiftuiHandlerCB_t handler, gpointer data);
void giftui_signal_unregister (const gchar *name, GiftuiHandlerCB_t handler, gpointer data);
void giftui_signal_unregister_by_handler (const gchar *name, GiftuiHandlerCB_t handler);
void giftui_signal_unregister_by_data (const gchar *name, gpointer data);

void giftui_signal_emit (const gchar *name);

#endif
