import docutils.parsers.rst
from docutils.parsers.rst.directives import _directive_registry
from docutils.parsers.rst import states
import docutils.nodes


class Parser(docutils.parsers.rst.Parser):
    def __init__(self):
        docutils.parsers.rst.Parser.__init__(self, inliner = Inliner())

##################################################################
# GGI specific inline roles
##################################################################
class Inliner(states.Inliner):
    default_interpreted_role = 'system'
    
    def __init__(self):
        states.Inliner.__init__(self, roles = { 'system' : self.system_role,
                                                'p'      : self.parameter_role,
                                                'man'    : self.man_role})
        
    def man_role(self, role, rawtext, text, lineno):
        r = docutils.nodes.literal(rawtext, text)
        r.ggi_type = 'man'
        res = rawtext[1:-1].split("(")
        if len(res) == 2:
            
            # XXX resolv ref
            r.ggi_ref=(res[0],res[1][:-1])
        return [ r ], []

    def system_role(self, role, rawtext, text, lineno):
        r = docutils.nodes.literal(rawtext, text)
        r.ggi_type = 'system'
        return [ r ], []

    def parameter_role(self, role, rawtext, text, lineno):
        r = docutils.nodes.literal(rawtext, text)
        r.ggi_type = 'parameter'
        return [ r ], []

##################################################################
# GGI specific directives
##################################################################
_directive_registry['hotfix']  = (__name__, 'directive_hotfix')
_directive_registry['manpage'] = (__name__, 'directive_manpage')

# automagically create a link to the hotfix file
def directive_hotfix(name, arguments, options, content, lineno,
                     content_offset, block_text, state, state_machine):
    date, file = arguments
    uri = "http://www.ggi-project.org/ftp/patches/hotfixes/"+file
    ref = docutils.nodes.reference('', date + " : " +file)
    ref['refuri']=uri
    hf = docutils.nodes.definition_list()
    dli = docutils.nodes.definition_list_item()
    t = docutils.nodes.term()
    t += ref
    dli += t
    hf += dli
    p = docutils.nodes.definition()
    dli += p
    state.nested_parse(content, content_offset, p)
    return [hf]
directive_hotfix.arguments = (2,0,0)
directive_hotfix.options   = None
directive_hotfix.content   = 1


# Mark the current section as a manpage
def directive_manpage(name, arguments, options, content, lineno,
                     content_offset, block_text, state, state_machine):
    # This might not  be really 'valid'
    # We had a new member to the section with all necessary information
    # It is transparent for other docutils processes

    vol, pages   = arguments[0], arguments[1].split()

    # the title of the page is the title of the section we're in
    title = state.parent[0][0]

    ref = ( pages[0], vol )

    # we *mark* the parent section as manpage
    state.parent.ggi_manpage = ref
    
    # add the ``name`` section
    sect = docutils.nodes.section()
    sect += docutils.nodes.title('','Name')
    p = docutils.nodes.paragraph('', '')
    for i in pages:
        n = docutils.nodes.literal(i,i)
        n.ggi_type='system'
        p += n
        if not i == pages[-1]:
            p += docutils.nodes.Text(', ')
    p += docutils.nodes.Text(' : %s'%title)
    sect += p
    
    # register the manpages reference at toplevel for :
    # 1. navigation sequence

    try:
        len(state.parent.document.manpages)
    except:
        state.parent.document.manpages = []
        state.parent.document.manpages_entries = {}
    
    state.parent.document.manpages.append(ref)

    # 2. reference lookup
    state.parent.document.manpages_entries[ref]={ 'volume':vol, 'page': pages[0],
                                                  'links' : pages[1:], 'title':title,
                                                  'node':state.parent }
    return [ sect ]

directive_manpage.arguments = (2,0,1)
directive_manpage.options = None

import os


def scan_manpages(f):
    l = []
    print f
    d , n = os.path.dirname(f), os.path.basename(f)
    c = os.getcwd()
    if d: os.chdir(d)
    for i in open(n).readlines():
        if i.startswith('.. manpage::'):
            l.append(i[len('.. manpage::'):].strip().split())
        elif i.startswith('.. include::'):
            l.extend(scan_manpages(i.strip().split()[2]))
    os.chdir(c)
    return l

if __name__ == '__main__':
    import sys
    print scan_manpages(sys.argv[1])
    print parse(sys.argv[1])
