/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  treeselection.inl - Gtk::TreeSelection inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GtkTreeSelection*
GFC::Gtk::TreeSelection::gtk_tree_selection() const
{
	return reinterpret_cast<GtkTreeSelection*>(instance_);
}

inline GFC::Gtk::TreeSelection::operator GtkTreeSelection* () const
{
	return this ? gtk_tree_selection() : 0;
}

inline GFC::Gtk::SelectionMode
GFC::Gtk::TreeSelection::get_mode() const
{
	return (SelectionMode)gtk_tree_selection_get_mode(gtk_tree_selection());
}

inline bool
GFC::Gtk::TreeSelection::any_selected() const
{
	return gtk_tree_selection_get_selected(gtk_tree_selection(), 0, 0);
}

inline int
GFC::Gtk::TreeSelection::count_selected_rows() const
{
	return gtk_tree_selection_count_selected_rows(gtk_tree_selection());
}

inline void
GFC::Gtk::TreeSelection::set_mode(SelectionMode type)
{
	gtk_tree_selection_set_mode(gtk_tree_selection(), (GtkSelectionMode)type);
}

inline void
GFC::Gtk::TreeSelection::select_all()
{
	gtk_tree_selection_select_all(gtk_tree_selection());
}

inline void
GFC::Gtk::TreeSelection::unselect_all()
{
	gtk_tree_selection_select_all(gtk_tree_selection());
}

inline const GFC::Gtk::TreeSelection::ChangedSignalProxy
GFC::Gtk::TreeSelection::sig_changed()
{
	return ChangedSignalProxy(this, &changed_signal);
}
