/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  calendar.cc - GtkCalendar C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "calendar.hh"
#include "private/calendarclass.hh"
#include "private/marshal.hh"

using namespace GFC;

/*  Gtk::Calendar
 */

Gtk::Calendar::Calendar(GtkCalendar *calendar, bool owns_reference)
: Widget((GtkWidget*)calendar, owns_reference)
{
}

Gtk::Calendar::Calendar()
: Widget((GtkWidget*)CalendarClass::create())
{
}

Gtk::Calendar::Calendar(CalendarDisplayOptionsField flags)
: Widget((GtkWidget*)CalendarClass::create())
{
	set_display_options(flags);
}

Gtk::Calendar::~Calendar()
{
}

std::vector<bool>
Gtk::Calendar::marked_date() const
{
	std::vector<bool> dates(31);

	for (int i = 0; i < 31; i++)
	{
		dates[i] = gtk_calendar()->marked_date[i];
	}

	return dates;
}

/*  Gtk::Calendar signals
 */

const Gtk::Calendar::MonthChangedSignalType Gtk::Calendar::month_changed_signal("month_changed", (GCallback)&G::Marshal::void_callback);

const Gtk::Calendar::DaySelectedSignalType Gtk::Calendar::day_selected_signal("day_selected", (GCallback)&G::Marshal::void_callback);

const Gtk::Calendar::DaySelectedDoubleClickSignalType Gtk::Calendar::day_selected_double_click_signal("day_selected_double_click", (GCallback)&G::Marshal::void_callback);

const Gtk::Calendar::PrevMonthSignalType Gtk::Calendar::prev_month_signal("prev_month", (GCallback)&G::Marshal::void_callback);

const Gtk::Calendar::NextMonthSignalType Gtk::Calendar::next_month_signal("next_month", (GCallback)&G::Marshal::void_callback);

const Gtk::Calendar::PrevYearSignalType Gtk::Calendar::prev_year_signal("prev_year", (GCallback)&G::Marshal::void_callback);

const Gtk::Calendar::NextYearSignalType Gtk::Calendar::next_year_signal("next_year", (GCallback)&G::Marshal::void_callback);

