/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  timer.inl - G::Timer inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GTimer*
GFC::G::Timer::g_timer() const
{
	return timer_;
}

inline GFC::G::Timer::operator GTimer* () const
{
	return this ? timer_ : 0;
}

inline void
GFC::G::Timer::start()
{
	g_timer_start(timer_);
}

inline void
GFC::G::Timer::stop()
{
	g_timer_stop(timer_);
}

inline void
GFC::G::Timer::reset()
{
	g_timer_reset(timer_);
}

inline void 
GFC::G::Timer::resume()
{
	g_timer_continue(timer_);
}

inline double
GFC::G::Timer::elapsed(unsigned long *microseconds)
{
	return g_timer_elapsed(timer_, microseconds);
}

