/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.tools;

import gmonitor.logdata.DataBlock;
import gmonitor.logdata.DataBlockGroup;
import gmonitor.logdata.DataFile;
import gmonitor.logdata.FirstMetaBlock;
import gmonitor.logdata.SecondMetaBlock;
import java.io.IOException;

public class GlogDump {
    protected boolean swFMBOutput = true;
    protected boolean swSMBOutput = true;
    protected boolean swDBOutput = true;
    protected String filename = "glogger.bin";

    public GlogDump() {
    }

    public GlogDump(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) continue;
            this.filename = stringArray[i];
        }
    }

    public void run() {
        try {
            DataFile dataFile = DataFile.getInstance(this.filename);
            FirstMetaBlock firstMetaBlock = dataFile.getFirstMetaBlock();
            SecondMetaBlock secondMetaBlock = dataFile.getSecondMetaBlock();
            if (this.swFMBOutput) {
                System.out.println(firstMetaBlock.asDump());
            }
            if (this.swSMBOutput) {
                System.out.println(secondMetaBlock.asDump());
            }
            if (this.swDBOutput) {
                int n = (int)dataFile.getLength();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    DataBlockGroup dataBlockGroup = dataFile.getDataBlockGroup(i);
                    for (int j = 0; j < dataBlockGroup.size(); ++j) {
                        DataBlock dataBlock = (DataBlock)dataBlockGroup.get(j);
                        System.out.print(dataBlock.asDump(n2, secondMetaBlock.getIntervalDefBlock()));
                        ++n2;
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        GlogDump glogDump = new GlogDump(stringArray);
        glogDump.run();
    }
}

