#  treeview.rb - 
#  Copyright (C) 2004-2006 Frédéric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


module Geekast
  module View


    class TreeviewLib

      def initialize
        @treeview.model = @channel_model
        create_columns_row(@treeview)
      end


      def model_line(iter_line)
        # fill model 
        iter = @model.append
        
        @treeview_ColumnType.each do |key, value|
          case value
          when "text"
            iter[@treeview_ColumnNum[key.to_sym]] = iter_line[key.to_sym]
          when "int"
            iter[@treeview_ColumnNum[key.to_sym]] = iter_line[key.to_sym].to_i
          end
        end
        #        @treeview.queue_draw
        #        sleep(0.5)
      end



      
      def clear_tree
        @model.clear
      end



      def hide_column(treeview, column_name)
        puts "column : " + column_name if $DEBUG
        puts "treecol : " + @treeview_ColumnNum[column_name.to_sym].to_s if $DEBUG

        treeview_column = treeview.get_column(@treeview_ColumnNum[column_name.to_sym])

        puts "hide : " + treeview_column.title if $DEBUG

        treeview_column.visible=false
      end


      def show_column(treeview, column_name)
        puts "column : " + column_name if $DEBUG
        puts "treecol : " + @treeview_ColumnNum[column_name.to_sym].to_s if $DEBUG

        treeview_column = treeview.get_column(@treeview_ColumnNum[column_name.to_sym])

        puts "show : " + treeview_column.title if $DEBUG

        treeview_column.visible=true
      end


      def create_columns_row(treeview)
        aColumns = @treeview_ColumnNum.sort_by {|a| a.reverse}

        aColumns.each do |name, col|
          column = Gtk::TreeViewColumn.new(name.to_s,
                                           Gtk::CellRendererText.new, {:text => col})
          column.resizable = true
          column.sort_column_id = col
          treeview.insert_column(column, col)
        end
      end  

  
    end
  end
end
