#  interface.rb -
#  Copyright (C) 2004-2006 Frédéric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

require 'net/http'
require 'geekast/views/lib/treeview'
require 'geekast/views/lib/glade_base'
require 'gtkmozembed'

# Sig
require 'geekast/lib/signal'


module Geekast
  module View


    class TreeviewChannel < TreeviewLib
      attr_reader :treeview_ColumnNum

      def initialize(treeview)
        @filter = ""
        @col = 0

        @treeview = treeview

        @model = Gtk::ListStore.new(String, String,
                                    Integer, String,
                                    String,  String,
                                    String, Integer,
                                    String, Integer,
                                    Integer)

        @treeview_ColumnType = {
          :name => "text",
          :id => "text",
          :bitrate => "int",
          :type => "text",
          :genre => "text",
          :desc => "text",
          :url => "text",
          :uptime => "int",
          :comment => "text",
          :skips => "int",
          :age => "int"
        }

        @treeview_ColumnNum = {
          :name => 0,
          :id => 1,
          :bitrate => 2,
          :type => 3,
          :genre => 4,
          :desc => 5,
          :url => 6,
          :uptime => 7,
          :comment => 8,
          :skips => 9,
          :age => 10
        }


        # Filter station according to the filter toolbar widgets.
        @filtered_model = Gtk::TreeModelFilter.new(@model)




        @filtered_model.set_visible_func do |model, iter|

          if @col == 3 && @filter == "Audio"
            regexp = Config::AUDIO_TYPE
          elsif @col == 3 && @filter == "Video"
            regexp = Config::VIDEO_TYPE
          else
            regexp = Regexp.new(@filter, true, "U")
          end

          if regexp =~ "- all genres -" || regexp =~ "- any type -"
            true
          else
            regexp =~ iter[@col] if iter[@col]
          end
        end

        @channel_model = Gtk::TreeModelSort.new(@filtered_model)
        super()
      end


      def change_filter(col, filter)
        @col = col
        @filter = filter
        @filtered_model.refilter
        #        puts "filter = " + @filter
      end


    end


    class TreeviewBookmark < TreeviewLib
      attr_reader :treeview_ColumnNum

      def initialize(treeview)
        @treeview = treeview

        @model = Gtk::ListStore.new(String, String,
                                    String, String,
                                    Integer, String,
                                    String)

        @treeview_ColumnType = {
          :name => "text",
          :type => "text",
          :url => "text",
          :id => "text",
          :bitrate => "int",
          :desc => "text",
          :genre => "text"
        }

        @treeview_ColumnNum = {
          :name => 0,
          :type => 1,
          :url => 2,
          :id => 3,
          :bitrate => 4,
          :desc => 5,
          :genre => 6
        }

        @channel_model = @model
        super()
      end
    end



    class TreeviewConnections < TreeviewLib

      def initialize(treeview)
        @treeview = treeview

        @model = Gtk::ListStore.new(String, String,
                                    String, String,
                                    String, String)

        @treeview_ColumnType = {
          :agent => "text",
          :ipport => "text",
          :kbits => "text",
          :status => "text",
          :time => "text",
          :type => "text"
        }

        @treeview_ColumnNum = {
          :agent => 0,
          :ipport => 1,
          :kbits => 2,
          :status => 3,
          :time => 4,
          :type => 5
        }

        @channel_model = @model
        super()
        @treeview.headers_clickable = false
      end
    end


  class TreeviewInfoInformation < TreeviewLib

      def initialize(treeview)
        @treeview = treeview

        @model = Gtk::ListStore.new(String, String,
                                    String, String)

        @treeview_ColumnType = {
          :uptime => "text",
          :channel_cache => "text",
          :firewalled => "text",
          :gnethostcache => "text",
        }

        @treeview_ColumnNum = {
          :uptime => 0,
          :channel_cache => 1,
          :firewalled => 2,
          :gnethostcache => 3
        }

        @channel_model = @model
        super()
      end
    end

  class TreeviewInfoBandwidth < TreeviewLib

      def initialize(treeview)
        @treeview = treeview

        @model = Gtk::ListStore.new(String, String,
                                    String, String)

        @treeview_ColumnType = {
          :name => "text",
          :id => "text",
          :bitrate => "text",
          :type => "text",
        }

        @treeview_ColumnNum = {
          :name => 0,
          :id => 1,
          :bitrate => 2,
          :type => 3,
        }

        @channel_model = @model
        super()
      end
    end

  class TreeviewInfoConnections < TreeviewLib

      def initialize(treeview)
        @treeview = treeview

        @model = Gtk::ListStore.new(String, String)


        @treeview_ColumnType = {
          :name => "text",
          :id => "text",
        }

        @treeview_ColumnNum = {
          :name => 0,
          :id => 1,
        }

        @channel_model = @model
        super()
      end
    end



  class TreeviewRoster < TreeviewLib

      def initialize(treeview)
        @treeview = treeview

        @model = Gtk::ListStore.new(String)

        @treeview_ColumnType = {
          :nickname => "text"
        }

        @treeview_ColumnNum = {
          :nickname => 0
        }

        @channel_model = @model
        super()
      end
    end







    class ContextualMenu < GladeBase

      def initialize(treeview_init, menu_glade, url, model)
        puts "context ok" if $DEBUG
        super("geekast.glade", menu_glade)
        @sig = Sig.instance
        @treeview = treeview_init
        @menu = instance_eval("@" + menu_glade.intern.to_s)
        @id
        @resp
        @data
        @@url = url
        @model = model

        @multimedia = Geekast::Multimedia.main
      end


      def on_webchat_activate
        get_id
        url = "http://" + Config::YELLOWPAGES_IP + ":" + Config::YELLOWPAGES_PORT + "/getchat?id=" + @id.to_s
        @sig.emit("CrefreshWeb", url)
      end

      def on_jabberchat_activate
        liststore = @treeview.model
        rowselected = @treeview.selection

        # liststore.each do |model,path,iter|
        #  printf("Row %s: %s\n", path.to_str, iter[3]);
        # end
        rowselected.selected_each do |model,path,iter|
          # printf("Row %s: %s\n", path.to_str, iter[@model.treeview_ColumnNum[:name]])
          name = iter[@model.treeview_ColumnNum[:name]]
          #          printf("name : %s\n", name.tr(' ',''))

          channel = name.tr(' ','').tr('/','').tr('@','').strip

          @sig.emit("VjabberNotebook", channel[0..20])
        end

      end

      def on_stats_activate
        get_id
        url = "http://" + Config::YELLOWPAGES_IP + ":" + Config::YELLOWPAGES_PORT + "/getgmt?id=" + @id.to_s
        @sig.emit("CrefreshWeb", url)
      end



      def on_bookmark_activate
        puts("add to bookmark...\n") if $DEBUG
        liststore = @treeview.model
        rowselected = @treeview.selection

        # liststore.each do |model,path,iter|
        #  printf("Row %s: %s\n", path.to_str, iter[3]);
        # end

        rowselected.selected_each do |model,path,iter|

          flux = {"channel" =>
              {:name => iter[@model.treeview_ColumnNum[:name]],
              :url => iter[@model.treeview_ColumnNum[:url]],
              :type => iter[@model.treeview_ColumnNum[:type]],
              :id => iter[@model.treeview_ColumnNum[:id]],
              :desc => iter[@model.treeview_ColumnNum[:desc]],
              :bitrate => iter[@model.treeview_ColumnNum[:bitrate]],
              :genre => iter[@model.treeview_ColumnNum[:genre]]
            }
          }
          @sig.emit("CbookmarkAdd", flux)
          @sig.emit("CrefreshNB", Config::BOOKMARK)
        end

      end




      def on_play_activate
        @geekastConfig = Geekast::Model::Preferences.instance

        # test ARGV url
        if !@@url
          liststore = @treeview.model
          rowselected = @treeview.selection

          rowselected.selected_each do |model,path,iter|
            printf("Row %s: %s\n", path.to_str, iter[@model.treeview_ColumnNum[:id]]) if $DEBUG

            ####################################################
            @@url = "http://" + @geekastConfig.ip + ":" + @geekastConfig.port.to_i.to_s + "/stream/" +  iter[@model.treeview_ColumnNum[:id]]
            #          url = "http://" + Geekast::Config::PEERCAST_IP
            #          url = "http://127.0.0.1"
            # link = "/stream/" +  iter[3]
            ####################################################
          end
        end

        if @@url
          if @geekastConfig.internal_player == FALSE
            Thread.new {
              system(@geekastConfig.player  + " " + @geekastConfig.player_options + " " + @@url)
            }
          else
            @multimedia.create(@@url)
          end
        end
        @@url = nil
      end

      def on_web_activate
        liststore = @treeview.model
        rowselected = @treeview.selection

        # liststore.each do |model,path,iter|
        #  printf("Row %s: %s\n", path.to_str, iter[3]);
        # end
        rowselected.selected_each do |model,path,iter|
          printf("Row %s: %s\n", path.to_str, iter[@model.treeview_ColumnNum[:url]]) if $DEBUG
          url = iter[@model.treeview_ColumnNum[:url]]
          printf("url : %s\n", url) if $DEBUG

          if url
            Thread.new {
              system("gnome-open " + '"' + url + '"')
            }
          end
        end
      end


      def on_keep_activate
        get_id
        url = "/admin?cmd=keep&id=" + @id.to_s
        http_command(url)
      end

      def on_bump_activate
        get_id
        url = "/admin?cmd=bump&id=" + @id.to_s
        http_command(url)
      end

      def on_stop_activate
        get_id
        url = "/admin?cmd=stop&id=" + @id.to_s
        http_command(url)
        @sig.emit("CrefreshNB", Config::RELAY)
      end


      def on_info_activate
        get_id
        url = Config::PEERCAST_RELAY + @id.to_s
        ChannelInfo.new(url)
      end


      def popup
        # Popup the menu on right click
        @treeview.signal_connect("button_press_event") do |widget, event|
          if event.kind_of? Gdk::EventButton and event.button == 3
            @menu.popup(nil, nil, event.button, event.time)
          end
        end

        # Popup the menu on Shift-F10
        @treeview.signal_connect("popup_menu") { @menu.popup(
                                                             nil,
                                                             nil,
                                                             0,
                                                             Gdk::Event::CURRENT_TIME) }

      end


      def sensitive(bool)
        if bool == 1
          item = @menu.active
          item.sensitive = false
        elsif bool == 0
          item = @menu.active
          item.sensitive = true
        end
      end


      def on_delete_activate
        liststore = @treeview.model
        rowselected = @treeview.selection
        if iter = rowselected.selected
          liststore.remove(iter)
        end

        # flush bookmark
        @sig.emit("CbookmarkDel", 0)

        liststore.each do |model,path,iter|
          flux = {"channel" =>
              {:name => iter[@model.treeview_ColumnNum[:name]],
              :url => iter[@model.treeview_ColumnNum[:url]],
              :type => iter[@model.treeview_ColumnNum[:type]],
              :id => iter[@model.treeview_ColumnNum[:id]],
              :desc => iter[@model.treeview_ColumnNum[:desc]],
              :bitrate => iter[@model.treeview_ColumnNum[:bitrate]],
              :genre => iter[@model.treeview_ColumnNum[:genre]]
            }
          }
          @sig.emit("CbookmarkAdd", flux)
        end
        @sig.emit("CrefreshNB", Config::BOOKMARK)
      end


      #######
      private
      #######

      def get_id
        liststore = @treeview.model
        rowselected = @treeview.selection

        # liststore.each do |model,path,iter|
        #  printf("Row %s: %s\n", path.to_str, iter[3]);
        # end
        rowselected.selected_each do |model,path,iter|
          #          printf("Row %s: %s\n", path.to_str, iter[5]);
          #          url = "http://localhost:7144/admin?cmd=keep&id=" +  iter[5]
          # printf("url : %s\n", url)

          id = @model.treeview_ColumnNum[:id]

          @id = iter[id]
        end

      end

      def http_command(url)
        @geekastConfig = Geekast::Model::Preferences.instance

        @peercast_connect = Net::HTTP.new(@geekastConfig.ip,
                                          @geekastConfig.port.to_i.to_s)


        begin
          puts url if $DEBUG

          req = Net::HTTP::Get.new(url)
          req.basic_auth('', @geekastConfig.password)
          @data = @peercast_connect.request(req).body
        # @resp, @data = @peercast_connect.get(url, nil )
        rescue
          puts "http command error"
          return false
        end
      end

    end


    class Connections

      def initialize
      end


      def refresh_connection(url)
      @geekastConfig = Geekast::Model::Preferences.instance


        @peercast_connections = Net::HTTP.new(@geekastConfig.ip,
                                              @geekastConfig.port.to_i.to_s)



        begin
          puts url if $DEBUG

          @resp, @data = @peercast_connections.get(url, nil )
        rescue
          puts "http refresh connections error"
          return false
        end
      end
    end





    class GeekastTrayIcon < GladeBase

      def initialize(main_window)
        super("geekast.glade", "menu_trayicon")
        @geekastConfig = Geekast::Model::Preferences.instance
        @multimedia = Multimedia.main
        @sig = Sig.instance

        @hItem = Hash.new
        @aItemRC, @aItemYP, @aItemBK = [], [], []

        @url = "http://#{@geekastConfig.ip}:#{@geekastConfig.port.to_i.to_s}/stream/"

        @tray = Gtk::StatusIcon.new
        icon = Gdk::Pixbuf.new(Config::DATA_DIR + "/pixmaps/small-icon.gif")
        @tray.set_pixbuf(icon)
        @tray.signal_connect("activate"){
          !main_window.visible? == true ? main_window.show : main_window.hide
        }
        @tray.signal_connect("popup-menu"){|w, button, activate_time|
          @menu_trayicon.popup(nil, nil, button, activate_time)
        }
        init_bookmark
      end

      def on_stop_clicked
        @multimedia.stop
      end

      def init_bookmark
        @menu_trayicon.active = 3
        @item = @menu_trayicon.active
        @hItem[@item] = @aItemBK
      end


      def on_refresh_rc_activate
        @item = @menu_trayicon.active
        clean(Config::RELAY)

        @sig.emit("CrefreshNB", Config::RELAY)
      end

      def on_refresh_yp_activate
        @item = @menu_trayicon.active
        clean(Config::YP)

        @sig.emit("CrefreshNB", Config::YP)
      end


      def clean(notebook)
        case notebook
        when Config::RELAY
          @menu_trayicon.active = 2
          @item = @menu_trayicon.active
          if @hItem[@item]
            while @hItem[@item].length != 0 do
              @hItem[@item].pop.destroy
            end
            @hItem[@item].clear
          else
            @hItem[@item] = @aItemRC
          end
        when Config::YP
          @menu_trayicon.active = 4
          @item = @menu_trayicon.active
          if @hItem[@item]
            while @hItem[@item].length != 0 do
              @hItem[@item].pop.destroy
            end
            @hItem[@item].clear
          else
            @hItem[@item] = @aItemYP
          end
        end
      end


      def append(channel)
        message("refresh")
        menu = @item.submenu
        item = Gtk::MenuItem.new(channel[:name])
        @hItem[@item].push(item)

        menu.append(item)
        item.signal_connect("activate") {
          url = @url + channel[:id]
          if @geekastConfig.internal_player == FALSE
            Thread.new {
              system(@geekastConfig.player  + " " + @geekastConfig.player_options + " " + url)
            }
          else
            @multimedia.create(url)
          end
        }
        menu.show_all
      end


      def message(msg)
        @tray.set_tooltip(msg)
      end

      def cancel
        @tray.cancel_message(@id_msg)
      end
      def on_quit_activate
        @multimedia.stop
        Gtk.main_quit
      end

    end



  end
end
