#  interface.rb - 
#  Copyright (C) 2004-2007 Frdric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


require 'xmpp4r'
require 'xmpp4r/muc/helper/simplemucclient'
require 'xmpp4r/version/helper/simpleresponder'

# Sig
require 'geekast/lib/signal'



module Geekast
  module Model
    
    class IM
      def initialize
        @sig = Sig.instance
        puts "Jabber singleton launched" if $DEBUG        

        @stack_muc = Array.new

        @geekastConfig = Geekast::Model::Preferences.instance

        im_connect
#        Geekast::Sig.new
        @sig.connect('MjabberChat', ['Integer', 'String']) {|channel, data|
          on_entry_chat_activate(channel, data)          
        }
      end 

      def error_dialog(msg)
        @sig.emit("CjabberError", msg)        
      end
      
      def print_buffer(channel, s, time=nil)
          @sig.emit("CjabberBuffer", channel, s, time)
        #          @textview_buffer.buffer.insert(@textview_buffer.buffer.end_iter, "[#{(time || Time.new).getlocal.strftime('%I:%M')}] #{s}\n")
        #          va = @scrolledwindow_buffer.vadjustment
        #          va.value = va.upper
      end

      
      def im_connect
        @jid = Jabber::JID.new(@geekastConfig.jid)
        @client = Jabber::Client.new(@jid)        
      end        
      
      
    
      def connect(index, room)
        muc = room + '@' + @geekastConfig.jabserver
        puts muc if $DEBUG
      
        mucjid = Jabber::JID.new(muc)

        if @jid.node.nil?
          error_dialog("Your Jabber ID must contain a user name and therefore contain one @ character.")
#        elsif @jid.resource
#          error_dialog("If you intend to set a custom resource, put that in the right text field. Remove the slash!")
        elsif @geekastConfig.jabresource.empty?
          error_dialog("Please set a resource. This is a somewhat unimportant setting...")
        elsif mucjid.node.nil?
          error_dialog("Please set a room name, e.g. myroom@conference.jabber.org")
        elsif mucjid.resource
          error_dialog("The MUC room must not contain a resource. Remove the slash!")
        elsif @geekastConfig.jabnick.empty?
          error_dialog("Please set a nick for MUC.")
        else
          @jid.resource = @geekastConfig.jabressource
          mucjid.resource = @geekastConfig.jabnick
          password = @geekastConfig.jidpass
          
          print_buffer(index, "Welcome to the Geekast Multi-User Chat client")
          print_buffer(index, "Commands start with a slash, type \"/help\" for a list")
        


          Jabber::Version::SimpleResponder.new(@client, "Geekast based on XMPP4R ", Jabber::XMPP4R_VERSION, IO.popen("uname -sr").readlines.to_s.strip)
          Thread.new {
            begin
              print_buffer(index, "Connecting for domain #{@jid.domain}...")
              @client.connect
              print_buffer(index, "Authenticating for #{@jid.strip}...")
              @client.auth(password)
              print_buffer(index, "Attempting to join #{mucjid.strip} as #{mucjid.resource}...")
              @muc = Jabber::MUC::SimpleMUCClient.new(@client)
              @stack_muc[index] = @muc
              register_handlers(index)
               @stack_muc[index].join(mucjid)
            rescue Exception => e
              puts "#{e.class}: #{e}\n#{e.backtrace.join("\n")}"
              print_buffer(index, "Error: #{e}")
            end
          }
        end
          

        
      def register_handlers(index)
        @stack_muc[index].on_room_message { |time,text|
          print_buffer(index,"*** #{text}", time)
        }
        @stack_muc[index].on_message { |time,nick,text|
          if text =~ /^\/me (.+)$/
            print_buffer(index,"*#{nick} #{$1}", time)
          else
            print_buffer(index,"<#{nick}> #{text}", time)
          end
        }
        @stack_muc[index].on_private_message { |time,nick,text|
          print_buffer(index, "<-(#{nick}) #{text}", time)
        }
        @stack_muc[index].on_join { |time,nick|
#          @roster.append[0] = nick
          @sig.emit("CjabberRoster", index, nick)
        }
        @stack_muc[index].on_self_leave { |time|
          print_buffer(index, "You have exited the room", time)
        }
#        @muc.on_leave { |time,nick|
#          del_iter = nil
#          @roster.each { |m,p,iter|
#            del_iter = iter if iter[0] == nick
#          }
#          @roster.remove(del_iter) if del_iter
#        }
        @stack_muc[index].on_subject { |time,nick,subject|
          #          @topic.text = subject
          @sig.emit("CjabberTopic", index, subject)        
        }
      end
        
        
        
          
      def on_entry_chat_activate(channel, line)
        commands = {
          'help' => [
                     'Display this help',
                     lambda {
                       commands.each { |cmd,a|
                         print_buffer(channel, "/#{cmd.ljust(10)} - #{a[0]}")
                       }
                     }
                    ],
          'msg' => [
                    'Send a private message to a user',
                    lambda { |args|
                      # Limitation: it is not possible to send private messages
                      # to a user with a space in his nickname
                      to = args.shift
                      text = args.join(' ')
                      @stack_muc[channel].say(text, to)
                      print_buffer(channel, "->(#{to}) #{text}")
                    }
                   ],
          'subject' => [
                        'Change the room\'s subject',
                        lambda { |args|
                          @stack_muc[channel].subject = args.join(' ')
                        }
                       ],
          'quit' => [
                     'Leave room with optional message, then disconnect client and shut down',
                     lambda { |args|
                       @stack_muc[channel].exit(args.join(' ')) if @stack_muc[channel].active?
                       @client.close
                     }
                    ]
        }
        
        if line =~ /^\//
          args = line.split(/ /)
          cmd = args.shift[1..-1].downcase
          
          command = commands[cmd]
          if command
            help, func = command
            func.call(args)
          else
            print_buffer(channel, "Unknown command: #{cmd}, use \"/help\"")
          end
        else
          @stack_muc[channel].say(line)
        end
      end
    end
    
  end
end
end
