=begin
  gstreamer.rb - 
  Copyright (c) 2004-2005 Frdric Logier
=end

require 'gst'

module Geekast
  module Multimedia

    class GeekastStream
 #     attr_reader :streamthread

      def initialize
        Gst.init

      end 


      def create
#        pipeline = Gst::Pipeline.new
        # Initialize pipeline.
        @pipeline = Gst::Thread.new
        @pipeline.signal_connect('eos') do
          @pipeline.stop
          stream
        end
        
      end


      def play(url)
        open_stream(url)
        pipeline.play
      end


      def stop
        pipeline.stop
      end

      #######
      private
      #######



      def element_mp3_dec
        decoder = Gst::ElementFactory.make("mad", "decoder")

      end


      def element_vorbis_dec
        decoder = Gst::ElementFactory.make("vorbisdec", "decoder")
      end

      def audio_sink
        audiosink = Gst::ElementFactory.make("alsasink")
      end

      def open_stream(url)
        # create a disk reader
        filesrc = Gst::ElementFactory.make("filesrc")
        filesrc.location = url
      end


      def play
        (@pipeline.paused?) ? @pipeline.play : play_track(0)
      end
      
      def pause
        @pipeline.pause if @pipeline.playing?
      end
      
      def stop
        unless @pipeline.stopped?
          @pipeline.stop 
          @current_track = @next_track = 0
        end
      end
      

      def stream
        # Create GStreamer elements.
        @filesrc = Gst::ElementFactory.make("filesrc")
        @filesrc.location = @playlist[@current_track]
        @spider = Gst::ElementFactory.make("spider")
        @audiosink = Gst::ElementFactory.make("alsasink")
        
        # Link pads.
        @filesrc >> @spider >> @audiosink
        
        # Add element to the pipeline.
        @pipeline.clear
        @pipeline.add(@filesrc, @spider, @audiosink)
        @pipeline.play
        
        @current_track = @next_track
        refresh_playlist
      end
      

  end
end
