#  connection.rb -
#  Copyright (C) 2004-2007 Frdric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

require 'timeout'
require 'ftools'
require 'net/http'
require 'open-uri'
require 'rexml/document'
require 'rexml/streamlistener'
# Sig
require 'geekast/lib/signal'

include REXML

module Geekast
  module Model


    class YPListener
      include GetText
      include StreamListener
      attr_reader :counter

      def initialize(attribut, signal)
        bindtextdomain(Geekast::TEXTDOMAIN, nil, nil, "UTF-8")
        @sig = Sig.instance
        @attribut = attribut
        @channel_flag = 0
        @track_flag = 0
        @signal = signal
        @last_title = nil
        @counter = 0
        @total = 0
        @tagStack = Array.new
      end

      def tag_start name, attrs
        case name
        when "servent"
          puts " server uptime : " + attrs["uptime"] if $DEBUG

          #        when "channels_relayed"
          #          @tagStack.push = "channels_relayed"

        when @attribut
          @channel_flag = 1
          @total = attrs["total"].to_i

        when "channel"
          if @channel_flag == 1

            array_channel = {
              :name => attrs["name"],
              :id => attrs["id"],
              :bitrate => attrs["bitrate"],
              :type => attrs["type"],
              :genre => attrs["genre"],
              :desc => attrs["desc"],
              :url => attrs["url"],
              :uptime => attrs["uptime"],
              :comment => attrs["comment"],
              :skips => attrs["skips"],
              :age => attrs["age"]
            }

            @counter += 1
            @sig.emit(@signal, array_channel, @counter, @total)
            @name = attrs["name"]
          end

        when "relay"
          if attrs["status"] == "RECEIVE" || attrs["status"] == "BROADCAST" and attrs["listeners"] != '0'
            @track_flag = 1
          end


        when "track"
          if @track_flag == 1
            title =  _("[Title] : ") + attrs["title"] + _(" [Artist] : ") + attrs["artist"] + _(" [Album] : ") + attrs["album"]

            @sig.emit("CnotifyBAR", title, @name)
            @track_flag = 0
          end

        when "text"
          puts "text" if $DEBUG



      end


    end
    # Called when the end tag is reached.  In the case of <tag/>, tag_end
    # will be called immidiately after tag_start
    # @p the name of the tag
    def tag_end name
      # puts "tag_end : " + name

      case name
#      when "channels_relayed"
#          @tagStack.pop

#          begin
#          when "channels_found"
        when @attribut
    #      puts "end channels_relayed"
          @channel_flag = 0
          end
#          rescue
#          print "DOWN\n"
#        end
      end
      # Called when text is encountered in the document
      # @p text the text content.
      def text text
        # puts "text : " + text
      end
      def elementdecl(content)
        # puts "elements : " + content
      end
      def xmldecl(version, encoding, standalone)
        # puts "xmldecl : "
      end


    end




    class ChanInfo
      include StreamListener

      def initialize(signal)
        @sig = Sig.instance
        @signal = signal
      end

      def tag_start name, attrs
        case name
        when "relayinfo"
          array_channelinfo = {
            :name => attrs["name"],
            :cgenre => attrs["cgenre"],
            :desc => attrs["desc"],
            :url => attrs["url"],
            :comment => attrs["comment"],
            :id => attrs["id"],
            :type => attrs["type"],
            :bitrate => attrs["bitrate"],
            :source => attrs["source"],
            :uptime => attrs["uptime"],
            :status => attrs["status"],
            :position => attrs["position"],
            :head => attrs["head"],
            :artist => attrs["artist"],
            :title => attrs["title"],
            :album => attrs["album"],
            :tgenre => attrs["tgenre"],
            :contact => attrs["contact"]
          }
          @sig.emit(@signal, array_channelinfo)
        end
      end
    end



    class ConnectionListener
      include StreamListener

      def initialize(signal)
        @sig = Sig.instance
        @signal = signal
      end

      def tag_start name, attrs
        case name
        when "line"
          array_connections = {
            :agent => attrs["agent"],
            :ipport => attrs["ipport"],
            :kbits => attrs["kbits"],
            :status => attrs["status"],
            :time => attrs["time"],
            :type => attrs["type"]
          }
          @sig.emit(@signal, array_connections)
        end
      end
    end


    class InfoInformationListener
      include StreamListener

      def initialize(signal)
        @sig = Sig.instance
        @signal = signal
      end

      def tag_start name, attrs
        case name
        when "information"
          array_information = {
            :uptime => attrs["uptime"],
            :channel_cache => attrs["channel_cache"],
            :firewalled => attrs["firewalled"],
            :gnethostcache => attrs["gnethostcache"]
          }

        when "bandwidth"
          array_bandwidth = {
            :totalin => attrs["totalin"],
            :totalout => attrs["totalout"],
            :total => attrs["total"],
            :internetin => attrs["internetin"],
            :internetout => attrs["internetout"],
            :internettotal => attrs["internettotal"],
            :gnetin => attrs["gnetin"],
            :gnetout => attrs["gnetout"],
            :gnettotal => attrs["gnettotal"],
            :gnetpacketsin => attrs["gnetpacketsin"],
            :gnetpacketsout => attrs["gnetpacketsout"],
            :gnetpacketstotal => attrs["gnetpacketstotal"]
          }

        when "connections"
          array_connections = {
            :direct => attrs["direct"],
            :relay => attrs["relay"],
            :cincout => attrs["cincout"],
            :pgnu => attrs["pgnu"],
            :incoming => attrs["incoming"],
            :port1 => attrs["port1"],
            :port2 => attrs["port2"],
            :port1active => attrs["port1active"],
            :port2active => attrs["port2active"]
          }

        when "internal"
          array_internal = {
            :version => attrs["version"],
            :rootmsg => attrs["rootmsg"],
            :serverip => attrs["serverip"],
            :localip => attrs["localip"],
            :serverport => attrs["serverport"],
            :serverport1 => attrs["serverport1"]
          }
        end
        @sig.emit(@signal, array_information, array_bandwidth, array_connections, array_internal)
      end
    end




    class PeercastConnection
      def initialize
        @geekastConfig = Geekast::Model::Preferences.instance
        @sig = Sig.instance
      end

      def connect(connectionParam)
        puts connectionParam[:signal] if $DEBUG

        @path_file = Geekast::Config::HOME_USER + "/.geekast/" + connectionParam[:signal]
        puts @path_file if $DEBUG
        #        timeout(8) {
        http_connect = Net::HTTP.new(connectionParam[:ip], connectionParam[:port])
        #        }

        begin
          #            status = timeout(5) {

          req = Net::HTTP::Get.new(connectionParam[:url])
          if connectionParam[:numpage] != 4
            req.basic_auth('', @geekastConfig.password)
          end
          puts "OK" if $DEBUG

          @data = http_connect.request(req).body

          #            @http_connect.request(req).body
          # resp, @data = @http_connect.get(@url, nil )
          #         }

        rescue
          alert = "http get error on " + Config::PEERCAST_IP + " : " + $!
          return alert
        end

        File.makedirs Geekast::Config::HOME_USER + '/.geekast'
        f = File.new(@path_file, "w")
        f.syswrite(@data)
        f.close()
        return "true"
      end


      def parse_xml(connectionParam)
        case connectionParam[:numpage]
        when Config::CONNECTION
          handler = ConnectionListener.new(connectionParam[:signal])
#          @sig.emit("CxmlParse", -1)
          puts "emit CxmlParse 0" if $DEBUG
          begin
            REXML::Document.parse_stream((File.new @path_file), handler)
          rescue
          end

        @sig.emit("CxmlParse", 0)
        puts "emit CxmlParse 1" if $DEBUG


        when Config::INFORMATION
          handler = InfoInformationListener.new(connectionParam[:signal])
 #         @sig.emit("CxmlParse", -1)
          puts "emit CxmlParse 0" if $DEBUG
          begin
            REXML::Document.parse_stream((File.new @path_file), handler)
          rescue
            puts "REXML error : " + $!
          end
          @sig.emit("CxmlParse", 0)
          puts "emit CxmlParse 1" if $DEBUG

        when Config::YP
          handler = YPListener.new(connectionParam[:attribut], connectionParam[:signal])
  #        @sig.emit("CxmlParse", -1)
          puts "emit CxmlParse 0" if $DEBUG
          begin
            yp_file = open(@path_file)

            REXML::Document.parse_stream((File.new @path_file), handler)
          rescue
            puts "REXML error : " + $!
          end

          @sig.emit("CxmlParse", 0)
          puts "emit CxmlParse 1" if $DEBUG

        when Config::RELAY
          handler = YPListener.new(connectionParam[:attribut], connectionParam[:signal])
  #        @sig.emit("CxmlParse", -1)
          puts "emit CxmlParse 0" if $DEBUG
          begin
            REXML::Document.parse_stream((File.new @path_file), handler)
          rescue
            puts "REXML error : " + $!
          end

          @sig.emit("CxmlParse", 0)
          puts "emit CxmlParse 1" if $DEBUG

        when Config::CHANINFO
          handler = ChanInfo.new(connectionParam[:signal])
          begin
            REXML::Document.parse_stream((File.new @path_file), handler)
          rescue
            puts "REXML error : " + $!
          end
        end

      end
    end


  end
end
