#  signal.rb -
#  Copyright (C) 2004-2007 Frédéric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

require 'glib2'
require 'singleton'

  class Sig < GLib::Object
    include Singleton

    @@signalStackConnect = Hash.new
    @@signalStackBlock = Hash.new

    type_register

    def initialize
      super(nil)
    end

    def emit(signal_name, *data)
      begin
        signal_emit(signal_name, *data)
      rescue => e
        puts "Alert : signal_emit exception on the signal named " + signal_name + " !"
        puts "Exception : " + e.to_str
        puts "Backtrace :"
        puts e.backtrace
      end
    end


    def disconnect(handler_id)
      begin
        signal_handler_disconnect(handler_id)
      rescue => e
        puts "Alert : signal_disconnect exception on the handler id " + handler_id.to_s + " !"
        puts "Exception : " + e.to_str
        puts "Backtrace :"
        puts e.backtrace
      end
    end



    def handler_block(handler_id)
      unless @@signalStackBlock[handler_id]
        @@signalStackBlock[handler_id] = 1
      else
        @@signalStackBlock[handler_id] += 1
      end
      puts "SIGNAL block : " + @@signalStackBlock[handler_id].to_s if $DEBUG
      signal_handler_block(handler_id)
    end

    def handler_unblock(handler_id)
      puts "SIGNAL unblock : " + @@signalStackBlock[handler_id].to_s if $DEBUG
      @@signalStackBlock[handler_id].times do
        signal_handler_unblock(handler_id)
      end
      @@signalStackBlock[handler_id] = 0
    end

    def sig_handler_is_connected(handler_id)
      signal_handler_is_connected?(handler_id)
    end




    def method_missing(id, *args, &block)
      method = id.id2name

      if method == 'connect'
        if !@@signalStackConnect[args.first]
          signal_method = 'signal_do_' + args.first
          self.class.send(:define_method, signal_method.to_sym) {}

          signal_generate = "self.class.signal_new(args.first,
                              GLib::Signal::RUN_FIRST,
                              nil,
                              nil,"

          args[1].length.times do |i|
            signal_generate << args[1][i]
            signal_generate << ',' if i < args[1].length - 1
          end
          signal_generate << ')'
          eval signal_generate
          @@signalStackConnect[args.first] = true
        end
        lconnect(args.first, &block)
      end
    end




    #######
    private
    #######


    def lconnect(signal_name)
      begin
        signal_connect(signal_name){|obj, *signal_param|
          yield *signal_param
        }
      rescue => e
        puts "Alert : signal_connect exception on the signal named " + signal_name + " !"
        puts "Exception : " + e.to_str
        puts "Backtrace :"
        puts e.backtrace
      end
    end

  end

