#  callback.rb - 
#  Copyright (C) 2004-2007 Frdric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# Sig
require 'geekast/lib/signal'


module Geekast
  module Controller

    class CallbackMain
      include GetText

      def initialize
        @sig = Sig.instance
        @url = nil
        bindtextdomain(Geekast::TEXTDOMAIN, nil, nil, "UTF-8")
        handlerError
        refreshNB
        refreshYP
        xmlParse
        refreshRelay
        notifyBAR
        refreshBM
        bookmarkAdd
        bookmarkDel
        refreshConnection
        refreshInformation
        getChannelinfo
        returnChannelinfo
        refreshWeb
        jabberConnect
        jabberBuffer
        jabberError
        jabberRoster
        jabberTopic
        jabberChat
      end

      #######
      private
      #######

      def refreshNB
        @SrefreshNB = @sig.connect("CrefreshNB", ['Integer']) {|num_page|
          flag = 0
          puts "CrefreshNB" if $DEBUG
          @sig.handler_block(@SrefreshNB)

          case num_page
          when Config::INFORMATION
            connectionParam = {
              :numpage => num_page,
              :ip => Config::PEERCAST_IP,
              :port => Config::PEERCAST_PORT,
              :url => Config::PEERCAST_INFORMATION,
              :attribut => "",
              :signal => "CrefreshInformation" 
            }
          when Config::RELAY
            connectionParam = {
              :numpage => num_page,
              :ip => Config::PEERCAST_IP,
              :port => Config::PEERCAST_PORT,
              :url => Config::PEERCAST_STATS,
              :attribut => "channels_relayed",
              :signal => "CrefreshRelay"
            }
          when Config::CONNECTION
            connectionParam = {
              :numpage => num_page,
              :ip => Config::PEERCAST_IP,
              :port => Config::PEERCAST_PORT,
              :url => Config::PEERCAST_CONNECTIONS,
              :attribut => "",
              :signal => "CrefreshConnection"
            }
          when Config::YP
            connectionParam = {
              :numpage => num_page,
              :ip => Config::YELLOWPAGES_IP,
              :port => Config::YELLOWPAGES_PORT,
              :url => Config::YELLOWPAGES_URL,
              :attribut => "channels_found",
              :signal => "CrefreshYP" 
            }
          when Config::BOOKMARK
            connectionParam = {
              :numpage => num_page,
              :ip => "bookmark",
              :signal => "CrefreshBM"
            }
          when Config::VIDEO
            connectionParam = {
              :numpage => num_page,
              :ip => Config::PEERCAST_IP,
              :port => Config::PEERCAST_PORT,
              :url => Config::PEERCAST_CONNECTIONS,
              :attribut => "",
              :signal => ""
            }
          when Config::WEB
            @sig.emit("VrefreshWeb", @url)
            flag = 1
          end

          if flag != 1
            # clear treeview
            @sig.emit("VclearTreeview", num_page)

            # notify bar
            @sig.emit("VnotifyBAR", _("connecting to ") + connectionParam[:ip])

            #refresh model
            @sig.emit("MrefreshNB", connectionParam)
          end
          @sig.handler_unblock(@SrefreshNB)
        }

      end

         
      def handlerError
        @flag = false

        @sig.connect("ChandlerError", ['String', 'String']) {|env, msg|
          puts "ChandlerError" if $DEBUG

          case env
          when "httpConnect"
            if msg == "true" && @flag == true
              @sig.emit("VunblockSignal", "VnotifyBAR")
              @flag = false
            elsif msg != "true"
              @sig.emit("VnotifyBAR", msg)
              @sig.emit("VblockSignal", "VnotifyBAR")
              @flag = true
            end
          end
        }
      end


      def refreshBM
        @sig.connect("CrefreshBM", ['Array']) {|data|
          puts "CrefreshBM" if $DEBUG
          @sig.emit("VrefreshBM", data)
        }
      end


      def refreshYP
        @sig.connect("CrefreshYP", ['Array', 'Integer','Integer']) {|data1,data2,data3|
          puts "CrefreshYP" if $DEBUG
          @sig.emit("VrefreshBAR", -1, data2, data3)
          @sig.emit("VrefreshYP", data1,data2,data3)
        }
      end

      def refreshRelay
        @sig.connect("CrefreshRelay", ['Array', 'Integer','Integer']) {|data1,data2,data3|
          puts "CrefreshRelay" if $DEBUG
          @sig.emit("VrefreshBAR", -1, data2, data3)
          @sig.emit("VrefreshRelay", data1,data2,data3)
        }
      end

      def refreshConnection
        @sig.connect("CrefreshConnection", ['Array']) {|data|
          puts "CrefreshConnection" if $DEBUG
          @sig.emit("VrefreshBAR", -1, 0, 0)
          @sig.emit("VrefreshConnection", data)
        }
      end

      def refreshInformation
        @sig.connect("CrefreshInformation", ['Array', 'Array','Array','Array']) {|data1, data2, data3, data4|
          puts "CrefreshInformation" if $DEBUG
          @sig.emit("VrefreshBAR", -1, 0, 0)
          @sig.emit("VrefreshInformation", data1, data2, data3, data4)
        }
      end


      def notifyBAR
        @sig.connect("CnotifyBAR", ['String', 'String']) {|data1, data2|
          puts "CnotifyBAR" if $DEBUG
          @sig.emit("VnotifyBAR", data1)
        }
      end


      def xmlParse
        @sig.connect("CxmlParse", ['Integer']) {|data|
          puts "CxmlParse" if $DEBUG
          @sig.emit("VrefreshBAR", data, 0, 0)
        }
      end


      def bookmarkAdd
        @sig.connect("CbookmarkAdd", ['Array']) {|data|
          puts "CbookmarkAdd" if $DEBUG
          @sig.emit("MbookmarkAdd", data)
        }
      end

      def bookmarkDel
        @sig.connect("CbookmarkDel", ['Integer']) {|data|
          puts "CbookmarkDel" if $DEBUG
          @sig.emit("MbookmarkDel", 0)
        }
      end


      def getChannelinfo
        @sig.connect("CgetChannelinfo", ['String']) {|data|
          puts "CgetChannelinfo" if $DEBUG
          
          connectionParam = {
            :numpage => Config::CHANINFO,
            :ip => Config::PEERCAST_IP,
            :port => Config::PEERCAST_PORT,
            :url => data,
            :attribut => "",
            :signal => "CreturnChannelinfo" 
          }
          @sig.emit("MrefreshNB", connectionParam)
        }
      end


      def returnChannelinfo
        @sig.connect("CreturnChannelinfo", ['Array']) {|data|
          puts "CreturnChannelinfo" if $DEBUG          
          @sig.emit("VrefreshChannelInfo", data)
        }
      end

      def refreshWeb
        @sig.connect("CrefreshWeb", ['String']) {|data|
          @url = data
          @sig.emit("VrefreshWeb", data)
        }
      end

      
      def jabberConnect
        @sig.connect("CjabberConnect", ['Integer', 'String']) {|channel, data|
          @sig.emit("MjabberConnect", channel, data)
        }
      end

      def jabberBuffer
        @sig.connect("CjabberBuffer", ['Integer', 'String','Time']) {|channel, buffer, time|
          @sig.emit("VjabberBuffer", channel, buffer, time)
        }
      end

      def jabberError
        @sig.connect("CjabberError", ['String']) {|data|
          @sig.emit("VjabberError", data)
        }
      end
      def jabberRoster
        @sig.connect("CjabberRoster", ['Integer', 'String']) {|channel, data|
          @sig.emit("VjabberRoster", channel, data)
        }
      end
      def jabberTopic
        @sig.connect("CjabberTopic", ['Integer', 'String']) {|channel, data|
          @sig.emit("VjabberTopic", channel, data)
        }
      end
      def jabberChat
        @sig.connect("CjabberChat", ['Integer', 'String']) {|channel, data|
          @sig.emit("MjabberChat", channel, data)
        }
      end
      
      
      
      
    end
    
  end
end
